/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityAllowlistOnly;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockReinforcedLever
extends BlockLever
implements IReinforcedBlock {
    public BlockReinforcedLever() {
        this.func_149672_a(SoundType.field_185848_a);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isAllowedToPress(world, pos, (TileEntityAllowlistOnly)world.func_175625_s(pos), player)) {
            return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, TileEntityAllowlistOnly te, EntityPlayer entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)entity);
    }

    public Material func_149688_o(IBlockState state) {
        return Material.field_151575_d;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAllowlistOnly();
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(Blocks.field_150442_at);
    }
}

