/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.jei;

import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.compat.jei.ReinforcerRecipe;
import net.geforcemods.securitycraft.compat.jei.SecurityCraftToVanillaCategory;
import net.geforcemods.securitycraft.compat.jei.SlotMovers;
import net.geforcemods.securitycraft.compat.jei.VanillaToSecurityCraftCategory;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class SCJEIPlugin
implements IModPlugin {
    public static final String VTS_ID = "securitycraft:vanilla_to_securitycraft";
    public static final String STV_ID = "securitycraft:securitycraft_to_vanilla";

    public void register(IModRegistry registry) {
        ArrayList vtsRecipes = new ArrayList();
        ArrayList stvRecipes = new ArrayList();
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new SlotMovers.CustomizeBlock(), new SlotMovers.Projector(), new SlotMovers.DisguiseModule()});
        registry.addIngredientInfo((Object)new ItemStack(SCContent.adminTool), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.adminTool"});
        registry.addIngredientInfo((Object)new ItemStack(SCContent.keypad), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.keypad"});
        registry.addIngredientInfo((Object)new ItemStack(SCContent.keypadChest), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.keypad_chest"});
        registry.addIngredientInfo((Object)new ItemStack(SCContent.keypadFurnace), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.keypad_furnace"});
        IReinforcedBlock.BLOCKS.forEach(rb -> {
            IReinforcedBlock reinforcedBlock = (IReinforcedBlock)rb;
            reinforcedBlock.getVanillaBlocks().forEach(vanillaBlock -> {
                if (reinforcedBlock.getVanillaBlocks().size() == reinforcedBlock.getAmount()) {
                    int meta = reinforcedBlock.getVanillaBlocks().indexOf(vanillaBlock);
                    vtsRecipes.add(new ReinforcerRecipe(new ItemStack(vanillaBlock, 1, 0), new ItemStack(rb, 1, meta)));
                    stvRecipes.add(new ReinforcerRecipe(new ItemStack(rb, 1, meta), new ItemStack(vanillaBlock, 1, 0)));
                } else {
                    for (int i = 0; i < reinforcedBlock.getAmount(); ++i) {
                        vtsRecipes.add(new ReinforcerRecipe(new ItemStack(vanillaBlock, 1, i), new ItemStack(rb, 1, i)));
                        stvRecipes.add(new ReinforcerRecipe(new ItemStack(rb, 1, i), new ItemStack(vanillaBlock, 1, i)));
                    }
                }
            });
        });
        registry.addRecipes(vtsRecipes, VTS_ID);
        registry.addRecipes(stvRecipes, STV_ID);
        registry.addRecipeCatalyst((Object)new ItemStack(SCContent.keypadFurnace), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(SCContent.universalBlockReinforcerLvL1), new String[]{VTS_ID});
        registry.addRecipeCatalyst((Object)new ItemStack(SCContent.universalBlockReinforcerLvL2), new String[]{VTS_ID, STV_ID});
        registry.addRecipeCatalyst((Object)new ItemStack(SCContent.universalBlockReinforcerLvL3), new String[]{VTS_ID, STV_ID});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new VanillaToSecurityCraftCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SecurityCraftToVanillaCategory(registration.getJeiHelpers().getGuiHelper())});
    }
}

