/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ContainerProjector;
import net.geforcemods.securitycraft.containers.ContainerStateSelectorAccess;
import net.geforcemods.securitycraft.gui.components.ClickButton;
import net.geforcemods.securitycraft.gui.components.GuiSlider;
import net.geforcemods.securitycraft.gui.components.StateSelector;
import net.geforcemods.securitycraft.gui.components.StringHoverChecker;
import net.geforcemods.securitycraft.gui.components.TogglePictureButton;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.tileentity.TileEntityProjector;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiProjector
extends GuiContainer
implements GuiSlider.ISlider {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private static final String SLOT_TOOLTIP = Utils.localize("gui.securitycraft:projector.block", new Object[0]).func_150254_d();
    private TileEntityProjector te;
    private String blockName;
    private StringHoverChecker[] hoverCheckers = new StringHoverChecker[5];
    private StringHoverChecker slotHoverChecker;
    private GuiSlider projectionWidthSlider;
    private GuiSlider projectionHeightSlider;
    private GuiSlider projectionRangeSlider;
    private GuiSlider projectionOffsetSlider;
    private TogglePictureButton toggleButton;
    private StateSelector stateSelector;
    private int sliderWidth = 120;

    public GuiProjector(InventoryPlayer inv, TileEntityProjector te) {
        super((Container)new ContainerProjector(inv, te));
        this.te = te;
        this.blockName = Utils.localize(te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c().func_149739_a() + ".name", new Object[0]).func_150254_d();
        this.field_147000_g = 235;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i += 90;
        int id = 0;
        int left = this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2;
        this.projectionWidthSlider = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider(Utils.localize("gui.securitycraft:projector.width", this.te.getProjectionWidth()).func_150254_d(), this.blockName, id, left, this.field_147009_r + 57, this.sliderWidth, 20, Utils.localize("gui.securitycraft:projector.width", "").func_150254_d(), 1, 10, this.te.getProjectionWidth(), false, true, (GuiSlider.ISlider)this));
        this.projectionWidthSlider.packedFGColour = 0xE0E0E0;
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.projectionWidthSlider, Utils.localize("gui.securitycraft:projector.width.description", new Object[0]).func_150254_d());
        this.projectionHeightSlider = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider(Utils.localize("gui.securitycraft:projector.height", this.te.getProjectionHeight()).func_150254_d(), this.blockName, id, left, this.field_147009_r + 78, this.sliderWidth, 20, Utils.localize("gui.securitycraft:projector.height", "").func_150254_d(), 1, 10, this.te.getProjectionHeight(), false, true, (GuiSlider.ISlider)this));
        this.projectionHeightSlider.packedFGColour = 0xE0E0E0;
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.projectionHeightSlider, Utils.localize("gui.securitycraft:projector.height.description", new Object[0]).func_150254_d());
        this.projectionRangeSlider = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider(Utils.localize("gui.securitycraft:projector.range", this.te.getProjectionRange()).func_150254_d(), this.blockName, id, left, this.field_147009_r + 99, this.sliderWidth, 20, Utils.localize("gui.securitycraft:projector.range", "").func_150254_d(), 1, 30, this.te.getProjectionRange(), false, true, (GuiSlider.ISlider)this));
        this.projectionWidthSlider.packedFGColour = 0xE0E0E0;
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.projectionRangeSlider, Utils.localize("gui.securitycraft:projector.range.description", new Object[0]).func_150254_d());
        this.projectionOffsetSlider = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider(Utils.localize("gui.securitycraft:projector.offset", this.te.getProjectionOffset()).func_150254_d(), this.blockName, id, left, this.field_147009_r + 120, this.sliderWidth, 20, Utils.localize("gui.securitycraft:projector.offset", "").func_150254_d(), -10, 10, this.te.getProjectionOffset(), false, true, (GuiSlider.ISlider)this));
        this.projectionWidthSlider.packedFGColour = 0xE0E0E0;
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.projectionOffsetSlider, Utils.localize("gui.securitycraft:projector.offset.description", new Object[0]).func_150254_d());
        this.toggleButton = (TogglePictureButton)this.func_189646_b((GuiButton)new TogglePictureButton(id, left + this.sliderWidth - 20, this.field_147009_r + 36, 20, 20, TEXTURE, new int[]{176, 192}, new int[]{0, 0}, 2, 2, b -> {
            this.te.setHorizontal(!this.te.isHorizontal());
            this.projectionRangeSlider.updateSlider();
            SecurityCraft.network.sendToServer((IMessage)new SyncProjector(this.te.func_174877_v(), this.te.isHorizontal() ? 1 : 0, SyncProjector.DataType.HORIZONTAL));
        }));
        this.toggleButton.setCurrentIndex(this.te.isHorizontal() ? 1 : 0);
        this.hoverCheckers[id++] = new StringHoverChecker((GuiButton)this.toggleButton, Arrays.asList(Utils.localize("gui.securitycraft:projector.vertical", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:projector.horizontal", new Object[0]).func_150254_d()));
        this.projectionRangeSlider.updateSlider();
        this.slotHoverChecker = new StringHoverChecker(this.field_147009_r + 22, this.field_147009_r + 39, this.field_147003_i + 78, this.field_147003_i + 95, SLOT_TOOLTIP);
        this.stateSelector = new StateSelector((ContainerStateSelectorAccess)this.field_147002_h, this.field_147003_i - 190, this.field_147009_r + 7, 0, 197, 0);
        this.stateSelector.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (StringHoverChecker thc : this.hoverCheckers) {
            if (!thc.checkHover(mouseX, mouseY)) continue;
            this.func_146279_a(thc.getName(), mouseX, mouseY);
        }
        if (this.slotHoverChecker.checkHover(mouseX, mouseY) && this.te.func_191420_l()) {
            this.func_146279_a(this.slotHoverChecker.getName(), mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.blockName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.blockName) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.stateSelector != null) {
            this.stateSelector.func_73863_a(mouseX, mouseY, partialTicks);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.stateSelector != null) {
            this.stateSelector.func_73864_a(mouseX, mouseY, button);
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.stateSelector != null) {
            this.stateSelector.func_146286_b(mouseX, mouseY, state);
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    public List<Rectangle> getExtraAreas() {
        if (this.stateSelector != null) {
            return this.stateSelector.getExtraAreas();
        }
        return new ArrayList<Rectangle>();
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.stateSelector.getState() != null) {
            this.te.setProjectedState(this.stateSelector.getState());
            SecurityCraft.network.sendToServer((IMessage)new SyncProjector(this.te.func_174877_v(), this.stateSelector.getState()));
        }
    }

    @Override
    public void onMouseRelease(int id) {
        int data = 0;
        SyncProjector.DataType dataType = SyncProjector.DataType.INVALID;
        if (id == this.projectionWidthSlider.field_146127_k) {
            data = this.projectionWidthSlider.getValueInt();
            this.te.setProjectionWidth(data);
            dataType = SyncProjector.DataType.WIDTH;
        } else if (id == this.projectionHeightSlider.field_146127_k) {
            data = this.projectionHeightSlider.getValueInt();
            this.te.setProjectionHeight(data);
            dataType = SyncProjector.DataType.HEIGHT;
        } else if (id == this.projectionRangeSlider.field_146127_k) {
            data = this.projectionRangeSlider.getValueInt();
            this.te.setProjectionRange(data);
            dataType = SyncProjector.DataType.RANGE;
        } else if (id == this.projectionOffsetSlider.field_146127_k) {
            data = this.projectionOffsetSlider.getValueInt();
            this.te.setProjectionOffset(data);
            dataType = SyncProjector.DataType.OFFSET;
        }
        SecurityCraft.network.sendToServer((IMessage)new SyncProjector(this.te.func_174877_v(), data, dataType));
    }

    @Override
    public void onChangeSliderValue(GuiSlider slider, String blockName, int id) {
        slider.field_146126_j = this.te.isHorizontal() && slider.field_146127_k == this.projectionRangeSlider.field_146127_k ? slider.prefix + (slider.getValueInt() - 16) : slider.prefix + slider.getValueInt();
    }
}

