/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSonicSecuritySystem
extends ItemBlock {
    public ItemSonicSecuritySystem() {
        super(SCContent.sonicSecuritySystem);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && (te = world.func_175625_s(pos)) instanceof ILockable) {
            if (te instanceof IOwnable && !((IOwnable)te).getOwner().isOwner(player)) {
                Block block = te.func_145838_q();
                if (!(block instanceof BlockDisguisable) || ((BlockDisguisable)block).getDisguisedBlockState((IBlockAccess)world, pos) == null) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.sonicSecuritySystem, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", ((IOwnable)te).getOwner().getName(), pos), TextFormatting.GREEN);
                    return EnumActionResult.SUCCESS;
                }
            } else {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                if (ItemSonicSecuritySystem.isAdded(stack.func_77978_p(), pos)) {
                    ItemSonicSecuritySystem.removeLinkedBlock(stack.func_77978_p(), pos);
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.sonicSecuritySystem, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.blockUnlinked", world.func_180495_p(pos).func_177230_c(), pos), TextFormatting.GREEN);
                    return EnumActionResult.SUCCESS;
                }
                if (ItemSonicSecuritySystem.addLinkedBlock(stack.func_77978_p(), pos, player)) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.sonicSecuritySystem, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.blockLinked", world.func_180495_p(pos).func_177230_c(), pos), TextFormatting.GREEN);
                    if (!world.field_72995_K) {
                        SecurityCraft.network.sendTo((IMessage)new UpdateNBTTagOnClient(stack), (EntityPlayerMP)player);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        if (!stack.func_77942_o() || !ItemSonicSecuritySystem.hasLinkedBlock(stack.func_77978_p())) {
            if (!world.field_72995_K) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.sonicSecuritySystem, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.notLinked", new Object[0]), TextFormatting.DARK_RED);
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        int numOfLinkedBlocks = stack.func_77978_p().func_150295_c("LinkedBlocks", 10).func_74745_c();
        if (numOfLinkedBlocks > 0) {
            tooltip.add(TextFormatting.GRAY + Utils.localize("tooltip.securitycraft:sonicSecuritySystem.linkedTo", numOfLinkedBlocks).func_150254_d());
        }
    }

    public static boolean addLinkedBlock(NBTTagCompound tag, BlockPos pos, EntityPlayer player) {
        if (ItemSonicSecuritySystem.isAdded(tag, pos)) {
            return false;
        }
        NBTTagList list = tag.func_150295_c("LinkedBlocks", 10);
        if (list.func_74745_c() >= 30) {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.sonicSecuritySystem, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.linkMaxReached", 30), TextFormatting.DARK_RED);
            return false;
        }
        NBTTagCompound nbt = NBTUtil.func_186859_a((BlockPos)pos);
        list.func_74742_a((NBTBase)nbt);
        tag.func_74782_a("LinkedBlocks", (NBTBase)list);
        return true;
    }

    public static void removeLinkedBlock(NBTTagCompound tag, BlockPos pos) {
        if (!tag.func_74764_b("LinkedBlocks")) {
            return;
        }
        NBTTagList list = tag.func_150295_c("LinkedBlocks", 10);
        for (int i = list.func_74745_c() - 1; i >= 0; --i) {
            BlockPos posRead = NBTUtil.func_186861_c((NBTTagCompound)list.func_150305_b(i));
            if (!pos.equals((Object)posRead)) continue;
            list.func_74744_a(i);
        }
    }

    public static boolean isAdded(NBTTagCompound tag, BlockPos pos) {
        if (!tag.func_74764_b("LinkedBlocks")) {
            return false;
        }
        NBTTagList list = tag.func_150295_c("LinkedBlocks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            BlockPos posRead = NBTUtil.func_186861_c((NBTTagCompound)list.func_150305_b(i));
            if (!pos.equals((Object)posRead)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLinkedBlock(NBTTagCompound tag) {
        if (!tag.func_74764_b("LinkedBlocks")) {
            return false;
        }
        return tag.func_150295_c("LinkedBlocks", 10).func_74745_c() > 0;
    }
}

