/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import java.util.Calendar;
import net.geforcemods.securitycraft.blocks.BlockKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityKeypadChestRenderer
extends TileEntitySpecialRenderer<TileEntityKeypadChest> {
    private static final ResourceLocation christmasDouble = new ResourceLocation("securitycraft:textures/entity/chest/christmas_double.png");
    private static final ResourceLocation normalDoubleUnactive = new ResourceLocation("securitycraft:textures/entity/chest/double_chest_unactive.png");
    private static final ResourceLocation normalDoubleActive = new ResourceLocation("securitycraft:textures/entity/chest/double_chest_active.png");
    private static final ResourceLocation christmasNormal = new ResourceLocation("securitycraft:textures/entity/chest/christmas.png");
    private static final ResourceLocation normalSingleUnactive = new ResourceLocation("securitycraft:textures/entity/chest/chest_unactive.png");
    private static final ResourceLocation normalSingleActive = new ResourceLocation("securitycraft:textures/entity/chest/chest_active.png");
    private static final ModelChest smallModel = new ModelChest();
    private static final ModelChest largeModel = new ModelLargeChest();
    private boolean isChristmas;

    public TileEntityKeypadChestRenderer() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public void render(TileEntityKeypadChest te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int meta;
        if (!te.func_145830_o()) {
            meta = 0;
        } else {
            Block block = te.func_145838_q();
            meta = te.func_145832_p();
            if (block instanceof BlockKeypadChest) {
                ((BlockKeypadChest)block).checkForSurroundingChests(te.func_145831_w(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()));
                meta = te.func_145832_p();
            }
            te.func_145979_i();
        }
        if (te.field_145992_i == null && te.field_145991_k == null) {
            float adjacentAngle;
            ModelChest model;
            if (te.field_145990_j == null && te.field_145988_l == null) {
                model = smallModel;
                if (destroyStage >= 0) {
                    this.func_147499_a(field_178460_a[destroyStage]);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    GlStateManager.func_179128_n((int)5888);
                } else if (this.isChristmas) {
                    this.func_147499_a(christmasNormal);
                } else if ((double)te.field_145989_m >= 0.9) {
                    this.func_147499_a(normalSingleActive);
                } else {
                    this.func_147499_a(normalSingleUnactive);
                }
            } else {
                model = largeModel;
                if (destroyStage >= 0) {
                    this.func_147499_a(field_178460_a[destroyStage]);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)8.0f, (float)4.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    GlStateManager.func_179128_n((int)5888);
                } else if (this.isChristmas) {
                    this.func_147499_a(christmasDouble);
                } else if ((double)te.field_145989_m >= 0.9) {
                    this.func_147499_a(normalDoubleActive);
                } else {
                    this.func_147499_a(normalDoubleUnactive);
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            if (destroyStage < 0) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            int rotation = 0;
            if (meta == 2) {
                rotation = 180;
            }
            if (meta == 3) {
                rotation = 0;
            }
            if (meta == 4) {
                rotation = 90;
            }
            if (meta == 5) {
                rotation = -90;
            }
            if (meta == 2 && te.field_145990_j != null) {
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (meta == 5 && te.field_145988_l != null) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float angle = te.field_145986_n + (te.field_145989_m - te.field_145986_n) * partialTicks;
            if (te.field_145992_i != null && (adjacentAngle = te.field_145992_i.field_145986_n + (te.field_145992_i.field_145989_m - te.field_145992_i.field_145986_n) * partialTicks) > angle) {
                angle = adjacentAngle;
            }
            if (te.field_145991_k != null && (adjacentAngle = te.field_145991_k.field_145986_n + (te.field_145991_k.field_145989_m - te.field_145991_k.field_145986_n) * partialTicks) > angle) {
                angle = adjacentAngle;
            }
            angle = 1.0f - angle;
            angle = 1.0f - angle * angle * angle;
            model.field_78234_a.field_78795_f = -(angle * (float)Math.PI / 2.0f);
            model.func_78231_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            }
        }
    }
}

