/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import net.geforcemods.securitycraft.blocks.BlockProjector;
import net.geforcemods.securitycraft.tileentity.TileEntityProjector;
import net.geforcemods.securitycraft.util.TileEntityRenderDelegate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityProjectorRenderer
extends TileEntitySpecialRenderer<TileEntityProjector> {
    public void render(TileEntityProjector te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntityRenderDelegate.DISGUISED_BLOCK.tryRenderDelegate(te, x, y, z, partialTicks, destroyStage, alpha);
        if (te.isActive() && !te.func_191420_l()) {
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
            if (!state.func_177227_a().contains(BlockProjector.FACING)) {
                return;
            }
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockProjector.FACING);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)(z + 1.0));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            for (int fakeX = 0; fakeX < te.getProjectionWidth(); ++fakeX) {
                for (int fakeY = 0; fakeY < te.getProjectionHeight(); ++fakeY) {
                    GlStateManager.func_179094_E();
                    BlockPos pos = !te.isHorizontal() ? this.translateProjection(te.func_174877_v(), facing, fakeX, fakeY, te.getProjectionRange(), te.getProjectionOffset()) : this.translateProjection(te.func_174877_v(), facing, fakeX, te.getProjectionRange() - 16, fakeY + 1, te.getProjectionOffset());
                    if (pos != null && te.func_145831_w().func_175623_d(pos)) {
                        BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
                        IBlockState projectedState = te.getProjectedState();
                        GlStateManager.func_179129_p();
                        GlStateManager.func_179139_a((double)0.9999, (double)0.9999, (double)0.9999);
                        if (projectedState.func_185901_i() == EnumBlockRenderType.MODEL) {
                            blockRendererDispatcher.func_175016_a(projectedState, te.func_145831_w().func_175724_o(pos));
                        }
                        TileEntityRenderDelegate.PROJECTOR.tryRenderDelegate(te, 0.0, 0.0, -1.0, partialTicks, destroyStage, alpha);
                        GlStateManager.func_179089_o();
                    }
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private BlockPos translateProjection(BlockPos tePos, EnumFacing direction, int x, int y, double distance, double offset) {
        BlockPos pos = null;
        if (direction == EnumFacing.NORTH) {
            pos = new BlockPos((double)(tePos.func_177958_n() + x) + offset, (double)(tePos.func_177956_o() + y), (double)tePos.func_177952_p() + distance);
            GlStateManager.func_179137_b((double)(0.0 + (double)x + offset), (double)(0.0 + (double)y), (double)distance);
        } else if (direction == EnumFacing.SOUTH) {
            pos = new BlockPos((double)(tePos.func_177958_n() + x) + offset, (double)(tePos.func_177956_o() + y), (double)tePos.func_177952_p() + -distance);
            GlStateManager.func_179137_b((double)(0.0 + (double)x + offset), (double)(0.0 + (double)y), (double)(-distance));
        } else if (direction == EnumFacing.WEST) {
            pos = new BlockPos((double)tePos.func_177958_n() + distance, (double)(tePos.func_177956_o() + y), (double)(tePos.func_177952_p() + x) + offset);
            GlStateManager.func_179137_b((double)distance, (double)(0.0 + (double)y), (double)(0.0 + (double)x + offset));
        } else if (direction == EnumFacing.EAST) {
            pos = new BlockPos((double)tePos.func_177958_n() + -distance, (double)(tePos.func_177956_o() + y), (double)(tePos.func_177952_p() + x) + offset);
            GlStateManager.func_179137_b((double)(-distance), (double)(0.0 + (double)y), (double)(0.0 + (double)x + offset));
        }
        return pos;
    }

    public boolean isGlobalRenderer(TileEntityProjector te) {
        return true;
    }
}

