/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.entry;

import buildcraft.api.registry.IScriptableRegistry;
import buildcraft.api.statements.IAction;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.ITrigger;
import buildcraft.api.statements.StatementManager;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import buildcraft.lib.client.guide.entry.IEntryLinkConsumer;
import buildcraft.lib.client.guide.entry.PageEntry;
import buildcraft.lib.client.guide.entry.PageValueType;
import buildcraft.lib.client.guide.parts.contents.PageLinkStatement;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.statement.GuiElementStatementSource;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class PageEntryStatement
extends PageValueType<IStatement> {
    public static final PageEntryStatement INSTANCE = new PageEntryStatement();
    private static final JsonTypeTags TRIGGER_TAGS = new JsonTypeTags("buildcraft.guide.contents.triggers");
    private static final JsonTypeTags ACTION_TAGS = new JsonTypeTags("buildcraft.guide.contents.actions");

    @Override
    public Class<IStatement> getEntryClass() {
        return IStatement.class;
    }

    @Override
    public void iterateAllDefault(IEntryLinkConsumer consumer, Profiler prof) {
        for (IStatement statement : new TreeMap<String, IStatement>(StatementManager.statements).values()) {
            JsonTypeTags parent;
            if (!GuideManager.INSTANCE.objectsAdded.add(statement)) continue;
            if (statement instanceof ITrigger) {
                parent = TRIGGER_TAGS;
            } else {
                if (!(statement instanceof IAction)) continue;
                parent = ACTION_TAGS;
            }
            consumer.addChild(parent, new PageLinkStatement(false, statement));
        }
    }

    @Override
    public IScriptableRegistry.OptionallyDisabled<PageEntry<IStatement>> deserialize(ResourceLocation name, JsonObject json, JsonDeserializationContext ctx) {
        String stmntName = JsonUtils.func_151200_h((JsonObject)json, (String)"statement");
        IStatement stmnt = StatementManager.statements.get(stmntName);
        if (stmnt == null) {
            throw new JsonSyntaxException("Unknown statement '" + stmntName + "'");
        }
        return new IScriptableRegistry.OptionallyDisabled<PageEntry<IStatement>>(new PageEntry<IStatement>(this, name, json, stmnt));
    }

    @Override
    public List<String> getTooltip(IStatement value) {
        return value.getTooltip();
    }

    @Override
    public String getTitle(IStatement value) {
        List<String> tooltip = value.getTooltip();
        if (tooltip.isEmpty()) {
            return value.getClass().toString();
        }
        return tooltip.get(0);
    }

    @Override
    @Nullable
    public ISimpleDrawable createDrawable(IStatement value) {
        return (x, y) -> GuiElementStatementSource.drawGuiSlot(value, x, y);
    }
}

