/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.api.fuels.ICoolant;
import buildcraft.api.fuels.ICoolantManager;
import buildcraft.api.fuels.ISolidCoolant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public enum CoolantRegistry implements ICoolantManager
{
    INSTANCE;

    private final List<ICoolant> coolants = new LinkedList<ICoolant>();
    private final List<ISolidCoolant> solidCoolants = new LinkedList<ISolidCoolant>();

    @Override
    public ICoolant addCoolant(ICoolant coolant) {
        this.coolants.add(coolant);
        return coolant;
    }

    @Override
    public ISolidCoolant addSolidCoolant(ISolidCoolant solidCoolant) {
        this.solidCoolants.add(solidCoolant);
        return solidCoolant;
    }

    @Override
    public ICoolant addCoolant(FluidStack fluid, float degreesCoolingPerMB) {
        return this.addCoolant(new Coolant(fluid, degreesCoolingPerMB));
    }

    @Override
    public ISolidCoolant addSolidCoolant(ItemStack solid, FluidStack fluid, float multiplier) {
        return this.addSolidCoolant(new SolidCoolant(solid, fluid, multiplier));
    }

    @Override
    public Collection<ICoolant> getCoolants() {
        return this.coolants;
    }

    @Override
    public Collection<ISolidCoolant> getSolidCoolants() {
        return this.solidCoolants;
    }

    @Override
    public ICoolant getCoolant(FluidStack fluid) {
        if (fluid == null || fluid.amount == 0) {
            return null;
        }
        for (ICoolant coolant : this.coolants) {
            if (!coolant.matchesFluid(fluid)) continue;
            return coolant;
        }
        return null;
    }

    @Override
    public float getDegreesPerMb(FluidStack fluid, float heat) {
        if (fluid == null || fluid.amount == 0) {
            return 0.0f;
        }
        for (ICoolant coolant : this.coolants) {
            float degrees = coolant.getDegreesCoolingPerMB(fluid, heat);
            if (!(degrees > 0.0f)) continue;
            return degrees;
        }
        return 0.0f;
    }

    @Override
    public ISolidCoolant getSolidCoolant(ItemStack solid) {
        for (ISolidCoolant coolant : this.solidCoolants) {
            if (coolant.getFluidFromSolidCoolant(solid) == null) continue;
            return coolant;
        }
        return null;
    }

    private static class SolidCoolant
    implements ISolidCoolant {
        private final ItemStack solid;
        private final FluidStack fluid;
        private final float multiplier;

        public SolidCoolant(ItemStack solid, FluidStack fluid, float multiplier) {
            this.solid = solid;
            this.fluid = fluid;
            this.multiplier = multiplier;
        }

        @Override
        public FluidStack getFluidFromSolidCoolant(ItemStack stack) {
            if (stack == null || !stack.func_77969_a(this.solid)) {
                return null;
            }
            int liquidAmount = (int)((float)(stack.func_190916_E() * this.fluid.amount) * this.multiplier / (float)this.solid.func_190916_E());
            return new FluidStack(this.fluid.getFluid(), liquidAmount);
        }
    }

    public static class Coolant
    implements ICoolant {
        private final FluidStack fluid;
        private final float degreesCoolingPerMB;

        public Coolant(FluidStack fluid, float degreesCoolingPerMB) {
            this.fluid = fluid;
            this.degreesCoolingPerMB = degreesCoolingPerMB;
        }

        @Override
        public boolean matchesFluid(FluidStack stack) {
            return this.fluid.isFluidEqual(stack);
        }

        @Override
        public float getDegreesCoolingPerMB(FluidStack stack, float heat) {
            if (this.matchesFluid(stack)) {
                return this.degreesCoolingPerMB;
            }
            return 0.0f;
        }
    }
}

