/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.gui.Widget_Neptune;
import buildcraft.lib.gui.slot.IPhantomSlot;
import buildcraft.lib.gui.slot.SlotPhantom;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.MessageContainer;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.item.IItemHandlerAdv;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ContainerBC_Neptune
extends Container {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.container");
    protected static final IdAllocator IDS = new IdAllocator("container");
    public static final int NET_DATA = IDS.allocId("DATA");
    public static final int NET_WIDGET = IDS.allocId("WIDGET");
    public static final int NET_SET_PHANTOM = IDS.allocId("SET_PHANTOM");
    public static final int NET_SET_PHANTOM_MULTI = IDS.allocId("NET_SET_PHANTOM_MULTI");
    public final EntityPlayer player;
    private final List<Widget_Neptune<?>> widgets = new ArrayList();

    public ContainerBC_Neptune(EntityPlayer player) {
        this.player = player;
    }

    public IdAllocator getIdAllocator() {
        return IDS;
    }

    protected void addFullPlayerInventory(int startX, int startY) {
        for (int sy = 0; sy < 3; ++sy) {
            for (int sx = 0; sx < 9; ++sx) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, sx + sy * 9 + 9, startX + sx * 18, startY + sy * 18));
            }
        }
        for (int sx = 0; sx < 9; ++sx) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, sx, startX + sx * 18, startY + 58));
        }
    }

    protected void addFullPlayerInventory(int startY) {
        this.addFullPlayerInventory(8, startY);
    }

    protected <W extends Widget_Neptune<?>> W addWidget(W widget) {
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        this.widgets.add(widget);
        return widget;
    }

    public ImmutableList<Widget_Neptune<?>> getWidgets() {
        return ImmutableList.copyOf(this.widgets);
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot == null) {
            return super.func_184996_a(slotId, dragType, clickType, player);
        }
        ItemStack playerStack = player.field_71071_by.func_70445_o();
        if (slot instanceof IPhantomSlot) {
            ItemStack stack;
            IPhantomSlot phantom = (IPhantomSlot)slot;
            if (playerStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (!StackUtil.canMerge(playerStack, StackUtil.asNonNull(slot.func_75211_c()))) {
                ItemStack copy = playerStack.func_77946_l();
                copy.func_190920_e(1);
                slot.func_75215_d(copy);
            } else if (phantom.canAdjustCount() && (stack = slot.func_75211_c()).func_190916_E() < stack.func_77976_d()) {
                stack.func_190917_f(1);
                slot.func_75215_d(stack);
            }
            return playerStack;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        Slot firstSlot = (Slot)this.field_75151_b.get(0);
        int playerInventorySize = 36;
        boolean playerInventoryFirst = firstSlot.field_75224_c instanceof InventoryPlayer;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (this.field_75151_b.size() == playerInventorySize) {
                return ItemStack.field_190927_a;
            }
            if (playerInventoryFirst ? (index < playerInventorySize ? !this.func_75135_a(itemstack1, playerInventorySize, this.field_75151_b.size(), false) : !this.func_75135_a(itemstack1, 0, playerInventorySize, true)) : (index < this.field_75151_b.size() - playerInventorySize ? !this.func_75135_a(itemstack1, this.field_75151_b.size() - playerInventorySize, this.field_75151_b.size(), false) : !this.func_75135_a(itemstack1, 0, this.field_75151_b.size() - playerInventorySize, true))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public static ItemStack safeCopy(ItemStack in) {
        return in == null ? null : in.func_77946_l();
    }

    void sendWidgetData(Widget_Neptune<?> widget, IPayloadWriter writer) {
        int widgetId = this.widgets.indexOf(widget);
        if (widgetId == -1) {
            if (DEBUG) {
                throw new IllegalArgumentException("Invalid Widget Request! (" + (widget == null ? "null" : widget.getClass()) + ")");
            }
            BCLog.logger.warn("[lib.container] Received an invalid widget sending request!");
            BCLog.logger.warn("[lib.container]   Widget {id = " + widgetId + ", class = " + widget.getClass() + "}");
            BCLog.logger.warn("[lib.container]   Container {class = " + ((Object)((Object)this)).getClass() + "}");
            BCLog.logger.warn("[lib.container]   Player {class = " + this.player.getClass() + ", name = " + this.player.func_70005_c_() + "}");
        } else {
            this.sendMessage(NET_WIDGET, buffer -> {
                buffer.writeShort(widgetId);
                writer.write(buffer);
            });
        }
    }

    public final void sendMessage(int id) {
        Side side = this.player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
        this.sendMessage(id, buffer -> this.writeMessage(id, buffer, side));
    }

    public final void sendMessage(int id, IPayloadWriter writer) {
        PacketBufferBC payload = PacketBufferBC.write(writer);
        MessageContainer message = new MessageContainer(this.field_75152_c, id, payload);
        if (this.player.field_70170_p.field_72995_K) {
            MessageManager.sendToServer(message);
        } else {
            MessageManager.sendTo(message, (EntityPlayerMP)this.player);
        }
    }

    public void writeMessage(int id, PacketBufferBC buffer, Side side) {
    }

    public void readMessage(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        block9: {
            block7: {
                Widget_Neptune<?> widget;
                block10: {
                    int widgetId;
                    block8: {
                        if (id != NET_WIDGET) break block7;
                        widgetId = buffer.readUnsignedShort();
                        if (widgetId >= 0 && widgetId < this.widgets.size()) break block8;
                        if (DEBUG) {
                            String string = "Received unknown or invalid widget ID " + widgetId + " on side " + side;
                            if (side == Side.SERVER) {
                                string = string + " (for player " + this.player.func_70005_c_() + ")";
                            }
                            BCLog.logger.warn(string);
                        }
                        break block9;
                    }
                    widget = this.widgets.get(widgetId);
                    if (side != Side.SERVER) break block10;
                    widget.handleWidgetDataServer(ctx, buffer);
                    break block9;
                }
                if (side != Side.CLIENT) break block9;
                widget.handleWidgetDataClient(ctx, buffer);
                break block9;
            }
            if (side == Side.SERVER) {
                if (id == NET_SET_PHANTOM) {
                    this.readSingleSetPhantom(buffer, ctx);
                } else if (id == NET_SET_PHANTOM_MULTI) {
                    int count = buffer.readUnsignedByte();
                    for (int i = 0; i < count; ++i) {
                        this.readSingleSetPhantom(buffer, ctx);
                    }
                }
            }
        }
    }

    private void readSingleSetPhantom(PacketBufferBC buffer, MessageContext ctx) throws IOException {
        Slot s;
        int idx = buffer.func_150792_a();
        ItemStack stack = buffer.func_150791_c();
        if (idx >= 0 && idx < this.field_75151_b.size() && (s = (Slot)this.field_75151_b.get(idx)) instanceof SlotPhantom) {
            SlotPhantom ph = (SlotPhantom)s;
            IItemHandlerAdv handler = ph.itemHandler;
            if (handler instanceof IItemHandlerModifiable && handler.canSet(ph.handlerIndex, stack)) {
                ((IItemHandlerModifiable)handler).setStackInSlot(ph.handlerIndex, stack);
            } else {
                String s2 = "[lib.container] Received an illegal phantom slot setting request! ";
                s2 = s2 + "[The item handler disallowed the replacement] (Client = ";
                s2 = s2 + ctx.getServerHandler().field_147369_b.func_70005_c_() + ", slot_index = " + idx;
                s2 = s2 + ", stack = " + stack + ")";
                BCLog.logger.warn(s2);
            }
            return;
        }
        String s2 = "[lib.container] Received an illegal phantom slot setting request! ";
        s2 = s2 + "[Didn't find a phantom slot for the given index] (Client = ";
        s2 = s2 + ctx.getServerHandler().field_147369_b.func_70005_c_() + ", slot_index = " + idx;
        s2 = s2 + ", stack = " + stack + ")";
        BCLog.logger.warn(s2);
    }

    public void sendSetPhantomSlot(IItemHandler handler, int index, ItemStack to) {
        this.sendSetPhantomSlot(this.findPhantomSlot(handler, index), to);
    }

    public void sendSetPhantomSlots(IItemHandler handler, List<ItemStack> stacks) {
        if (handler.getSlots() < stacks.size()) {
            throw new IllegalStateException("Too many ItemStacks's in the list to change, compared to the size of the inventory! (list = " + stacks + ", handler = " + handler + ")");
        }
        int[] indexes = new int[stacks.size()];
        NonNullList destinationStacks = NonNullList.func_191196_a();
        int i2 = 0;
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            if (stack == null) continue;
            destinationStacks.add((Object)stack);
            indexes[i2] = this.findPhantomSlot(handler, i);
            ++i2;
        }
        indexes = Arrays.copyOf(indexes, i2);
        this.sendSetPhantomSlots(indexes, (NonNullList<ItemStack>)destinationStacks);
    }

    private int findPhantomSlot(IItemHandler handler, int index) {
        int i = 0;
        for (Slot slot : this.field_75151_b) {
            if (slot instanceof SlotPhantom) {
                SlotPhantom ph = (SlotPhantom)slot;
                if (ph.itemHandler == handler && ph.handlerIndex == index) {
                    return i;
                }
            }
            ++i;
        }
        throw new IllegalArgumentException("Couldn't find a slot for " + index + " @ " + handler + " in " + ((Object)((Object)this)).getClass());
    }

    public void sendSetPhantomSlot(SlotPhantom slot, ItemStack to) {
        int index = this.field_75151_b.indexOf(slot);
        if (index == -1) {
            throw new IllegalArgumentException("Couldn't find a slot for " + slot + " in " + ((Object)((Object)this)).getClass());
        }
        this.sendSetPhantomSlot(index, to);
    }

    private void sendSetPhantomSlot(int phIndex, ItemStack to) {
        this.sendMessage(NET_SET_PHANTOM, buffer -> {
            buffer.func_150787_b(phIndex);
            buffer.func_150788_a(to);
        });
    }

    private void sendSetPhantomSlots(int[] indexes, NonNullList<ItemStack> stacks) {
        if (indexes.length != stacks.size()) {
            throw new IllegalArgumentException("Sizes don't match! (" + indexes.length + " vs " + stacks.size() + ")");
        }
        this.sendMessage(NET_SET_PHANTOM_MULTI, buffer -> {
            buffer.writeByte(indexes.length);
            for (int i = 0; i < indexes.length; ++i) {
                int index = indexes[i];
                ItemStack stack = (ItemStack)stacks.get(i);
                buffer.func_150787_b(index);
                buffer.func_150788_a(stack);
            }
        });
    }
}

