/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.json.JsonVariableObject;
import buildcraft.lib.misc.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class JsonGuiInfo
extends JsonVariableObject {
    public final String sizeX;
    public final String sizeY;
    public final String defaultTexture;
    public final Map<String, JsonGuiElement> types = new HashMap<String, JsonGuiElement>();
    public final List<JsonGuiElement> elements = new ArrayList<JsonGuiElement>();

    public JsonGuiInfo(JsonObject json, FunctionContext fnCtx, ResourceLoaderContext loadHistory) {
        JsonGuiElement elem;
        JsonObject obj;
        Object name;
        JsonObject jElems;
        if (json.has("values")) {
            this.putVariables(JsonUtils.func_152754_s((JsonObject)json, (String)"values"), fnCtx);
        }
        if (json.has("elements_below")) {
            jElems = JsonUtils.func_152754_s((JsonObject)json, (String)"elements_below");
            for (Map.Entry entry : jElems.entrySet()) {
                name = (String)entry.getKey();
                obj = (JsonObject)entry.getValue();
                elem = new JsonGuiElement(obj, (String)name, (String)name, this.types, fnCtx);
                this.elements.addAll(elem.iterate(fnCtx));
            }
        }
        if (json.has("parent")) {
            String parent = JsonUtils.func_151200_h((JsonObject)json, (String)"parent");
            ResourceLocation location = new ResourceLocation(parent + ".json");
            try {
                InputStreamReader reader = loadHistory.startLoading(location);
                name = null;
                try {
                    obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                    JsonGuiInfo info = new JsonGuiInfo(obj, fnCtx, loadHistory);
                    this.types.putAll(info.types);
                    this.elements.addAll(info.elements);
                    this.variables.putAll(info.variables);
                }
                catch (Throwable obj2) {
                    name = obj2;
                    throw obj2;
                }
                finally {
                    if (reader != null) {
                        if (name != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable obj2) {
                                ((Throwable)name).addSuppressed(obj2);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new JsonSyntaxException("Failed to load parent " + parent, (Throwable)e);
            }
            finally {
                loadHistory.finishLoading();
            }
        }
        if (json.has("variables")) {
            this.putVariables(JsonUtils.func_152754_s((JsonObject)json, (String)"variables"), fnCtx);
        }
        if (!json.has("size")) {
            throw new JsonSyntaxException("Expected size as an array!");
        }
        JsonElement size = json.get("size");
        this.sizeX = size.getAsJsonArray().get(0).getAsString();
        this.sizeY = size.getAsJsonArray().get(1).getAsString();
        this.defaultTexture = JsonUtil.getAsString(json.get("texture"));
        if (json.has("types")) {
            JsonObject jTypes = JsonUtils.func_152754_s((JsonObject)json, (String)"types");
            for (Map.Entry entry : jTypes.entrySet()) {
                name = (String)entry.getKey();
                obj = (JsonObject)entry.getValue();
                this.types.put((String)name, new JsonGuiElement(obj, (String)name, (String)name, this.types, fnCtx));
            }
        }
        if (json.has("elements")) {
            jElems = JsonUtils.func_152754_s((JsonObject)json, (String)"elements");
            for (Map.Entry entry : jElems.entrySet()) {
                name = (String)entry.getKey();
                obj = (JsonObject)entry.getValue();
                elem = new JsonGuiElement(obj, (String)name, (String)name, this.types, fnCtx);
                this.elements.addAll(elem.iterate(fnCtx));
            }
        }
        this.finaliseVariables();
    }

    public void printOut(Consumer<String> logger) {
        logger.accept("size = [ " + this.sizeX + ", " + this.sizeY + " ]");
        logger.accept("defaultTexture = " + this.defaultTexture);
        logger.accept("types:");
        Consumer<String> log2 = s -> logger.accept("  " + s);
        for (JsonGuiElement elem : this.types.values()) {
            elem.printOut(log2);
        }
        logger.accept("elements:");
        for (JsonGuiElement elem : this.elements) {
            elem.printOut(log2);
        }
    }
}

