/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net;

import buildcraft.api.IBuildCraftMod;
import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.misc.MessageUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class MessageManager {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.messages");
    private static final Map<IBuildCraftMod, PerModHandler> MOD_HANDLERS;
    private static final Map<Class<? extends IMessage>, PerMessageInfo<?>> MESSAGE_HANDLERS;

    private static int compareMods(IBuildCraftMod modA, IBuildCraftMod modB) {
        if (modA instanceof Enum && modB instanceof Enum) {
            Enum enumA = (Enum)((Object)modA);
            Enum enumB = (Enum)((Object)modB);
            if (enumA.getDeclaringClass() == enumB.getDeclaringClass()) {
                return Integer.compare(enumA.ordinal(), enumB.ordinal());
            }
        }
        return modA.getModId().compareTo(modB.getModId());
    }

    public static <I extends IMessage> void registerMessageClass(IBuildCraftMod module, Class<I> clazz, Side ... sides) {
        MessageManager.registerMessageClass(module, clazz, null, sides);
    }

    public static <I extends IMessage> void registerMessageClass(IBuildCraftMod module, Class<I> messageClass, IMessageHandler<I, ?> messageHandler, Side ... sides) {
        Side specificSide;
        PerModHandler modHandler = MOD_HANDLERS.computeIfAbsent(module, PerModHandler::new);
        PerMessageInfo<I> messageInfo = (PerMessageInfo<I>)modHandler.knownMessages.get(messageClass);
        if (messageInfo == null) {
            messageInfo = new PerMessageInfo<I>(modHandler, messageClass);
            modHandler.knownMessages.put(messageClass, messageInfo);
            MESSAGE_HANDLERS.put(messageClass, messageInfo);
        }
        String netName = module.getModId();
        if (messageHandler == null) {
            if (DEBUG) {
                BCLog.logger.info("[lib.messages] Registered message " + messageClass + " for " + netName);
            }
            return;
        }
        Side side = specificSide = sides != null && sides.length == 1 ? sides[0] : null;
        if (specificSide == null || specificSide == Side.CLIENT) {
            if (messageInfo.clientHandler != null && DEBUG) {
                BCLog.logger.info("[lib.messages] Replacing existing client handler for " + netName + " " + messageClass + " " + messageInfo.clientHandler + " with " + messageHandler);
            }
            messageInfo.clientHandler = messageHandler;
        }
        if (specificSide == null || specificSide == Side.SERVER) {
            if (messageInfo.serverHandler != null && DEBUG) {
                BCLog.logger.info("[lib.messages] Replacing existing server handler for " + netName + " " + messageClass + " " + messageInfo.serverHandler + " with " + messageHandler);
            }
            messageInfo.serverHandler = messageHandler;
        }
    }

    public static <I extends IMessage> void setHandler(Class<I> messageClass, IMessageHandler<I, ?> messageHandler, Side side) {
        PerMessageInfo<?> messageInfo = MESSAGE_HANDLERS.get(messageClass);
        if (messageInfo == null) {
            throw new IllegalArgumentException("Cannot set handler for unregistered message: " + messageClass);
        }
        MessageManager.registerMessageClass(messageInfo.modHandler.module, messageClass, messageHandler, side);
    }

    public static void fmlPostInit() {
        if (DEBUG) {
            BCLog.logger.info("[lib.messages] Sorting and registering message classes and orders:");
        }
        for (PerModHandler handler : MOD_HANDLERS.values()) {
            if (DEBUG) {
                BCLog.logger.info("[lib.messages]  - Module: " + handler.module.getModId());
            }
            int wholeId = 0;
            for (PerMessageInfo<?> info : handler.knownMessages.values()) {
                int id = wholeId++;
                MessageManager.postInitSingle(handler, id, info);
            }
        }
    }

    private static <I extends IMessage> void postInitSingle(PerModHandler handler, int id, PerMessageInfo<I> info) {
        boolean sv;
        boolean cl = info.clientHandler != null;
        boolean bl = sv = info.serverHandler != null;
        if (!(cl | sv) && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            throw new IllegalStateException("Found a registered message " + info.messageClass + " for " + info.modHandler.module.getModId() + " that didn't have any handlers!");
        }
        Class msgClass = info.messageClass;
        handler.netWrapper.registerMessage(MessageManager.wrapHandler(info.clientHandler, msgClass), msgClass, id, Side.CLIENT);
        handler.netWrapper.registerMessage(MessageManager.wrapHandler(info.serverHandler, msgClass), msgClass, id, Side.SERVER);
        if (DEBUG) {
            String sides = cl ? (sv ? "{client, server}" : "{client}") : "{server}";
            BCLog.logger.info("[lib.messages]      " + id + ": " + msgClass + " on sides: " + sides);
        }
    }

    private static <I extends IMessage> IMessageHandler<I, ?> wrapHandler(IMessageHandler<I, ?> messageHandler, Class<I> messageClass) {
        if (messageHandler == null) {
            return (message, context) -> {
                if (context.side != Side.SERVER) {
                    throw new Error("Received message " + messageClass + " on the client, when it should only be sent by the client and received on the server!");
                }
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                BCLog.logger.warn("[lib.messages] The client " + player.func_70005_c_() + " (ID = " + player.func_146103_bH().getId() + ") sent an invalid message " + messageClass + ", when they should only receive them!");
                return null;
            };
        }
        return (message, context) -> {
            EntityPlayer player = BCLibProxy.getProxy().getPlayerForContext(context);
            if (player == null || player.field_70170_p == null) {
                return null;
            }
            BCLibProxy.getProxy().addScheduledTask(player.field_70170_p, () -> {
                IMessage reply = messageHandler.onMessage(message, context);
                if (reply != null) {
                    MessageUtil.sendReturnMessage(context, reply);
                }
            });
            return null;
        };
    }

    private static SimpleNetworkWrapper getSimpleNetworkWrapper(IMessage message) {
        PerMessageInfo<?> info = MESSAGE_HANDLERS.get(message.getClass());
        if (info == null) {
            throw new IllegalArgumentException("Cannot send unregistered message " + message.getClass());
        }
        return info.modHandler.netWrapper;
    }

    public static void sendToAll(IMessage message) {
        MessageManager.getSimpleNetworkWrapper(message).sendToAll(message);
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        MessageManager.getSimpleNetworkWrapper(message).sendTo(message, player);
    }

    public static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        MessageManager.getSimpleNetworkWrapper(message).sendToAllAround(message, point);
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        MessageManager.getSimpleNetworkWrapper(message).sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        MessageManager.getSimpleNetworkWrapper(message).sendToServer(message);
    }

    static {
        MESSAGE_HANDLERS = new HashMap();
        MOD_HANDLERS = new TreeMap<IBuildCraftMod, PerModHandler>(MessageManager::compareMods);
    }

    static class PerMessageInfo<I extends IMessage> {
        final PerModHandler modHandler;
        final Class<I> messageClass;
        @Nullable
        IMessageHandler<I, ?> clientHandler;
        @Nullable
        IMessageHandler<I, ?> serverHandler;

        PerMessageInfo(PerModHandler modHandler, Class<I> messageClass) {
            this.modHandler = modHandler;
            this.messageClass = messageClass;
        }
    }

    static class PerModHandler {
        final IBuildCraftMod module;
        final SimpleNetworkWrapper netWrapper;
        final SortedMap<Class<? extends IMessage>, PerMessageInfo<?>> knownMessages;

        PerModHandler(IBuildCraftMod module) {
            this.module = module;
            this.netWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(module.getModId());
            this.knownMessages = new TreeMap(Comparator.comparing(Class::getName));
        }
    }
}

