/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.category.ObjectCategory;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.GuiCategoryUIEditorDataConverter;
import xaero.common.category.ui.data.GuiCategoryUIEditorCategoryData;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSettingsData;
import xaero.common.category.ui.entry.CategorySettingsListEntry;
import xaero.common.category.ui.entry.CategorySettingsListMainEntry;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiActionButton;
import xaero.common.gui.ScreenBase;

public abstract class GuiCategorySettings<C extends ObjectCategory<?, C>, ED extends GuiCategoryUIEditorCategoryData<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends GuiCategoryUIEditorSettingsData<?>, SDB extends GuiCategoryUIEditorSettingsData.Builder<SD, SDB>, EDB extends GuiCategoryUIEditorCategoryData.Builder<C, ED, SD, SDB, EDB>>
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 32;
    private static final int FRAME_BOTTOM_SIZE = 48;
    public static final int ROW_HEIGHT = 24;
    public static final int ROW_WIDTH = 220;
    private SettingRowList rowList;
    private final GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
    private ED editorData;
    private String title;
    protected ED cutCategory;
    protected ED cutCategorySuper;

    protected GuiCategorySettings(IXaeroMinimap modMain, GuiScreen parent, GuiScreen escape, String title, GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
        super(modMain, parent, escape);
        this.dataConverter = dataConverter;
        this.editorData = this.constructEditorData(dataConverter);
        this.title = title;
    }

    protected abstract ED constructEditorData(GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract ED constructDefaultData(GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract void onConfigConfirmed(C var1);

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new GuiActionButton(this.field_146294_l / 2 + 5, this.field_146295_m - 32, 150, 20, I18n.func_135052_a((String)"gui.xaero_category_settings_cancel", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiCategorySettings.this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                    public void func_73878_a(boolean result, int id) {
                        if (result) {
                            GuiCategorySettings.super.onExit(GuiCategorySettings.this.parent);
                        } else {
                            GuiCategorySettings.this.field_146297_k.func_147108_a((GuiScreen)GuiCategorySettings.this);
                        }
                    }
                }, I18n.func_135052_a((String)"gui.xaero_category_settings_cancel_confirm", (Object[])new Object[0]), "", 0));
            }
        });
        this.func_189646_b(new GuiActionButton(this.field_146294_l / 2 - 155, this.field_146295_m - 32, 150, 20, I18n.func_135052_a((String)"gui.xaero_category_settings_confirm", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiCategorySettings.this.confirm();
            }
        });
        this.func_189646_b(new GuiActionButton(6, 6, 120, 20, I18n.func_135052_a((String)"gui.xaero_category_settings_reset", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiCategorySettings.this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                    public void func_73878_a(boolean result, int id) {
                        if (result) {
                            GuiCategorySettings.this.editorData = GuiCategorySettings.this.constructDefaultData(GuiCategorySettings.this.dataConverter);
                        }
                        GuiCategorySettings.this.field_146297_k.func_147108_a((GuiScreen)GuiCategorySettings.this);
                    }
                }, I18n.func_135052_a((String)"gui.xaero_category_settings_reset_confirm1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_category_settings_reset_confirm2", (Object[])new Object[0]), 0));
            }
        });
        this.rowList = new SettingRowList(this.dataConverter);
        this.rowList.func_148134_d(7, 8);
    }

    private void confirm() {
        this.onConfigConfirmed(((ObjectCategory.Builder)this.dataConverter.getConfiguredBuilder(this.editorData)).build());
        super.onExit(this.parent);
    }

    @Override
    protected void onExit(final GuiScreen screen) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

            public void func_73878_a(boolean result, int id) {
                if (result) {
                    GuiCategorySettings.this.confirm();
                }
                GuiCategorySettings.super.onExit(screen);
            }
        }, I18n.func_135052_a((String)"gui.xaero_category_settings_save_confirm", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_category_settings_save_confirm_warning", (Object[])new Object[0]), 0){

            protected void func_73869_a(char typedChar, int keyCode) throws IOException {
                if (keyCode == 1) {
                    return;
                }
                super.func_73869_a(typedChar, keyCode);
            }
        });
    }

    public void func_73863_a(int i, int j, float f) {
        this.rowList.func_148128_a(i, j, f);
        this.func_73732_a(this.field_146297_k.field_71466_p, this.title, this.field_146294_l / 2, 5, 0xFFFFFF);
        super.func_73863_a(i, j, f);
        if (this.rowList.hovered != null) {
            CursorBox tooltip;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
            Supplier<CursorBox> tooltipSupplier = this.rowList.hovered.getTooltipSupplier();
            if (tooltipSupplier != null && (tooltip = tooltipSupplier.get()) != null) {
                tooltip.drawBox(i, j, this.field_146294_l, this.field_146295_m);
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.rowList.keyTyped(typedChar, keyCode);
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73876_c() {
        this.rowList.tick();
        super.func_73876_c();
    }

    public SettingRowList getRowList() {
        return this.rowList;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.rowList.mouseDragged(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.rowList.mouseClicked(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.rowList.mouseReleased(mouseX, mouseY, state);
        super.func_146286_b(mouseX, mouseY, state);
    }

    public void func_146274_d() throws IOException {
        this.rowList.func_178039_p();
        super.func_146274_d();
    }

    public class SettingRowList
    extends GuiSlot {
        private GuiCategoryUIEditorExpandableData<?> lastExpandedData;
        private boolean restoreScrollAfterUpdate;
        private CategorySettingsListEntry hovered;
        private final GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
        private List<xaero.common.category.ui.GuiCategorySettings$SettingRowList.Entry> entries;
        private xaero.common.category.ui.GuiCategorySettings$SettingRowList.Entry selected;

        public SettingRowList(GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
            super(GuiCategorySettings.this.field_146297_k, GuiCategorySettings.this.field_146294_l, GuiCategorySettings.this.field_146295_m, 32, Math.max(36, GuiCategorySettings.this.field_146295_m - 48), 24);
            this.dataConverter = dataConverter;
            this.entries = new ArrayList<xaero.common.category.ui.GuiCategorySettings$SettingRowList.Entry>();
            this.updateEntries();
            this.func_193651_b(false);
        }

        public xaero.common.category.ui.GuiCategorySettings$SettingRowList.Entry getSelected() {
            return this.selected;
        }

        private void clearEntries() {
            this.entries.clear();
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void addEntry(Entry e) {
            this.entries.add((xaero.common.category.ui.GuiCategorySettings$SettingRowList.Entry)e);
        }

        public boolean hasCut() {
            if (GuiCategorySettings.this.cutCategory != null) {
                if (((GuiCategoryUIEditorCategoryData)GuiCategorySettings.this.cutCategorySuper).getSubCategories().contains(GuiCategorySettings.this.cutCategory)) {
                    return true;
                }
                this.setCutCategory(null, null);
            }
            return false;
        }

        public ED getCut() {
            return GuiCategorySettings.this.cutCategory;
        }

        public boolean isCut(ED category) {
            if (GuiCategorySettings.this.cutCategory == category) {
                return this.hasCut();
            }
            return false;
        }

        public void setCutCategory(ED cutCategory, ED cutCategorySuper) {
            GuiCategorySettings.this.cutCategory = cutCategory;
            GuiCategorySettings.this.cutCategorySuper = cutCategorySuper;
        }

        public void pasteTo(ED destination) {
            if (GuiCategorySettings.this.cutCategory != null) {
                if (destination == GuiCategorySettings.this.cutCategory || destination == GuiCategorySettings.this.cutCategorySuper) {
                    this.setCutCategory(null, null);
                    this.updateEntries();
                    return;
                }
                ((GuiCategoryUIEditorExpandableData)destination).getExpandAction(this).run();
                this.setLastExpandedData((GuiCategoryUIEditorExpandableData<?>)GuiCategorySettings.this.cutCategory);
                ((GuiCategoryUIEditorCategoryData)GuiCategorySettings.this.cutCategorySuper).getSubCategories().remove(GuiCategorySettings.this.cutCategory);
                ((GuiCategoryUIEditorCategoryData)destination).getSubCategories().add(0, GuiCategorySettings.this.cutCategory);
                this.setCutCategory(null, null);
            }
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        }

        protected boolean func_148131_a(int slotIndex) {
            return this.getSelected() == this.entries.get(slotIndex);
        }

        protected void func_148123_a() {
            GuiCategorySettings.this.func_146276_q_();
        }

        protected void func_192637_a(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
            Entry entry = (Entry)this.entries.get(slotIndex);
            entry.render(slotIndex, yPos, xPos, this.func_148139_c(), heightIn, mouseXIn, mouseYIn, this.func_148124_c(mouseXIn, mouseYIn) == slotIndex, partialTicks);
        }

        public void setLastExpandedData(GuiCategoryUIEditorExpandableData<?> lastExpandedData) {
            this.lastExpandedData = lastExpandedData;
        }

        public void restoreScrollAfterUpdate() {
            this.restoreScrollAfterUpdate = true;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void centerScrollOn(Entry entry) {
            int index = this.entries.indexOf(entry);
            this.field_148169_q = index * this.func_148146_j() - (this.field_148154_c - this.field_148153_b) / 2;
            if (this.field_148169_q < 0.0f) {
                this.field_148169_q = 0.0f;
            }
        }

        public void updateEntries() {
            int scrollBackup = this.func_148148_g();
            this.clearEntries();
            GuiCategorySettings.this.editorData.setExpanded(true);
            this.addEntriesForExpandable(GuiCategorySettings.this.editorData, null);
            if (this.getSelected() != null) {
                this.centerScrollOn(this.getSelected());
            }
            if (this.restoreScrollAfterUpdate) {
                this.field_148169_q = scrollBackup;
                this.restoreScrollAfterUpdate = false;
            }
        }

        private <D extends GuiCategoryUIEditorExpandableData<?>> void addEntriesForExpandable(GuiCategoryUIEditorExpandableData<D> data, GuiCategoryUIEditorExpandableData<?> parent) {
            int nextIndex = this.entries.size();
            List<D> subExpandables = data.getSubExpandables();
            if (subExpandables == null) {
                return;
            }
            GuiCategoryUIEditorExpandableData expandedData = null;
            for (GuiCategoryUIEditorExpandableData sed : subExpandables) {
                if (!sed.isExpanded()) continue;
                expandedData = sed;
                break;
            }
            Entry currentEntry = new Entry(data.getListEntryFactory().get(data, parent, nextIndex, nextIndex == 0 ? ConnectionLineType.NONE : ConnectionLineType.PATH, this, this.field_148155_a, expandedData == null), nextIndex++);
            this.addEntry(currentEntry);
            if (data == this.lastExpandedData) {
                this.setSelected(currentEntry);
            }
            if (expandedData != null) {
                this.addEntriesForExpandable(expandedData, data);
            } else {
                if (this.lastExpandedData == null && data.isExpanded()) {
                    this.setSelected(currentEntry);
                }
                boolean first = true;
                for (GuiCategoryUIEditorExpandableData sed : subExpandables) {
                    Entry leafEntry = new Entry(sed.getListEntryFactory().get(sed, data, nextIndex, first ? ConnectionLineType.HEAD_LEAF : ConnectionLineType.TAIL_LEAF, this, this.field_148155_a, false), nextIndex++);
                    this.addEntry(leafEntry);
                    if (sed == this.lastExpandedData) {
                        this.setSelected(leafEntry);
                    }
                    first = false;
                }
            }
        }

        public boolean keyTyped(char c, int i) {
            boolean result;
            return this.getSelected() != null && (result = this.getSelected().keyTyped(c, i));
        }

        public void tick() {
            if (this.getSelected() != null) {
                this.getSelected().tick();
            }
        }

        public boolean confirmSelection() {
            CategorySettingsListEntry selectedSubEntry;
            Entry entry = this.getSelected();
            return entry != null && (selectedSubEntry = entry.wrappedEntry.confirmSelection()) != null;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(Entry entry) {
            if (this.getSelected() != null) {
                this.getSelected().wrappedEntry.unfocusRecursively();
            }
            if (entry != null) {
                entry.wrappedEntry.focusFirstRecursively();
            }
            this.selected = entry;
        }

        public int func_148139_c() {
            return this.field_148155_a;
        }

        public void func_148128_a(int i, int j, float f) {
            this.hovered = null;
            super.func_148128_a(i, j, f);
        }

        protected int func_148137_d() {
            return this.field_148155_a / 2 + 164;
        }

        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            int slotIndex = GuiCategorySettings.this.rowList.func_148124_c(mouseX, mouseY);
            if (slotIndex >= 0 && slotIndex < this.entries.size()) {
                Entry e = (Entry)this.entries.get(slotIndex);
                e.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }

        public void mouseReleased(int mouseX, int mouseY, int i) {
            for (Entry entry : this.entries) {
                entry.mouseReleased(mouseX, mouseY, i);
            }
        }

        public void mouseDragged(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        }

        public void func_178039_p() {
            super.func_178039_p();
            if (this.field_148170_p > 0.0f) {
                this.field_148157_o = -2;
                this.field_148170_p = 0.0f;
            }
        }

        public GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> getDataConverter() {
            return this.dataConverter;
        }

        public class Entry {
            private CategorySettingsListMainEntry<?> wrappedEntry;
            private int index;
            private int lastX;
            private int lastY;

            public Entry(CategorySettingsListMainEntry<?> entryInfo, int index) {
                this.wrappedEntry = entryInfo;
                this.index = index;
            }

            public void render(int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.lastX = x;
                this.lastY = y;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                boolean includesSelected = SettingRowList.this.getSelected() == this;
                this.wrappedEntry.preRender(includesSelected, true);
                CategorySettingsListEntry hoveredInRow = this.wrappedEntry.render(index, rowWidth, rowHeight, mouseX - x - this.wrappedEntry.getEntryRelativeX(), mouseY - y - this.wrappedEntry.getEntryRelativeY(), isMouseOver, partialTicks, GuiCategorySettings.this.field_146289_q, mouseX, mouseY, includesSelected, true);
                this.wrappedEntry.postRender();
                GlStateManager.func_179121_F();
                if (hoveredInRow != null) {
                    SettingRowList.this.hovered = hoveredInRow;
                }
            }

            public boolean mouseClicked(int mouseX, int mouseY, int i) {
                SettingRowList.this.setSelected(this);
                int relativeMouseX = mouseX - this.lastX - this.wrappedEntry.getEntryRelativeX();
                int relativeMouseY = mouseY - this.lastY - this.wrappedEntry.getEntryRelativeY();
                return this.wrappedEntry.mouseClicked(this, relativeMouseX, relativeMouseY, i);
            }

            public boolean mouseReleased(int mouseX, int mouseY, int i) {
                int relativeMouseX = mouseX - this.lastX - this.wrappedEntry.getEntryRelativeX();
                int relativeMouseY = mouseY - this.lastY - this.wrappedEntry.getEntryRelativeY();
                return this.wrappedEntry.mouseReleased(relativeMouseX, relativeMouseY, i);
            }

            public boolean mouseDragged(int mouseX, int mouseY, int i, long timeSinceLastClick) {
                int relativeMouseX = mouseX - this.lastX - this.wrappedEntry.getEntryRelativeX();
                int relativeMouseY = mouseY - this.lastY - this.wrappedEntry.getEntryRelativeY();
                return this.wrappedEntry.mouseDragged(this, relativeMouseX, relativeMouseY, i, timeSinceLastClick);
            }

            public boolean keyTyped(char c, int i) {
                return this.wrappedEntry.keyTyped(c, i, true);
            }

            public void tick() {
                this.wrappedEntry.tick();
            }
        }
    }
}

