/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CursorBox {
    private static final int BOX_OFFSET_X = 12;
    private static final int BOX_OFFSET_Y = -10;
    private static final int START_WIDTH = 20;
    private static final int USUAL_WIDTH = 200;
    private ArrayList<ITextComponent> strings;
    private ITextComponent directText;
    private boolean directTextReady;
    private String language;
    private String fullCode;
    private Style codeStyle;
    private String plainText;
    private int boxWidth = 20;
    private static final int color = -939524096;
    private boolean customLines;
    private boolean flippedByDefault;
    private boolean autoLinebreak;

    public CursorBox(String code) {
        this(code, null);
    }

    public CursorBox(String code, Style codeStyle) {
        this(code, codeStyle, false);
    }

    public CursorBox(String code, Style codeStyle, boolean flippedByDefault) {
        this.fullCode = code;
        this.codeStyle = codeStyle;
        this.flippedByDefault = flippedByDefault;
        this.autoLinebreak = true;
    }

    public CursorBox(ITextComponent directText) {
        this(directText, false);
    }

    public CursorBox(ITextComponent directText, boolean flippedByDefault) {
        this.directText = directText;
        this.flippedByDefault = flippedByDefault;
        this.autoLinebreak = true;
    }

    public CursorBox(int size) {
        this.strings = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.strings.add((ITextComponent)new TextComponentString(""));
        }
        this.customLines = true;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
    }

    private String currentLanguage() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
    }

    public void createLines(ITextComponent text) {
        try {
            this.language = this.currentLanguage();
        }
        catch (NullPointerException e) {
            this.language = "en_us";
        }
        this.strings = new ArrayList();
        SplitProgress progress = new SplitProgress();
        int spaceWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(" ");
        this.splitWords(this.strings, progress, spaceWidth, text);
    }

    public void splitWords(final ArrayList<ITextComponent> dest, final SplitProgress progress, final int spaceWidth, ITextComponent formattedText) {
        final StringBuilder plainTextBuilder = new StringBuilder();
        final BiConsumer<Style, String> consumer = new BiConsumer<Style, String>(){

            @Override
            public void accept(Style style, String text) {
                plainTextBuilder.append(text);
                boolean endsWithSpace = text.endsWith(" ");
                if (endsWithSpace) {
                    text = text + ".";
                }
                String[] parts = text.split(" ");
                boolean isEnd = style == null;
                int widthLimit = CursorBox.this.autoLinebreak ? 200 : Integer.MAX_VALUE;
                for (int i = 0; i < parts.length; ++i) {
                    boolean isNewLine;
                    boolean canAddMultiword = isEnd || i < parts.length - 1;
                    String part = isEnd || endsWithSpace && i == parts.length - 1 ? "" : parts[i];
                    int partWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(part);
                    if (!canAddMultiword) {
                        progress.buildMultiword(part, partWidth, style);
                        continue;
                    }
                    int wordWidth = partWidth + progress.multiwordWidth;
                    int wordTakesWidth = wordWidth + (!progress.firstWord ? spaceWidth : 0);
                    if (progress.lineWidth + wordTakesWidth <= widthLimit - 20) {
                        CursorBox.this.boxWidth = Math.max(CursorBox.this.boxWidth, Math.min(widthLimit, progress.lineWidth + wordTakesWidth + 20));
                    }
                    if (progress.firstWord && progress.lineWidth + wordTakesWidth > CursorBox.this.boxWidth - 20) {
                        CursorBox.this.boxWidth = progress.lineWidth + wordTakesWidth + 20;
                    }
                    boolean bl = isNewLine = progress.multiword == null && part.equals("\\n");
                    if (!isNewLine && progress.lineWidth + wordTakesWidth <= CursorBox.this.boxWidth - 20) {
                        progress.confirmWord(part, style, wordTakesWidth);
                        continue;
                    }
                    progress.confirmComponent();
                    dest.add(progress.line);
                    progress.nextLine();
                    if (isNewLine) continue;
                    --i;
                }
            }
        };
        formattedText.iterator().forEachRemaining(new Consumer<ITextComponent>(){

            @Override
            public void accept(ITextComponent tc) {
                consumer.accept(tc.func_150256_b(), tc.func_150261_e());
            }
        });
        if (progress.multiword != null) {
            consumer.accept(null, "end");
        } else if (progress.stringBuilder.length() > 0) {
            progress.confirmComponent();
        }
        if (progress.line != null) {
            dest.add(progress.line);
        }
        if (this.boxWidth > 20) {
            --this.boxWidth;
        }
        this.plainText = plainTextBuilder.toString();
    }

    public ITextComponent getLine(int line) {
        return this.strings.get(line);
    }

    private void ensure() {
        try {
            if (!(this.customLines || (this.fullCode != null || this.directTextReady) && this.language != null && this.language.equals(this.currentLanguage()))) {
                if (this.fullCode != null) {
                    this.createLines(new TextComponentTranslation(this.fullCode, new Object[0]).func_150255_a(this.codeStyle));
                } else {
                    this.createLines(this.directText);
                    this.directTextReady = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawBox(int x, int y, int width, int height) {
        int h;
        int overEdgeY;
        this.ensure();
        int drawX = x + 12;
        int drawY = y + -10;
        int overEdgeX = drawX + this.boxWidth - width;
        if (this.flippedByDefault || overEdgeX > 9) {
            drawX = x - 12 - this.boxWidth;
        } else if (overEdgeX > 0) {
            drawX -= overEdgeX;
        }
        if (drawX < 0) {
            drawX = 0;
        }
        if ((overEdgeY = drawY + (h = 5 + this.strings.size() * 10 + 5) - height) > h / 2) {
            drawY = y - -10 - h;
        } else if (overEdgeY > 0) {
            drawY -= overEdgeY;
        }
        if (drawY < 0) {
            drawY = 0;
        }
        Gui.func_73734_a((int)drawX, (int)drawY, (int)(drawX + this.boxWidth), (int)(drawY + h), (int)-939524096);
        for (int i = 0; i < this.strings.size(); ++i) {
            ITextComponent s = this.getLine(i);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(s.func_150254_d(), drawX + 10, drawY + 6 + 10 * i, 0xFFFFFF);
        }
    }

    public CursorBox withWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        return this;
    }

    public void setAutoLinebreak(boolean autoLinebreak) {
        this.autoLinebreak = autoLinebreak;
    }

    public String getPlainText() {
        this.ensure();
        return this.plainText;
    }

    public String getFullCode() {
        return this.fullCode;
    }

    public class SplitProgress {
        int multiwordWidth;
        List<ITextComponent> multiword = null;
        boolean firstWord = true;
        ITextComponent line = null;
        StringBuilder stringBuilder = new StringBuilder();
        int lineWidth;
        Style lastStyle;

        public void buildMultiword(String wordPart, int width, Style style) {
            ITextComponent wordPartComponent = new TextComponentString(wordPart).func_150255_a(style);
            if (this.multiword == null) {
                this.multiword = new ArrayList<ITextComponent>();
            }
            this.multiword.add(wordPartComponent);
            this.multiwordWidth += width;
        }

        private void confirmWordPart(String part, Style style) {
            if (this.lastStyle != null && !Objects.equals(style, this.lastStyle)) {
                this.confirmComponent();
            }
            this.stringBuilder.append(part);
            this.lastStyle = style;
        }

        public void confirmWord(String lastPart, Style lastPartStyle, int width) {
            if (!this.firstWord) {
                this.stringBuilder.append(" ");
            }
            if (this.multiword != null) {
                for (ITextComponent component : this.multiword) {
                    String text = component.func_150261_e();
                    Style style = component.func_150256_b();
                    this.confirmWordPart(text, style);
                }
                this.multiword = null;
                this.multiwordWidth = 0;
            }
            this.confirmWordPart(lastPart, lastPartStyle);
            this.lineWidth += width;
            this.firstWord = false;
        }

        public void confirmComponent() {
            ITextComponent comp = new TextComponentString(this.stringBuilder.toString()).func_150255_a(this.lastStyle == null ? null : this.lastStyle);
            if (this.line != null) {
                if (this.stringBuilder.length() > 0) {
                    this.line.func_150253_a().add(comp);
                }
            } else {
                this.line = comp;
            }
            this.stringBuilder.delete(0, this.stringBuilder.length());
        }

        public void nextLine() {
            this.firstWord = true;
            this.line = null;
            this.lastStyle = null;
            this.lineWidth = 0;
        }
    }
}

