/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.category;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.PlaceholderEntityType;
import xaero.common.minimap.radar.category.serialization.data.EntityRadarCategoryData;
import xaero.common.misc.ListFactory;
import xaero.common.misc.MapFactory;

public final class EntityRadarCategoryConstants {
    public static final ListFactory LIST_FACTORY = new ListFactory(){

        @Override
        public <T> List<T> get() {
            return new ArrayList();
        }
    };
    public static final MapFactory MAP_FACTORY = new MapFactory(){

        @Override
        public <K, V> Map<K, V> get() {
            return new HashMap();
        }
    };
    public static final Supplier<EntityRadarCategoryData.Builder> DATA_BUILDER_FACTORY = new Supplier<EntityRadarCategoryData.Builder>(){

        @Override
        public EntityRadarCategoryData.Builder get() {
            return EntityRadarCategoryData.Builder.getDefault();
        }
    };
    public static final Supplier<EntityRadarCategory.Builder> CATEGORY_BUILDER_FACTORY = new Supplier<EntityRadarCategory.Builder>(){

        @Override
        public EntityRadarCategory.Builder get() {
            return EntityRadarCategory.Builder.getDefault();
        }
    };
    public static final PlaceholderEntityType PLAYER_ENTITY_ENTRY = new PlaceholderEntityType("minecraft:player");
    public static final Function<Entity, EntityEntry> DEFAULT_LIST_GETTER = new Function<Entity, EntityEntry>(){

        @Override
        public EntityEntry apply(Entity e) {
            if (e instanceof EntityPlayer) {
                return PLAYER_ENTITY_ENTRY;
            }
            return EntityRegistry.getEntry(e.getClass());
        }
    };
    public static final Function<EntityEntry, String> DEFAULT_LIST_SERIALIZER = new Function<EntityEntry, String>(){

        @Override
        public String apply(EntityEntry t) {
            return t.getRegistryName().toString();
        }
    };
    private static final Function<String, String> WILDCARD_TO_REGEX = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s.replaceAll("([\\.\\-\\:\\/])", "\\\\$1").replace("*", ".*");
        }
    };
    public static final Function<String, List<EntityEntry>> DEFAULT_LIST_ELEMENT_RESOLVER = new Function<String, List<EntityEntry>>(){

        @Override
        public List<EntityEntry> apply(String s) {
            if (EntityRadarCategoryConstants.isValidResourceLocation(s)) {
                if (s.equals(PLAYER_ENTITY_ENTRY.getHelpString())) {
                    return Lists.newArrayList((Object[])new EntityEntry[]{PLAYER_ENTITY_ENTRY});
                }
                ResourceLocation resourceLocation = new ResourceLocation(s);
                EntityEntry directReference = (EntityEntry)ForgeRegistries.ENTITIES.getValue(resourceLocation);
                if (directReference == null) {
                    return null;
                }
                return Lists.newArrayList((Object[])new EntityEntry[]{directReference});
            }
            String regexPattern = (String)WILDCARD_TO_REGEX.apply(s);
            ArrayList<EntityEntry> result = new ArrayList<EntityEntry>();
            try {
                if (PLAYER_ENTITY_ENTRY.getHelpString().matches(regexPattern)) {
                    result.add(PLAYER_ENTITY_ENTRY);
                }
                for (EntityEntry et : ForgeRegistries.ENTITIES) {
                    ResourceLocation entityTypeLocation = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)et);
                    if (entityTypeLocation == null || !entityTypeLocation.toString().matches(regexPattern)) continue;
                    result.add(et);
                }
            }
            catch (PatternSyntaxException pse) {
                return null;
            }
            return result;
        }
    };
    private static final String DEFAULT_LIST_ALLOWED_CHARS = "a-z_0-9\\(\\)\\|:\\/\\-\\.\\*";
    public static final Predicate<String> DEFAULT_LIST_STRING_VALIDATOR = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            boolean result = s.matches("[a-z_0-9\\(\\)\\|:\\/\\-\\.\\*]*");
            if (result) {
                if (EntityRadarCategoryConstants.isValidResourceLocation(s)) {
                    return true;
                }
                try {
                    "test string".matches((String)WILDCARD_TO_REGEX.apply(s));
                    return true;
                }
                catch (PatternSyntaxException pse) {
                    return false;
                }
            }
            return result;
        }
    };
    public static final Function<String, String> DEFAULT_LIST_STRING_VALIDATOR_FIXER = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s.replaceAll("[^a-z_0-9\\(\\)\\|:\\/\\-\\.\\*]+", "");
        }
    };
    public static final String CATEGORY_ROOT = "gui.xaero_entity_category_root";
    public static final String CATEGORY_LIVING = "gui.xaero_entity_category_living";
    public static final String CATEGORY_HOSTILE = "gui.xaero_entity_category_hostile";
    public static final String CATEGORY_FRIENDLY = "gui.xaero_entity_category_friendly";
    public static final String CATEGORY_HOSTILE_TAMED = "gui.xaero_entity_category_hostile_tamed";
    public static final String CATEGORY_FRIENDLY_TAMED = "gui.xaero_entity_category_friendly_tamed";
    public static final String CATEGORY_PLAYERS = "gui.xaero_entity_category_players";
    public static final String CATEGORY_SAME_TEAM = "gui.xaero_entity_category_same_team";
    public static final String CATEGORY_OTHER_TEAMS = "gui.xaero_entity_category_other_teams";
    public static final String CATEGORY_ITEMS = "gui.xaero_entity_category_items";
    public static final String CATEGORY_OTHER = "gui.xaero_entity_category_other_entities";
    public static final String HARD_NOTHING = "nothing";
    public static final String HARD_LIVING = "living";
    public static final String HARD_HOSTILE = "hostile";
    public static final String HARD_FRIENDLY = "friendly";
    public static final String HARD_TAMED = "tamed";
    public static final String HARD_PLAYERS = "players";
    public static final String HARD_SAME_TEAM = "same-team";
    public static final String HARD_OTHER_TEAMS = "other-teams";
    public static final String HARD_ITEMS = "items";
    public static final String HARD_ANYTHING = "anything";
    public static final String HARD_BABY = "baby";
    public static final String HARD_VANILLA = "vanilla";
    public static final String HARD_MODDED = "modded";

    private static String[] decompose(String location) {
        String[] split;
        if (!location.contains(":")) {
            location = "minecraft:" + location;
        }
        if ((split = location.split(":")).length == 2) {
            return split;
        }
        String[] result = new String[2];
        String string = result[0] = split.length < 2 ? "" : split[0];
        result[1] = split.length == 0 ? "" : (split.length < 2 ? split[0] : split[1]);
        return result;
    }

    public static boolean isValidResourceLocation(String location) {
        String[] strings = EntityRadarCategoryConstants.decompose(location);
        return !strings[0].isEmpty() && !strings[1].isEmpty() && strings[0].matches("[a-z0-9\\._\\-]+") && strings[1].matches("[a-z0-9\\/\\._\\-]+");
    }
}

