/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBat;
import net.minecraft.client.model.ModelBlaze;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.model.ModelDragon;
import net.minecraft.client.model.ModelEnderMite;
import net.minecraft.client.model.ModelGhast;
import net.minecraft.client.model.ModelGuardian;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.model.ModelIllager;
import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.model.ModelLlama;
import net.minecraft.client.model.ModelMagmaCube;
import net.minecraft.client.model.ModelOcelot;
import net.minecraft.client.model.ModelParrot;
import net.minecraft.client.model.ModelRabbit;
import net.minecraft.client.model.ModelShulker;
import net.minecraft.client.model.ModelSilverfish;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.model.ModelSnowMan;
import net.minecraft.client.model.ModelSpider;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.model.ModelWither;
import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLlama;
import net.minecraft.client.renderer.entity.RenderOcelot;
import net.minecraft.client.renderer.entity.RenderPig;
import net.minecraft.client.renderer.entity.RenderWolf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ResourceLocation;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.misc.Misc;

public class EntityIconDefinitions {
    private static Method entityTextureMethod;
    static float slimeSquishBU;
    private static StringBuilder VARIANT_STRING_BUILDER;

    public static List<String> getMainModelPartFields(Render<?> renderer, ModelBase model, Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        if (model instanceof ModelBat) {
            String modelClassPath = ModelBat.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "batHead"));
            result.add(String.format("%s;%s", modelClassPath, "field_82895_a"));
        } else if (model instanceof ModelBlaze) {
            String modelClassPath = ModelBlaze.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "blazeHead"));
            result.add(String.format("%s;%s", modelClassPath, "field_78105_b"));
        } else if (model instanceof ModelSpider) {
            String modelClassPath = ModelSpider.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "spiderHead"));
            result.add(String.format("%s;%s", modelClassPath, "field_78209_a"));
        } else if (model instanceof ModelCreeper) {
            String modelClassPath = ModelCreeper.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78135_a"));
        } else if (model instanceof ModelParrot) {
            String modelClassPath = ModelParrot.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_192768_e"));
        } else if (model instanceof ModelRabbit) {
            String modelClassPath = ModelRabbit.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "rabbitHead"));
            result.add(String.format("%s;%s", modelClassPath, "field_178704_h"));
        } else if (model instanceof ModelSquid) {
            String modelClassPath = ModelSquid.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "squidBody"));
            result.add(String.format("%s;%s", modelClassPath, "field_78202_a"));
        } else if (model instanceof ModelIronGolem) {
            String modelClassPath = ModelIronGolem.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "ironGolemHead"));
            result.add(String.format("%s;%s", modelClassPath, "field_78178_a"));
        } else if (model instanceof ModelSnowMan) {
            String modelClassPath = ModelSnowMan.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78195_c"));
        } else if (model instanceof ModelDragon) {
            String modelClassPath = ModelDragon.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78221_a"));
        } else if (model instanceof ModelOcelot) {
            String modelClassPath = ModelOcelot.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "ocelotHead"));
            result.add(String.format("%s;%s", modelClassPath, "field_78156_g"));
        } else if (model instanceof ModelChicken) {
            String modelClassPath = ModelChicken.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78142_a"));
        } else if (model instanceof ModelGuardian) {
            String modelClassPath = ModelGuardian.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "guardianBody"));
            result.add(String.format("%s;%s", modelClassPath, "field_178710_a"));
        } else if (model instanceof ModelHorse) {
            String modelClassPath = ModelHorse.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_110709_a"));
        } else if (model instanceof ModelMagmaCube) {
            String modelClassPath = ModelMagmaCube.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "core"));
            result.add(String.format("%s;%s", modelClassPath, "field_78108_b"));
        } else if (model instanceof ModelWolf) {
            String modelClassPath = ModelWolf.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "wolfHeadMain"));
            result.add(String.format("%s;%s", modelClassPath, "field_78185_a"));
        } else if (model instanceof ModelIllager) {
            String modelClassPath = ModelIllager.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_191217_a"));
        } else if (model instanceof ModelVillager) {
            String modelClassPath = ModelVillager.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "villagerHead"));
            result.add(String.format("%s;%s", modelClassPath, "field_78191_a"));
        } else if (model instanceof ModelGhast) {
            String modelClassPath = ModelGhast.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "body"));
            result.add(String.format("%s;%s", modelClassPath, "field_78128_a"));
        } else if (model instanceof ModelShulker) {
            String modelClassPath = ModelShulker.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_187066_a"));
        }
        return result;
    }

    public static List<String> getSecondaryModelPartsFields(Render<?> renderer, ModelBase model, Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        if (model instanceof ModelRabbit) {
            String modelClassPath = ModelRabbit.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "rabbitRightEar"));
            result.add(String.format("%s;%s", modelClassPath, "field_178705_i"));
            result.add(String.format("%s;%s", modelClassPath, "rabbitLeftEar"));
            result.add(String.format("%s;%s", modelClassPath, "field_178702_j"));
            result.add(String.format("%s;%s", modelClassPath, "rabbitNose"));
            result.add(String.format("%s;%s", modelClassPath, "field_178700_l"));
        } else if (model instanceof ModelChicken) {
            String modelClassPath = ModelChicken.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "bill"));
            result.add(String.format("%s;%s", modelClassPath, "field_78137_g"));
            result.add(String.format("%s;%s", modelClassPath, "chin"));
            result.add(String.format("%s;%s", modelClassPath, "field_78143_h"));
        } else if (model instanceof ModelHorse) {
            String modelClassPath = ModelHorse.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "mane"));
            result.add(String.format("%s;%s", modelClassPath, "field_110714_j"));
            result.add(String.format("%s;%s", modelClassPath, "horseLeftEar"));
            result.add(String.format("%s;%s", modelClassPath, "field_110705_d"));
            result.add(String.format("%s;%s", modelClassPath, "horseRightEar"));
            result.add(String.format("%s;%s", modelClassPath, "field_110706_e"));
            result.add(String.format("%s;%s", modelClassPath, "muleLeftEar"));
            result.add(String.format("%s;%s", modelClassPath, "field_110703_f"));
            result.add(String.format("%s;%s", modelClassPath, "muleRightEar"));
            result.add(String.format("%s;%s", modelClassPath, "field_110704_g"));
        }
        return result;
    }

    public static boolean forceFieldCheck(ModelBase entityModel) {
        return false;
    }

    static void customTransformation(ModelBase em, Entity entity, EntityIconPrerenderer prerenderer) {
        if (em instanceof ModelBat) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof ModelHorse) {
            GlStateManager.func_179114_b((float)65.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        } else if (em instanceof ModelGuardian || em instanceof ModelSquid) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof ModelLlama) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (entity instanceof EntitySlime) {
            EntitySlime slime = (EntitySlime)entity;
            slimeSquishBU = slime.field_70811_b;
            slime.field_70811_b = 0.0f;
        } else if (em instanceof ModelGhast || em instanceof ModelDragon) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof ModelWither) {
            GlStateManager.func_179152_a((float)0.35f, (float)0.35f, (float)0.35f);
        }
    }

    public static void customPostRenderTransformation(ModelBase ModelBase2, Entity entity) {
        if (entity instanceof EntitySlime) {
            EntitySlime slime = (EntitySlime)entity;
            slime.field_70811_b = slimeSquishBU;
        }
    }

    static boolean fullModelIcon(ModelBase em) {
        return em instanceof ModelEnderMite || em instanceof ModelMagmaCube || em instanceof ModelSlime || em instanceof ModelSilverfish || em instanceof ModelWither;
    }

    public static EntityIconCustomRenderer getCustomLayer(Render entityRenderer, Entity entity) {
        return null;
    }

    public static void buildVariantIdString(StringBuilder stringBuilder, Render entityRenderer, Entity entity) {
        ResourceLocation entityTexture = EntityIconDefinitions.getEntityTexture(entityRenderer, entity);
        if (entityTexture == null) {
            return;
        }
        stringBuilder.append(entityTexture);
        if (entityRenderer instanceof RenderOcelot) {
            stringBuilder.append("%").append(((EntityOcelot)entity).func_70909_n());
        } else if (entityRenderer instanceof RenderWolf) {
            stringBuilder.append("%").append(((EntityWolf)entity).func_70909_n());
        } else if (entityRenderer instanceof RenderLlama) {
            EntityLlama llama = (EntityLlama)entity;
            stringBuilder.append("%").append("false").append("%").append(llama.func_190704_dO());
        } else if (entityRenderer instanceof RenderPig) {
            EntityPig pig = (EntityPig)entity;
            stringBuilder.append("%").append(pig.func_70901_n());
        }
    }

    public static String getVariantString(Render entityRenderer, Entity entity) {
        StringBuilder stringBuilder = VARIANT_STRING_BUILDER;
        stringBuilder.setLength(0);
        EntityIconDefinitions.buildVariantIdString(stringBuilder, entityRenderer, entity);
        return stringBuilder.toString();
    }

    public static Object getModelRoot(Render<?> entityRenderer, ModelBase entityModel) {
        return entityModel;
    }

    public static ResourceLocation getEntityTexture(Render entityRenderer, Entity e) {
        return (ResourceLocation)Misc.getReflectMethodValue(entityRenderer, entityTextureMethod, e);
    }

    static {
        VARIANT_STRING_BUILDER = new StringBuilder();
        entityTextureMethod = Misc.getMethodReflection(Render.class, "func_110775_a", "getEntityTexture", Entity.class);
    }
}

