/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.blocks.BlockSleepingBag;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="travelersbackpack")
public class PlayerEventHandler {
    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            TravelersBackpackWearable travelersBackpack = new TravelersBackpackWearable((EntityPlayer)event.getObject());
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider(travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void onPlayerStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ServerActions.electrify((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerSetSpawn(PlayerSetSpawnEvent event) {
        World world = event.getEntityPlayer().func_130014_f_();
        if (event.getNewSpawn() != null) {
            Block block = world.func_180495_p(event.getNewSpawn()).func_177230_c();
            if (!world.field_72995_K && !ConfigHandler.server.enableSleepingBagSpawnPoint && block instanceof BlockSleepingBag) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        World world = event.getEntityPlayer().field_70170_p;
        if (!world.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            if (ConfigHandler.server.enableSleepingBagSpawnPoint && BackpackUtils.findSleepingBag(world, player.func_180425_c())) {
                player.func_180473_a(player.func_180425_c(), true);
                player.field_71081_bT = null;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            CapabilityUtils.synchronise((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer && CapabilityUtils.isWearingBackpack(player = (EntityPlayer)event.getEntity()) && !player.func_130014_f_().func_82736_K().func_82766_b("keepInventory")) {
            BackpackUtils.onPlayerDeath(player.field_70170_p, player, CapabilityUtils.getWearingBackpack(player));
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        CapabilityUtils.getCapability(event.getEntityPlayer()).setWearable(CapabilityUtils.getCapability(event.getOriginal()).getWearable());
    }

    @SubscribeEvent
    public static void onPlayerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.player);
    }

    @SubscribeEvent
    public static void onPlayerTravelsAcrossDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.player);
    }

    @SubscribeEvent
    public static void onPlayerTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer) {
            CapabilityUtils.synchroniseToOthers((EntityPlayer)event.getTarget());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && !event.player.field_70128_L && CapabilityUtils.isWearingBackpack(event.player)) {
            World world = event.player.func_130014_f_();
            EntityPlayer player = event.player;
            if (event.phase == TickEvent.Phase.START) {
                CapabilityUtils.onEquippedUpdate(world, player, CapabilityUtils.getWearingBackpack(player));
            }
        }
    }
}

