/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.attractor.handlers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machines.machine.obelisk.attractor.TileAttractor;
import crazypants.enderio.machines.machine.obelisk.attractor.handlers.AttractTask;
import crazypants.enderio.machines.machine.obelisk.attractor.handlers.IMobAttractionHandler;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.tileentity.TileEntity;

public class AIAttractionHandler
implements IMobAttractionHandler {
    @Override
    @Nonnull
    public IMobAttractionHandler.State canAttract(TileAttractor attractor, EntityLiving entity) {
        if (entity.func_175446_cd()) {
            return IMobAttractionHandler.State.CANNOT_ATTRACT;
        }
        if (this.findAITask(null, entity) != null) {
            return IMobAttractionHandler.State.ALREADY_ATTRACTING;
        }
        return IMobAttractionHandler.State.CAN_ATTRACT;
    }

    @Override
    public void startAttracting(TileAttractor attractor, EntityLiving entity) {
        EntityAIBase remove = this.findAITask(attractor, entity);
        if (remove != null) {
            entity.field_70714_bg.func_85156_a(remove);
        }
        this.cancelCurrentTasks(entity);
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)this.makeAITask(attractor, entity));
    }

    @Nonnull
    protected AttractTask makeAITask(TileAttractor attractor, @Nonnull EntityLiving entity) {
        return new AttractTask(entity, attractor.getTarget(), attractor.func_174877_v());
    }

    protected EntityAIBase findAITask(TileAttractor attractor, EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a) {
            if (!(entry.field_75733_a instanceof AttractTask)) continue;
            AttractTask at = (AttractTask)entry.field_75733_a;
            if (attractor == null || at.coord.equals((Object)BlockCoord.get((TileEntity)attractor)) || !at.func_75253_b()) {
                return entry.field_75733_a;
            }
            return null;
        }
        return null;
    }

    private void cancelCurrentTasks(EntityLiving ent) {
        Iterator iterator = ent.field_70714_bg.field_75782_a.iterator();
        ArrayList<EntityAITasks.EntityAITaskEntry> currentTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (entityaitaskentry == null) continue;
            currentTasks.add(entityaitaskentry);
        }
        for (EntityAITasks.EntityAITaskEntry task : currentTasks) {
            ent.field_70714_bg.func_85156_a(task.field_75733_a);
            ent.field_70714_bg.func_75776_a(task.field_75731_b, task.field_75733_a);
        }
    }

    @Override
    public void tick(TileAttractor attractor, EntityLiving entity) {
    }

    @Override
    public void release(TileAttractor attractor, EntityLiving entity) {
        EntityAIBase remove = this.findAITask(attractor, entity);
        if (remove != null) {
            entity.field_70714_bg.func_85156_a(remove);
            this.cancelCurrentTasks(entity);
        }
    }
}

