/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.common.capability;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilitySleepTime {
    @CapabilityInject(value=ISleepTime.class)
    public static final Capability<ISleepTime> SLEEP_TIME_CAP = null;
    public static final EnumFacing DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("comforts", "sleepTime");

    public static void register() {
        CapabilityManager.INSTANCE.register(ISleepTime.class, (Capability.IStorage)new Capability.IStorage<ISleepTime>(){

            public NBTBase writeNBT(Capability<ISleepTime> capability, ISleepTime instance, EnumFacing side) {
                return new NBTTagLong(instance.getSleepTime());
            }

            public void readNBT(Capability<ISleepTime> capability, ISleepTime instance, EnumFacing side, NBTBase nbt) {
                instance.setSleepTime(((NBTTagLong)nbt).func_150291_c());
            }
        }, SleepTime::new);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @Nullable
    public static ISleepTime getSleepTime(EntityPlayer playerIn) {
        if (playerIn != null && playerIn.hasCapability(SLEEP_TIME_CAP, DEFAULT_FACING)) {
            return (ISleepTime)playerIn.getCapability(SLEEP_TIME_CAP, DEFAULT_FACING);
        }
        return null;
    }

    public static ICapabilityProvider createProvider(ISleepTime sleeping) {
        return new Provider(sleeping, SLEEP_TIME_CAP, DEFAULT_FACING);
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            if (evt.getObject() instanceof EntityPlayer) {
                evt.addCapability(ID, CapabilitySleepTime.createProvider(new SleepTime()));
            }
        }

        @SubscribeEvent
        public void onPlayerSleep(PlayerSleepInBedEvent evt) {
            ISleepTime sleepTime;
            EntityPlayer player = evt.getEntityPlayer();
            World world = player.func_130014_f_();
            if (!world.field_72995_K && (sleepTime = CapabilitySleepTime.getSleepTime(player)) != null) {
                sleepTime.setSleepTime(world.func_72820_D());
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        final Capability<ISleepTime> capability;
        final EnumFacing facing;
        final ISleepTime instance;

        Provider(ISleepTime instance, Capability<ISleepTime> capability, @Nullable EnumFacing facing) {
            this.instance = instance;
            this.capability = capability;
            this.facing = facing;
        }

        public boolean hasCapability(@Nullable Capability<?> capability, EnumFacing facing) {
            return capability == this.getCapability();
        }

        public <T> T getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
            return (T)(capability == this.getCapability() ? this.getCapability().cast((Object)this.instance) : null);
        }

        final Capability<ISleepTime> getCapability() {
            return this.capability;
        }

        EnumFacing getFacing() {
            return this.facing;
        }

        final ISleepTime getInstance() {
            return this.instance;
        }

        public NBTBase serializeNBT() {
            return this.getCapability().writeNBT((Object)this.getInstance(), this.getFacing());
        }

        public void deserializeNBT(NBTBase nbt) {
            this.getCapability().readNBT((Object)this.getInstance(), this.getFacing(), nbt);
        }
    }

    public static class SleepTime
    implements ISleepTime {
        private long sleepTime;

        @Override
        public long getSleepTime() {
            return this.sleepTime;
        }

        @Override
        public void setSleepTime(long time) {
            this.sleepTime = time;
        }
    }

    public static interface ISleepTime {
        public long getSleepTime();

        public void setSleepTime(long var1);
    }
}

