/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.init.BDModStructurePieces;
import com.yungnickyoung.minecraft.betterdungeons.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonEggRoomPiece;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import java.util.BitSet;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6130;
import net.minecraft.class_6625;

public class SpiderDungeonSmallTunnelPiece
extends SpiderDungeonPiece {
    private final class_2338 startPos;
    private class_2338 endPos;
    private float pitch = 0.0f;
    private final float[] yaws = new float[30];
    private static final int LENGTH = 30;
    private static final float X_MINRADIUS = 1.0f;
    private static final float X_MAXRADIUS = 1.5f;
    private static final float Y_MINRADIUS = 2.0f;
    private static final float Y_MAXRADIUS = 2.0f;
    private static final float Z_MINRADIUS = 1.0f;
    private static final float Z_MAXRADIUS = 1.5f;

    public SpiderDungeonSmallTunnelPiece(class_2338 startPos, float initialYaw, int pieceChainLength) {
        super(BDModStructurePieces.SPIDER_DUNGEON_SMALL_TUNNEL_PIECE, pieceChainLength, SpiderDungeonSmallTunnelPiece.getInitialBoundingBox(startPos));
        this.startPos = new class_2338((class_2382)startPos);
        this.endPos = new class_2338((class_2382)startPos);
        this.yaws[0] = initialYaw;
    }

    public SpiderDungeonSmallTunnelPiece(class_2487 compoundTag) {
        super(BDModStructurePieces.SPIDER_DUNGEON_SMALL_TUNNEL_PIECE, compoundTag);
        int[] start = compoundTag.method_10561("startPos");
        int[] end = compoundTag.method_10561("endPos");
        this.startPos = new class_2338(start[0], start[1], start[2]);
        this.endPos = new class_2338(end[0], end[1], end[2]);
        this.pitch = compoundTag.method_10583("pitch");
        class_2499 yawNbtList = compoundTag.method_10554("yawList", 5);
        for (int i = 0; i < 30; ++i) {
            this.yaws[i] = yawNbtList.method_10604(i);
        }
    }

    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        compoundTag.method_10539("startPos", new int[]{this.startPos.method_10263(), this.startPos.method_10264(), this.startPos.method_10260()});
        compoundTag.method_10539("endPos", new int[]{this.endPos.method_10263(), this.endPos.method_10264(), this.endPos.method_10260()});
        compoundTag.method_10548("pitch", this.pitch);
        class_2499 yawNbtList = new class_2499();
        for (int i = 0; i < 30; ++i) {
            yawNbtList.add((Object)class_2494.method_23244((float)this.yaws[i]));
        }
        compoundTag.method_10566("yawList", (class_2520)yawNbtList);
    }

    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, Random random) {
        this.pitch = random.nextFloat() * (float)Math.PI / 4.0f - 0.5235988f;
        float pitchY = class_3532.method_15374((float)this.pitch);
        float pitchXZ = class_3532.method_15362((float)this.pitch);
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        float caveStartX = this.startPos.method_10263();
        float caveStartY = this.startPos.method_10264();
        float caveStartZ = this.startPos.method_10260();
        caveStartX += class_3532.method_15362((float)this.yaws[0]) * pitchXZ;
        caveStartY += class_3532.method_15374((float)pitchY);
        caveStartZ += class_3532.method_15374((float)this.yaws[0]) * pitchXZ;
        float yawModifier = 0.0f;
        if (caveStartX - 1.5f - 4.0f < (float)minX) {
            minX = (int)caveStartX - 1 - 4;
        }
        if (caveStartX + 1.5f + 4.0f > (float)maxX) {
            maxX = (int)caveStartX + 1 + 4;
        }
        if (caveStartY - 2.0f - 4.0f < (float)minY) {
            minY = (int)caveStartY - 2 - 4;
        }
        if (caveStartY + 2.0f + 4.0f > (float)maxY) {
            maxY = (int)caveStartY + 2 + 4;
        }
        if (caveStartZ - 1.5f - 4.0f < (float)minZ) {
            minZ = (int)caveStartZ - 1 - 4;
        }
        if (caveStartZ + 1.5f + 4.0f > (float)maxZ) {
            maxZ = (int)caveStartZ + 1 + 4;
        }
        for (int i = 1; i < 30; ++i) {
            yawModifier *= 0.75f;
            this.yaws[i] = this.yaws[i - 1] + (yawModifier += random.nextFloat() * random.nextFloat()) * 0.02f;
            caveStartX += class_3532.method_15362((float)this.yaws[i]) * pitchXZ;
            caveStartY += class_3532.method_15374((float)pitchY);
            caveStartZ += class_3532.method_15374((float)this.yaws[i]) * pitchXZ;
            if (caveStartX - 1.5f - 4.0f < (float)minX) {
                minX = (int)caveStartX - 1 - 4;
            }
            if (caveStartX + 1.5f + 4.0f > (float)maxX) {
                maxX = (int)caveStartX + 1 + 4;
            }
            if (caveStartY - 2.0f - 4.0f < (float)minY) {
                minY = (int)caveStartY - 2 - 4;
            }
            if (caveStartY + 2.0f + 4.0f > (float)maxY) {
                maxY = (int)caveStartY + 2 + 4;
            }
            if (caveStartZ - 1.5f - 4.0f < (float)minZ) {
                minZ = (int)caveStartZ - 1 - 4;
            }
            if (!(caveStartZ + 1.5f + 4.0f > (float)maxZ)) continue;
            maxZ = (int)caveStartZ + 1 + 4;
        }
        ((BoundingBoxAccessor)this.field_15315).setMinX(minX);
        ((BoundingBoxAccessor)this.field_15315).setMaxX(maxX);
        ((BoundingBoxAccessor)this.field_15315).setMinY(minY);
        ((BoundingBoxAccessor)this.field_15315).setMaxY(maxY);
        ((BoundingBoxAccessor)this.field_15315).setMinZ(minZ);
        ((BoundingBoxAccessor)this.field_15315).setMaxZ(maxZ);
        this.endPos = new class_2338((double)caveStartX, (double)caveStartY, (double)caveStartZ);
        if (random.nextFloat() < 0.8f) {
            SpiderDungeonEggRoomPiece eggRoom = new SpiderDungeonEggRoomPiece(this.endPos, this.field_15316 + 1);
            structurePieceAccessor.method_35462((class_3443)eggRoom);
            eggRoom.method_14918(eggRoom, structurePieceAccessor, random);
        }
    }

    public void method_14931(class_5281 world, class_5138 structureFeatureManager, class_2794 chunkGenerator, Random random, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2919 decoRand = new class_2919((class_5819)new class_5820(0L));
        decoRand.method_12663(world.method_8412(), this.startPos.method_10263(), this.startPos.method_10260());
        int xBits = 4;
        int zBits = 4;
        int yBits = class_3532.method_15342((int)(world.method_31600() - world.method_31607()));
        BitSet carvingMask = new BitSet((int)Math.pow(2.0, xBits + zBits + yBits));
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.method_10103(chunkPos.method_8326() + x, 1, chunkPos.method_8328() + z);
                surface[x * 16 + z] = world.method_8624(class_2902.class_2903.field_13194, mutable.method_10263(), mutable.method_10260());
            }
        }
        float caveStartX = this.startPos.method_10263();
        float caveStartY = this.startPos.method_10264();
        float caveStartZ = this.startPos.method_10260();
        for (int i = 0; i < 30; ++i) {
            float pitchY = class_3532.method_15374((float)this.pitch);
            float pitchXZ = class_3532.method_15362((float)this.pitch);
            float yaw = this.yaws[i];
            caveStartX += class_3532.method_15362((float)yaw) * pitchXZ;
            caveStartY += class_3532.method_15374((float)pitchY);
            caveStartZ += class_3532.method_15374((float)yaw) * pitchXZ;
            float xRadius = class_3532.method_16439((float)class_3532.method_15374((float)((float)i * (float)Math.PI / 30.0f)), (float)1.0f, (float)1.5f);
            float yRadius = class_3532.method_16439((float)class_3532.method_15374((float)((float)i * (float)Math.PI / 30.0f)), (float)2.0f, (float)2.0f);
            float zRadius = class_3532.method_16439((float)class_3532.method_15374((float)((float)i * (float)Math.PI / 30.0f)), (float)1.0f, (float)1.5f);
            int minX = class_3532.method_15375((float)(caveStartX - xRadius)) - chunkPos.field_9181 * 16 - 1;
            int maxX = class_3532.method_15375((float)(caveStartX + xRadius)) - chunkPos.field_9181 * 16 + 1;
            int minY = class_3532.method_15340((int)(class_3532.method_15375((float)(caveStartY - yRadius)) - 1), (int)world.method_31607(), (int)world.method_31600());
            int maxY = class_3532.method_15340((int)(class_3532.method_15375((float)(caveStartY + yRadius)) + 1), (int)world.method_31607(), (int)world.method_31600());
            int minZ = class_3532.method_15375((float)(caveStartZ - zRadius)) - chunkPos.field_9180 * 16 - 1;
            int maxZ = class_3532.method_15375((float)(caveStartZ + zRadius)) - chunkPos.field_9180 * 16 + 1;
            minX = class_3532.method_15340((int)minX, (int)0, (int)15);
            maxX = class_3532.method_15340((int)maxX, (int)0, (int)15);
            minZ = class_3532.method_15340((int)minZ, (int)0, (int)15);
            maxZ = class_3532.method_15340((int)maxZ, (int)0, (int)15);
            for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
                int globalX = (int)x + chunkPos.field_9181 * 16;
                if (globalX < chunkPos.method_8326() || globalX > chunkPos.method_8327()) continue;
                float radialXDist = ((float)globalX - caveStartX + 0.5f) / xRadius;
                for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                    int globalY;
                    int globalZ = (int)z + chunkPos.field_9180 * 16;
                    if (globalZ < chunkPos.method_8328() || globalZ > chunkPos.method_8329()) continue;
                    float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / zRadius;
                    for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                        class_2680 state;
                        float radialYDist = (y - caveStartY - 0.5f) / yRadius;
                        int mask = (int)x | (int)z << 4 | (int)(y - (float)world.method_31607()) << 8;
                        float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                        if (!carvingMask.get(mask) && (double)radialDist < 1.0) {
                            if (BLOCK_BLACKLIST.contains(this.method_14929((class_1922)world, globalX, globalY, globalZ, box).method_26204())) continue;
                            this.method_14917(world, class_2246.field_10543.method_9564(), globalX, globalY, globalZ, box);
                            carvingMask.set(mask);
                            continue;
                        }
                        float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (xRadius + 1.2f);
                        float radialYDistShell = (y - caveStartY - 0.5f) / (yRadius + 1.2f);
                        float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (zRadius + 1.2f);
                        float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                        if (carvingMask.get(mask) || !((double)radialDistShell < 1.0) || BLOCK_BLACKLIST.contains((state = this.method_14929((class_1922)world, globalX, globalY, globalZ, box)).method_26204()) || !state.method_26215() && state.method_26227().method_15772() == class_3612.field_15906 && !(decoRand.nextFloat() < 0.2f)) continue;
                        this.method_14917(world, class_2246.field_10445.method_9564(), globalX, globalY, globalZ, box);
                    }
                }
            }
        }
        this.decorateCave(world, (Random)decoRand, chunkPos, box, carvingMask);
    }
}

