/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def;

import dev.quantumfusion.dashloader.core.DashLoaderCore;
import dev.quantumfusion.dashloader.core.io.IOHandler;
import dev.quantumfusion.dashloader.core.progress.ProgressHandler;
import dev.quantumfusion.dashloader.core.progress.task.CountTask;
import dev.quantumfusion.dashloader.core.progress.task.Task;
import dev.quantumfusion.dashloader.core.registry.ChunkHolder;
import dev.quantumfusion.dashloader.core.registry.RegistryReader;
import dev.quantumfusion.dashloader.core.registry.RegistryWriter;
import dev.quantumfusion.dashloader.def.DashDataManager;
import dev.quantumfusion.dashloader.def.api.DashLoaderAPI;
import dev.quantumfusion.dashloader.def.client.DashCachingScreen;
import dev.quantumfusion.dashloader.def.corehook.BakedQuadData;
import dev.quantumfusion.dashloader.def.corehook.IdentifierData;
import dev.quantumfusion.dashloader.def.corehook.ImageData;
import dev.quantumfusion.dashloader.def.corehook.MappingData;
import dev.quantumfusion.dashloader.def.corehook.ModelData;
import dev.quantumfusion.dashloader.def.corehook.RegistryData;
import dev.quantumfusion.dashloader.def.data.DashIdentifier;
import dev.quantumfusion.dashloader.def.data.DashIdentifierInterface;
import dev.quantumfusion.dashloader.def.data.DashModelIdentifier;
import dev.quantumfusion.dashloader.def.data.blockstate.DashBlockState;
import dev.quantumfusion.dashloader.def.data.font.DashFont;
import dev.quantumfusion.dashloader.def.data.image.DashImage;
import dev.quantumfusion.dashloader.def.data.image.DashSprite;
import dev.quantumfusion.dashloader.def.data.model.DashModel;
import dev.quantumfusion.dashloader.def.data.model.components.DashBakedQuad;
import dev.quantumfusion.dashloader.def.data.model.predicates.DashPredicate;
import dev.quantumfusion.dashloader.def.fallback.model.DashMissingDashModel;
import dev.quantumfusion.dashloader.def.util.TimeUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DashLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"DashLoader");
    public static final String VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("dashloader").orElseThrow(() -> new IllegalStateException("DashLoader not found... apparently! WTF?"))).getMetadata().getVersion().getFriendlyString();
    public static final Path DASH_CONFIG_FOLDER = FabricLoader.getInstance().getConfigDir().normalize();
    public static final Path DASH_CACHE_FOLDER = Path.of("./dashloader-cache/", new String[0]);
    public static final DashLoader INSTANCE = new DashLoader();
    public static long RELOAD_START = 0L;
    public static long EXPORT_TIME = -1L;
    public static long EXPORT_READING_TIME = -1L;
    public static long EXPORT_EXPORTING_TIME = -1L;
    public static long EXPORT_LOADING_TIME = -1L;
    private static Status STATUS = Status.NONE;
    private boolean shouldReload = true;
    private final DashMetadata metadata = new DashMetadata();
    private DashDataManager dataManager;

    private DashLoader() {
    }

    public static void prepare() {
        LOGGER.info("Preparing DashLoader " + VERSION + ".");
        INSTANCE.prepareInternal();
    }

    public static void init() {
        LOGGER.info("Initializing DashLoader " + VERSION + ".");
        INSTANCE.initInternal(Thread.currentThread().getContextClassLoader());
    }

    private void prepareInternal() {
        this.metadata.setModHash(FabricLoader.getInstance());
        Logger dlcLogger = LogManager.getLogger((String)"dl-core");
        DashLoaderCore.initialize((Path)DASH_CACHE_FOLDER.resolve("mods-" + this.metadata.modInfo + "/"), (Path)DASH_CONFIG_FOLDER.resolve("dashloader.json"), (DashLoaderCore.Printer)new DashLoaderCore.Printer(arg_0 -> ((Logger)dlcLogger).info(arg_0), arg_0 -> ((Logger)dlcLogger).warn(arg_0), arg_0 -> ((Logger)dlcLogger).error(arg_0)));
        DashLoaderCore.CORE.prepareCore();
    }

    private void initInternal(ClassLoader classLoader) {
        try {
            DashLoaderAPI api = new DashLoaderAPI();
            api.initAPI();
            DashLoaderCore.CORE.launchCore(api.dashObjects);
            DashLoaderCore.CONFIG.reloadConfig();
            FabricLoader instance = FabricLoader.getInstance();
            if (instance.isDevelopmentEnvironment()) {
                LOGGER.warn("DashLoader launched in dev.");
            }
            IOHandler io = DashLoaderCore.IO;
            io.setCacheArea(this.metadata.modInfo);
            io.setSubCacheArea("bootstrap");
            io.addSerializer(RegistryData.class, new Class[]{DashBlockState.class, DashFont.class, DashSprite.class, DashPredicate.class});
            io.addSerializer(ImageData.class, new Class[]{DashImage.class});
            io.addSerializer(ModelData.class, new Class[]{DashModel.class});
            io.addSerializer(IdentifierData.class, new Class[]{DashIdentifierInterface.class});
            io.addSerializer(BakedQuadData.class, new Class[]{DashBakedQuad.class});
            io.addSerializer(MappingData.class, new Class[0]);
            LOGGER.info("Created DashLoader with {}.", (Object)classLoader.getClass().getSimpleName());
            LOGGER.info("Initialized DashLoader");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("mc exception bad");
        }
    }

    public static DashDataManager getData() {
        DashDataManager dataManager = DashLoader.INSTANCE.dataManager;
        if (DashLoader.INSTANCE.dataManager == null) {
            throw new NullPointerException("No dataManager active");
        }
        return dataManager;
    }

    public void reload(List<String> resourcePacks) {
        if (this.shouldReload) {
            this.metadata.setResourcePackHash(resourcePacks);
            DashLoaderCore.IO.setSubCacheArea(this.metadata.resourcePacks);
            LOGGER.info("Reloading DashLoader. [mod-hash: {}] [resource-hash: {}]", (Object)this.metadata.modInfo, (Object)this.metadata.resourcePacks);
            if (DashLoaderCore.IO.cacheExists()) {
                this.setStatus(Status.READ);
                this.loadDashCache();
            } else {
                this.setStatus(Status.WRITE);
            }
            LOGGER.info("Reloaded DashLoader");
            this.shouldReload = false;
        }
    }

    public void requestReload() {
        this.shouldReload = true;
    }

    public void resetDashLoader() {
        this.setStatus(Status.NONE);
    }

    public void saveDashCache() {
        DashCachingScreen.STATUS = DashCachingScreen.Status.CACHING;
        LOGGER.info("Starting DashLoader Caching");
        try {
            long start = System.currentTimeMillis();
            ProgressHandler progress = DashLoaderCore.PROGRESS;
            CountTask main = new CountTask(12);
            progress.setTask((Task)main);
            progress.setCurrentTask("initializing");
            DashLoaderCore.REGISTRY.addCallback(DashModel.class, (rraw, registry) -> {
                DashDataManager.DashWriteContextData writeContextData = DashLoader.getData().getWriteContextData();
                if (writeContextData.missingModelsWrite.containsKey(rraw)) {
                    return (DashModel)writeContextData.missingModelsWrite.get(rraw);
                }
                DashMissingDashModel value = new DashMissingDashModel();
                writeContextData.missingModelsWrite.put(rraw, (Object)value);
                return value;
            });
            DashLoaderCore.REGISTRY.addCallback(DashIdentifierInterface.class, (rraw, registry) -> {
                if (rraw instanceof class_1091) {
                    class_1091 m = (class_1091)rraw;
                    return new DashModelIdentifier(m);
                }
                return new DashIdentifier((class_2960)rraw);
            });
            RegistryWriter writer = DashLoaderCore.REGISTRY.createWriter();
            MappingData mappings = new MappingData();
            mappings.map(writer, (Task)main);
            main.completedTask();
            ArrayList holders = new ArrayList();
            progress.setCurrentTask("export.image");
            main.task(() -> holders.add(new ImageData(writer)));
            progress.setCurrentTask("export.model");
            main.task(() -> holders.add(new ModelData(writer)));
            progress.setCurrentTask("export.registry");
            main.task(() -> holders.add(new RegistryData(writer)));
            progress.setCurrentTask("export.identifier");
            main.task(() -> holders.add(new IdentifierData(writer)));
            progress.setCurrentTask("export.quad");
            main.task(() -> holders.add(new BakedQuadData(writer)));
            IOHandler io = DashLoaderCore.IO;
            holders.forEach(holder -> main.task(() -> io.save(holder)));
            main.task(() -> io.save((Object)mappings));
            LOGGER.info("Created cache in " + TimeUtil.getTimeStringFromStart(start));
            DashCachingScreen.STATUS = DashCachingScreen.Status.DONE;
        }
        catch (Throwable thr) {
            this.setStatus(Status.NONE);
            LOGGER.error("Failed caching", thr);
            DashCachingScreen.STATUS = DashCachingScreen.Status.CRASHED;
            DashLoaderCore.IO.clearCache();
        }
    }

    public void loadDashCache() {
        long start = System.currentTimeMillis();
        IOHandler io = DashLoaderCore.IO;
        io.setSubCacheArea(this.metadata.resourcePacks);
        LOGGER.info("Starting DashLoader Deserialization");
        try {
            AtomicReference mappingsReference = new AtomicReference();
            ChunkHolder[] registryDataObjects = new ChunkHolder[5];
            long start2 = System.currentTimeMillis();
            DashLoaderCore.THREAD.parallelRunnable(new Runnable[]{() -> {
                registryDataObjects[0] = (ChunkHolder)io.load(RegistryData.class);
            }, () -> {
                registryDataObjects[1] = (ChunkHolder)io.load(ImageData.class);
            }, () -> {
                registryDataObjects[2] = (ChunkHolder)io.load(ModelData.class);
            }, () -> {
                registryDataObjects[3] = (ChunkHolder)io.load(IdentifierData.class);
            }, () -> {
                registryDataObjects[4] = (ChunkHolder)io.load(BakedQuadData.class);
            }, () -> mappingsReference.set((MappingData)io.load(MappingData.class))});
            EXPORT_READING_TIME = System.currentTimeMillis() - start2;
            MappingData mappings = (MappingData)mappingsReference.get();
            assert (mappings != null);
            LOGGER.info("Creating Registry");
            RegistryReader reader = DashLoaderCore.REGISTRY.createReader(registryDataObjects);
            this.dataManager = new DashDataManager(new DashDataManager.DashReadContextData());
            start2 = System.currentTimeMillis();
            LOGGER.info("Exporting Mappings");
            reader.export();
            EXPORT_EXPORTING_TIME = System.currentTimeMillis() - start2;
            start2 = System.currentTimeMillis();
            LOGGER.info("Loading Mappings");
            mappings.export(reader, this.dataManager);
            EXPORT_LOADING_TIME = System.currentTimeMillis() - start2;
            EXPORT_TIME = System.currentTimeMillis() - start;
            LOGGER.info("Loaded DashLoader in {}", (Object)EXPORT_TIME);
        }
        catch (Exception e) {
            LOGGER.error("Summoned CrashLoader in {}", (Object)TimeUtil.getTimeStringFromStart(start), (Object)e);
            this.setStatus(Status.NONE);
            DashLoaderCore.IO.clearCache();
        }
    }

    private void setStatus(Status status) {
        LOGGER.info("\u001b[46m\u001b[30m DashLoader Status change {}\n\u001b[0m", (Object)status);
        STATUS = status;
        switch (status) {
            case NONE: {
                this.dataManager = null;
                break;
            }
            case READ: {
                this.dataManager = new DashDataManager(new DashDataManager.DashReadContextData());
                break;
            }
            case WRITE: {
                this.dataManager = new DashDataManager(new DashDataManager.DashWriteContextData());
            }
        }
    }

    public static boolean isWrite() {
        return STATUS == Status.WRITE;
    }

    public static boolean isRead() {
        return STATUS == Status.READ;
    }

    public static Status getStatus() {
        return STATUS;
    }

    public static class DashMetadata {
        public String modInfo;
        public String resourcePacks;

        public void setModHash(FabricLoader loader) {
            ModMetadata metadata;
            ArrayList<ModMetadata> versions = new ArrayList<ModMetadata>();
            for (ModContainer mod : loader.getAllMods()) {
                metadata = mod.getMetadata();
                versions.add(metadata);
            }
            versions.sort(Comparator.comparing(ModMetadata::getId));
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < versions.size(); ++i) {
                metadata = (ModMetadata)versions.get(i);
                stringBuilder.append(i).append("$").append(metadata.getId()).append('&').append(metadata.getVersion().getFriendlyString());
            }
            this.modInfo = DigestUtils.md5Hex((String)stringBuilder.toString()).toUpperCase();
        }

        public void setResourcePackHash(List<String> resourcePacks) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < resourcePacks.size(); ++i) {
                String resourcePack = resourcePacks.get(i);
                stringBuilder.append(i).append("$").append(resourcePack);
            }
            this.resourcePacks = DigestUtils.md5Hex((String)stringBuilder.toString()).toUpperCase();
        }
    }

    public static enum Status {
        NONE,
        READ,
        WRITE;

    }
}

