/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def.api;

import dev.quantumfusion.dashloader.core.Dashable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DashLoaderAPI {
    public static final Logger LOGGER = LogManager.getLogger((String)"DashLoaderAPI");
    public final List<Class<?>> dashObjects = Collections.synchronizedList(new ArrayList());
    private boolean initialized = false;
    private boolean failed = false;

    private void clearAPI() {
        this.dashObjects.clear();
    }

    public <F, D extends Dashable<F>> void registerDashObject(Class<D> dashClass) {
        Class<?>[] interfaces = dashClass.getInterfaces();
        if (interfaces.length == 0) {
            LOGGER.error("No Interfaces found. Class: {}", (Object)dashClass.getSimpleName());
            this.failed = true;
            return;
        }
        this.dashObjects.add(dashClass);
    }

    public void initAPI() {
        if (!this.initialized) {
            Instant start = Instant.now();
            this.clearAPI();
            FabricLoader.getInstance().getAllMods().forEach(modContainer -> {
                ModMetadata metadata = modContainer.getMetadata();
                if (metadata.getCustomValues().size() != 0) {
                    CustomValue value = metadata.getCustomValue("dashloader:customobject");
                    if (value != null) {
                        LOGGER.error("Found DashLoader 2.0 mod: " + modContainer.getMetadata().getId());
                    }
                    this.applyForClassesInValue(metadata, "dashloader:dashobject", this::registerDashObject);
                }
            });
            if (this.failed) {
                throw new RuntimeException("Failed to initialize the API");
            }
            LOGGER.info("[" + Duration.between(start, Instant.now()).toMillis() + "ms] Initialized api.");
            this.initialized = true;
        }
    }

    private <F, D extends Dashable<F>> void applyForClassesInValue(ModMetadata modMetadata, String valueName, Consumer<Class<D>> func) {
        CustomValue value = modMetadata.getCustomValue(valueName);
        if (value != null) {
            for (CustomValue customValue : value.getAsArray()) {
                String dashObject = customValue.getAsString();
                try {
                    Class<?> closs = Class.forName(dashObject, true, Thread.currentThread().getContextClassLoader());
                    func.accept(closs);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class not found, Mod: \"{}\", Value: \"{}\"", (Object)modMetadata.getId(), (Object)customValue.getAsString());
                    this.failed = true;
                }
                catch (Throwable throwable) {
                    LOGGER.error("Failed to load class. Mod: \"{}\", Value: \"{}\"", (Object)modMetadata.getId(), (Object)customValue.getAsString());
                }
            }
        }
    }
}

