/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def.corehook.holder;

import dev.quantumfusion.dashloader.core.DashLoaderCore;
import dev.quantumfusion.dashloader.core.common.ObjectObjectList;
import dev.quantumfusion.dashloader.core.progress.task.CountTask;
import dev.quantumfusion.dashloader.core.progress.task.Task;
import dev.quantumfusion.dashloader.core.registry.RegistryReader;
import dev.quantumfusion.dashloader.core.registry.RegistryWriter;
import dev.quantumfusion.dashloader.def.DashDataManager;
import dev.quantumfusion.dashloader.def.data.image.DashSpriteAtlasTexture;
import dev.quantumfusion.dashloader.def.data.image.DashSpriteAtlasTextureData;
import dev.quantumfusion.dashloader.def.mixin.accessor.SpriteAtlasManagerAccessor;
import dev.quantumfusion.hyphen.scan.annotations.Data;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_4724;
import org.apache.commons.lang3.tuple.Pair;

@Data
public class DashSpriteAtlasData {
    public final ObjectObjectList<DashSpriteAtlasTexture, Integer> atlases;

    public DashSpriteAtlasData(ObjectObjectList<DashSpriteAtlasTexture, Integer> atlases) {
        this.atlases = atlases;
    }

    public DashSpriteAtlasData(DashDataManager data, RegistryWriter writer) {
        this.atlases = new ObjectObjectList();
        Map<class_2960, class_1059> atlases = ((SpriteAtlasManagerAccessor)data.spriteAtlasManager.getMinecraftData()).getAtlases();
        List<class_1059> extraAtlases = data.getWriteContextData().extraAtlases;
        CountTask task = new CountTask(atlases.size() + extraAtlases.size());
        DashLoaderCore.PROGRESS.getCurrentContext().setSubtask((Task)task);
        atlases.forEach((identifier, spriteAtlasTexture) -> {
            this.addAtlas(data, writer, (class_1059)spriteAtlasTexture, 0);
            task.completedTask();
        });
        extraAtlases.forEach(spriteAtlasTexture -> {
            this.addAtlas(data, writer, (class_1059)spriteAtlasTexture, 1);
            task.completedTask();
        });
    }

    private void addAtlas(DashDataManager data, RegistryWriter writer, class_1059 texture, int i) {
        this.atlases.put((Object)new DashSpriteAtlasTexture(texture, (DashSpriteAtlasTextureData)data.getWriteContextData().atlasData.get((Object)texture), writer), (Object)i);
    }

    public Pair<class_4724, List<class_1059>> export(RegistryReader exportHandler) {
        ArrayList out = new ArrayList(this.atlases.list().size());
        ArrayList toRegister = new ArrayList(this.atlases.list().size());
        this.atlases.forEach((key, value) -> {
            if (value == 0) {
                out.add(key.export(exportHandler));
            }
            toRegister.add(key.export(exportHandler));
        });
        return Pair.of((Object)new class_4724(out), toRegister);
    }
}

