/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def.data.image.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.quantumfusion.dashloader.def.data.image.shader.DashGlBlendState;
import dev.quantumfusion.dashloader.def.data.image.shader.DashGlUniform;
import dev.quantumfusion.dashloader.def.data.image.shader.DashProgram;
import dev.quantumfusion.dashloader.def.data.image.shader.VertexFormatsHelper;
import dev.quantumfusion.dashloader.def.mixin.accessor.ShaderAccessor;
import dev.quantumfusion.dashloader.def.util.UnsafeHelper;
import dev.quantumfusion.hyphen.scan.annotations.Data;
import dev.quantumfusion.hyphen.scan.annotations.DataNullable;
import dev.quantumfusion.hyphen.scan.annotations.DataSubclasses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_284;
import net.minecraft.class_285;
import net.minecraft.class_293;
import net.minecraft.class_3679;
import net.minecraft.class_5944;

@Data
public class DashShader {
    public final Map<String, Sampler> samplers;
    public final String name;
    public final DashGlBlendState blendState;
    public final List<String> attributeNames;
    public final DashProgram vertexShader;
    public final DashProgram fragmentShader;
    public final VertexFormatsHelper.Value format;
    public final Map<String, DashGlUniform> loadedUniforms;
    public final List<String> samplerNames;
    transient class_5944 toApply;

    public DashShader(Map<String, Sampler> samplers, String name, DashGlBlendState blendState, List<String> attributeNames, DashProgram vertexShader, DashProgram fragmentShader, VertexFormatsHelper.Value format, Map<String, DashGlUniform> loadedUniforms, List<String> samplerNames) {
        this.samplers = samplers;
        this.name = name;
        this.blendState = blendState;
        this.attributeNames = attributeNames;
        this.vertexShader = vertexShader;
        this.fragmentShader = fragmentShader;
        this.format = format;
        this.loadedUniforms = loadedUniforms;
        this.samplerNames = samplerNames;
    }

    public DashShader(class_5944 shader) {
        ShaderAccessor shaderAccess = (ShaderAccessor)shader;
        this.samplers = new LinkedHashMap<String, Sampler>();
        shaderAccess.getSamplers().forEach((s, o) -> this.samplers.put((String)s, new Sampler(o)));
        this.name = shader.method_35787();
        this.blendState = new DashGlBlendState(shaderAccess.getBlendState());
        this.attributeNames = shaderAccess.getAttributeNames();
        this.vertexShader = new DashProgram(shader.method_1274());
        this.fragmentShader = new DashProgram(shader.method_1278());
        this.format = VertexFormatsHelper.getEnum(shader.method_35786());
        this.loadedUniforms = new HashMap<String, DashGlUniform>();
        shaderAccess.getLoadedUniforms().forEach((s, glUniform) -> this.loadedUniforms.put((String)s, new DashGlUniform((class_284)glUniform)));
        this.samplerNames = shaderAccess.getSamplerNames();
    }

    public class_5944 export() {
        this.toApply = UnsafeHelper.allocateInstance(class_5944.class);
        ShaderAccessor shaderAccess = (ShaderAccessor)this.toApply;
        shaderAccess.setLoadedSamplerIds(new ArrayList<Integer>());
        shaderAccess.setLoadedUniformIds(new ArrayList<Integer>());
        shaderAccess.setLoadedUniforms(new HashMap<String, class_284>());
        ArrayList<class_284> uniforms = new ArrayList<class_284>();
        shaderAccess.setUniforms(uniforms);
        ArrayList<Integer> loadedAttributeIds = new ArrayList<Integer>();
        shaderAccess.setLoadedAttributeIds(loadedAttributeIds);
        shaderAccess.setSamplerNames(this.samplerNames);
        shaderAccess.setName(this.name);
        class_293 format = this.format.getFormat();
        shaderAccess.setFormat(format);
        HashMap<String, Object> samplersOut = new HashMap<String, Object>();
        this.samplers.forEach((s, o) -> samplersOut.put((String)s, o.sampler));
        shaderAccess.setSamplers(samplersOut);
        shaderAccess.setAttributeNames(this.attributeNames);
        HashMap uniformsOut = new HashMap();
        this.loadedUniforms.forEach((s, dashGlUniform) -> uniformsOut.put(s, dashGlUniform.export((class_3679)this.toApply, uniforms)));
        class_284 modelViewMatOut = (class_284)uniformsOut.get("ModelViewMat");
        class_284 projectionMatOut = (class_284)uniformsOut.get("ProjMat");
        class_284 textureMatOut = (class_284)uniformsOut.get("TextureMat");
        class_284 screenSizeOut = (class_284)uniformsOut.get("ScreenSize");
        class_284 colorModulatorOut = (class_284)uniformsOut.get("ColorModulator");
        class_284 light0DirectionOut = (class_284)uniformsOut.get("Light0_Direction");
        class_284 light1DirectionOut = (class_284)uniformsOut.get("Light1_Direction");
        class_284 fogStartOut = (class_284)uniformsOut.get("FogStart");
        class_284 fogEndOut = (class_284)uniformsOut.get("FogEnd");
        class_284 fogColorOut = (class_284)uniformsOut.get("FogColor");
        class_284 lineWidthOut = (class_284)uniformsOut.get("LineWidth");
        class_284 gameTimeOut = (class_284)uniformsOut.get("GameTime");
        class_284 chunkOffsetOut = (class_284)uniformsOut.get("ChunkOffset");
        this.toApply.method_1279();
        shaderAccess.setModelViewMat(modelViewMatOut);
        shaderAccess.setProjectionMat(projectionMatOut);
        shaderAccess.setTextureMat(textureMatOut);
        shaderAccess.setScreenSize(screenSizeOut);
        shaderAccess.setColorModulator(colorModulatorOut);
        shaderAccess.setLight0Direction(light0DirectionOut);
        shaderAccess.setLight1Direction(light1DirectionOut);
        shaderAccess.setFogStart(fogStartOut);
        shaderAccess.setFogEnd(fogEndOut);
        shaderAccess.setFogColor(fogColorOut);
        shaderAccess.setLineWidth(lineWidthOut);
        shaderAccess.setGameTime(gameTimeOut);
        shaderAccess.setChunkOffset(chunkOffsetOut);
        return this.toApply;
    }

    public void apply() {
        ShaderAccessor shaderAccess = (ShaderAccessor)this.toApply;
        shaderAccess.setBlendState(this.blendState.export());
        shaderAccess.setVertexShader(this.vertexShader.exportProgram());
        shaderAccess.setFragmentShader(this.fragmentShader.exportProgram());
        List<Integer> loadedAttributeIds = shaderAccess.getLoadedAttributeIds();
        int programId = GlStateManager.glCreateProgram();
        shaderAccess.setProgramId(programId);
        if (this.attributeNames != null) {
            int l = 0;
            for (String string3 : this.format.getFormat().method_34445()) {
                class_284.method_34419((int)programId, (int)l, (CharSequence)string3);
                loadedAttributeIds.add(l);
                ++l;
            }
        }
        class_285.method_1307((class_3679)this.toApply);
        shaderAccess.loadref();
    }

    public static class Sampler {
        @Data
        @DataNullable
        public final @DataSubclasses(value={Integer.class, String.class}) Object sampler;

        public Sampler(Object sampler) {
            this.sampler = sampler;
        }
    }
}

