/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.def.data.model.components;

import dev.quantumfusion.dashloader.def.util.ClassHelper;
import dev.quantumfusion.dashloader.def.util.UnsafeHelper;
import dev.quantumfusion.hyphen.scan.annotations.Data;
import java.lang.reflect.Field;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;

@Data
public record DashMesh(int[] data, String className) {
    public DashMesh(Mesh mesh) {
        this(DashMesh.getData(mesh), mesh.getClass().getName());
    }

    private static int[] getData(Mesh mesh) {
        int[] data;
        try {
            Field field = mesh.getClass().getDeclaredField("data");
            field.setAccessible(true);
            data = (int[])field.get(mesh);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Could not use Mesh field hack. ", e);
        }
        return data;
    }

    public Mesh export() {
        Class<?> aClass = ClassHelper.getClass(this.className);
        Mesh mesh = (Mesh)UnsafeHelper.allocateInstance(aClass);
        try {
            Field data = aClass.getDeclaredField("data");
            data.setAccessible(true);
            data.set(mesh, this.data);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Could not use Mesh field hack. ", e);
        }
        return mesh;
    }
}

