/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.banner;

import com.yungnickyoung.minecraft.yungsapi.world.banner.BannerPattern;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2546;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class Banner {
    private List<BannerPattern> patterns;
    private class_2680 state;
    private class_2487 nbt;
    private boolean isWallBanner;

    public Banner(List<BannerPattern> patterns, class_2680 state, class_2487 nbt) {
        this.patterns = patterns;
        this.state = state;
        this.nbt = nbt;
        this.isWallBanner = this.state.method_26204() instanceof class_2546;
    }

    public Banner(List<BannerPattern> patterns, class_2680 state, class_2487 nbt, boolean isWallBanner) {
        this.patterns = patterns;
        this.state = state;
        this.nbt = nbt;
        this.isWallBanner = isWallBanner;
    }

    public List<BannerPattern> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<BannerPattern> patterns) {
        this.patterns = patterns;
    }

    public class_2680 getState() {
        return this.state;
    }

    public void setState(class_2680 state) {
        this.state = state;
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    public void setNbt(class_2487 nbt) {
        this.nbt = nbt;
    }

    public boolean isWallBanner() {
        return this.isWallBanner;
    }

    public void setWallBanner(boolean wallBanner) {
        this.isWallBanner = wallBanner;
    }

    public static class Builder {
        private final List<BannerPattern> patterns = new ArrayList<BannerPattern>();
        private class_2588 customNameTranslate;
        private String customColor;
        private class_2680 state = class_2246.field_10537.method_9564();

        public Builder blockState(class_2680 state) {
            this.state = state;
            return this;
        }

        public Builder pattern(BannerPattern pattern) {
            this.patterns.add(pattern);
            return this;
        }

        public Builder pattern(String pattern, int color) {
            this.patterns.add(new BannerPattern(pattern, color));
            return this;
        }

        public Builder customName(String translatableNamePath) {
            this.customNameTranslate = new class_2588(translatableNamePath);
            return this;
        }

        public Builder customColor(String colorString) {
            this.customColor = colorString;
            return this;
        }

        public Banner build() {
            class_2487 nbt = this.createBannerNBT(this.patterns);
            return new Banner(this.patterns, this.state, nbt);
        }

        private class_2487 createBannerNBT(List<BannerPattern> patterns) {
            class_2487 nbt = new class_2487();
            class_2499 patternList = new class_2499();
            for (BannerPattern pattern : patterns) {
                class_2487 patternNBT = new class_2487();
                patternNBT.method_10582("Pattern", pattern.getPattern());
                patternNBT.method_10569("Color", pattern.getColor());
                patternList.add((Object)patternNBT);
            }
            if (this.customColor != null || this.customNameTranslate != null) {
                Object name;
                String color = this.customColor == null ? "" : String.format("\"color\":\"%s\"", this.customColor);
                Object object = name = this.customNameTranslate == null ? "" : String.format("\"translate\":\"%s\"", this.customNameTranslate.method_11022());
                if (this.customColor != null && this.customNameTranslate != null) {
                    name = "," + (String)name;
                }
                String customNameString = "{" + color + (String)name + "}";
                nbt.method_10582("CustomName", customNameString);
            }
            nbt.method_10566("Patterns", (class_2520)patternList);
            nbt.method_10582("id", "minecraft:banner");
            return nbt;
        }
    }
}

