/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.apace100.calio.data.MultiJsonDataLoader;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginRegistry;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class OriginManager
extends MultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public OriginManager() {
        super(GSON, "origins");
    }

    protected void apply(Map<class_2960, List<JsonElement>> loader, class_3300 manager, class_3695 profiler) {
        OriginRegistry.reset();
        loader.forEach((id, jel) -> jel.forEach(je -> {
            try {
                Origin origin = Origin.fromJson(id, je.getAsJsonObject());
                if (!OriginRegistry.contains(id)) {
                    OriginRegistry.register(id, origin);
                } else if (OriginRegistry.get(id).getLoadingPriority() < origin.getLoadingPriority()) {
                    OriginRegistry.update(id, origin);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading Origin file " + id.toString() + " (skipping): " + e.getMessage());
            }
        }));
        Origins.LOGGER.info("Finished loading origins from data files. Registry contains " + OriginRegistry.size() + " origins.");
    }

    public class_2960 getFabricId() {
        return new class_2960("origins", "origins");
    }
}

