/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.google.common.collect.Lists;
import io.github.apace100.apoli.integration.PostPowerLoadCallback;
import io.github.apace100.apoli.integration.PowerReloadCallback;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.PowerTypes;
import io.github.apace100.apoli.power.ToggleNightVisionPower;
import io.github.apace100.apoli.power.TogglePower;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.screen.Badge;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class BadgeManager {
    private final HashMap<class_2960, List<Badge>> badges = new HashMap();

    public BadgeManager() {
        PowerReloadCallback.EVENT.register(this::clear);
        PowerTypes.registerAdditionalData((String)"badges", (powerId, factoryId, isSubPower, data, powerType) -> {
            if (!powerType.isHidden()) {
                if (data.isJsonArray()) {
                    this.badges.put(powerId, new LinkedList());
                    data.getAsJsonArray().forEach(badgeJson -> {
                        if (badgeJson.isJsonObject()) {
                            Badge badge = Badge.fromData(Badge.DATA.read(badgeJson.getAsJsonObject()));
                            this.addBadge(powerId, badge);
                        } else {
                            Origins.LOGGER.error("\"badges\" field in power \"" + powerId + "\" contained an entry that was not a JSON object.");
                        }
                    });
                } else {
                    Origins.LOGGER.error("\"badges\" field in power \"" + powerId + "\" should be an array.");
                }
            }
        });
        PostPowerLoadCallback.EVENT.register((powerId, factoryId, isSubPower, data, powerType) -> {
            if (!this.badges.containsKey(powerId) || this.badges.get(powerId).size() == 0) {
                Power power = powerType.create(null);
                Badge autoBadge = null;
                if (power instanceof TogglePower || power instanceof ToggleNightVisionPower) {
                    autoBadge = Badge.TOGGLE;
                } else if (power instanceof Active) {
                    autoBadge = Badge.ACTIVE;
                }
                if (autoBadge == null && powerType instanceof MultiplePowerType) {
                    MultiplePowerType mp = (MultiplePowerType)powerType;
                    for (class_2960 subPower : mp.getSubPowers()) {
                        if (!PowerTypeRegistry.contains((class_2960)subPower)) continue;
                        Power sp = PowerTypeRegistry.get((class_2960)subPower).create(null);
                        if (sp instanceof TogglePower || sp instanceof ToggleNightVisionPower) {
                            autoBadge = Badge.TOGGLE;
                            break;
                        }
                        if (!(sp instanceof Active)) continue;
                        autoBadge = Badge.ACTIVE;
                        break;
                    }
                }
                if (autoBadge != null) {
                    this.addBadge(powerId, autoBadge);
                }
            }
        });
    }

    public void clear() {
        this.badges.clear();
    }

    public void addBadge(class_2960 powerId, Badge badge) {
        List badgeList = this.badges.computeIfAbsent(powerId, id -> new LinkedList());
        badgeList.add(badge);
    }

    public List<Badge> getBadges(class_2960 powerId) {
        if (!this.badges.containsKey(powerId)) {
            return Lists.newArrayList();
        }
        return this.badges.get(powerId);
    }

    public void writeSyncData(class_2540 buf) {
        buf.writeInt(this.badges.size());
        this.badges.forEach((id, list) -> {
            buf.method_10812(id);
            buf.writeInt(list.size());
            list.forEach(badge -> Badge.DATA.write(buf, badge.getData()));
        });
    }
}

