/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class ChooseOriginScreen
extends OriginDisplayScreen {
    private final ArrayList<OriginLayer> layerList;
    private int currentLayerIndex = 0;
    private int currentOrigin = 0;
    private final List<Origin> originSelection;
    private int maxSelection = 0;
    private Origin randomOrigin;

    public ChooseOriginScreen(ArrayList<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super((class_2561)new class_2588("origins.screen.choose_origin"), showDirtBackground);
        Origin newOrigin;
        this.layerList = layerList;
        this.currentLayerIndex = currentLayerIndex;
        this.originSelection = new ArrayList<Origin>(10);
        class_746 player = class_310.method_1551().field_1724;
        OriginLayer currentLayer = layerList.get(currentLayerIndex);
        List<class_2960> originIdentifiers = currentLayer.getOrigins((class_1657)player);
        originIdentifiers.forEach(arg_0 -> this.lambda$new$0((class_1657)player, arg_0));
        this.originSelection.sort((a, b) -> {
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
        this.maxSelection = this.originSelection.size();
        if (currentLayer.isRandomAllowed() && currentLayer.getRandomOrigins((class_1657)player).size() > 0) {
            ++this.maxSelection;
        }
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
        }
        this.showOrigin(newOrigin, layerList.get(currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
    }

    private void openNextLayerScreen() {
        class_310.method_1551().method_1507((class_437)new WaitForNextLayerScreen(this.layerList, this.currentLayerIndex, this.showDirtBackground));
    }

    public boolean method_25422() {
        return false;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.maxSelection > 1) {
            this.method_37063((class_364)new class_4185(this.guiLeft - 40, this.field_22790 / 2 - 10, 20, 20, (class_2561)new class_2585("<"), b -> {
                Origin newOrigin;
                this.currentOrigin = (this.currentOrigin - 1 + this.maxSelection) % this.maxSelection;
                this.showOrigin(newOrigin, this.layerList.get(this.currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
            }));
            this.method_37063((class_364)new class_4185(this.guiLeft + 176 + 20, this.field_22790 / 2 - 10, 20, 20, (class_2561)new class_2585(">"), b -> {
                Origin newOrigin;
                this.currentOrigin = (this.currentOrigin + 1) % this.maxSelection;
                this.showOrigin(newOrigin, this.layerList.get(this.currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()) == this.randomOrigin);
            }));
        }
        this.method_37063((class_364)new class_4185(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20, (class_2561)new class_2588("origins.gui.select"), b -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            if (this.currentOrigin == this.originSelection.size()) {
                buf.method_10814(this.layerList.get(this.currentLayerIndex).getIdentifier().toString());
                ClientPlayNetworking.send((class_2960)ModPackets.CHOOSE_RANDOM_ORIGIN, (class_2540)buf);
            } else {
                buf.method_10814(this.getCurrentOrigin().getIdentifier().toString());
                buf.method_10814(this.layerList.get(this.currentLayerIndex).getIdentifier().toString());
                ClientPlayNetworking.send((class_2960)ModPackets.CHOOSE_ORIGIN, (class_2540)buf);
            }
            this.openNextLayerScreen();
        }));
    }

    @Override
    protected class_2561 getTitleText() {
        return new class_2588("origins.gui.choose_origin.title", new Object[]{new class_2588(this.getCurrentLayer().getTranslationKey())});
    }

    private Origin getCurrentOriginInternal() {
        if (this.currentOrigin == this.originSelection.size()) {
            if (this.randomOrigin == null) {
                this.initRandomOrigin();
            }
            return this.randomOrigin;
        }
        return this.originSelection.get(this.currentOrigin);
    }

    private void initRandomOrigin() {
        this.randomOrigin = new Origin(Origins.identifier("random"), new class_1799((class_1935)ModItems.ORB_OF_ORIGIN), Impact.NONE, -1, Integer.MAX_VALUE);
        class_2585 randomOriginText = new class_2585("");
        List<class_2960> randoms = this.layerList.get(this.currentLayerIndex).getRandomOrigins((class_1657)class_310.method_1551().field_1724);
        randoms.sort((ia, ib) -> {
            Origin a = OriginRegistry.get(ia);
            Origin b = OriginRegistry.get(ib);
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
        for (class_2960 id : randoms) {
            randomOriginText.method_10852((class_2561)OriginRegistry.get(id).getName());
            randomOriginText.method_10852((class_2561)new class_2585("\n"));
        }
        this.setRandomOriginText((class_2561)randomOriginText);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
            return;
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private /* synthetic */ void lambda$new$0(class_1657 player, class_2960 originId) {
        Origin origin = OriginRegistry.get(originId);
        if (origin.isChoosable()) {
            class_1799 displayItem = origin.getDisplayItem();
            if (!(displayItem.method_7909() != class_1802.field_8575 || displayItem.method_7985() && displayItem.method_7969().method_10545("SkullOwner"))) {
                displayItem.method_7948().method_10582("SkullOwner", player.method_5476().getString());
            }
            this.originSelection.add(origin);
        }
    }
}

