/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.fluid;

import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

public final class FluidStack {
    private static final FluidStack EMPTY = FluidStack.create(class_3612.field_15906, 0L);
    private long amount;
    @Nullable
    private class_2487 tag;
    private Supplier<class_3611> fluid;

    private FluidStack(Supplier<class_3611> fluid, long amount, class_2487 tag) {
        this.fluid = Objects.requireNonNull(fluid);
        this.amount = amount;
        this.tag = tag == null ? null : tag.method_10553();
    }

    public static FluidStack empty() {
        return EMPTY;
    }

    public static FluidStack create(class_3611 fluid, long amount, @Nullable class_2487 tag) {
        return FluidStack.create(() -> fluid, amount, tag);
    }

    public static FluidStack create(class_3611 fluid, long amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(Supplier<class_3611> fluid, long amount, @Nullable class_2487 tag) {
        return new FluidStack(fluid, amount, tag);
    }

    public static FluidStack create(Supplier<class_3611> fluid, long amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(FluidStack stack, long amount) {
        return FluidStack.create(stack.getRawFluidSupplier(), amount, stack.getTag());
    }

    public static long bucketAmount() {
        return FluidStackHooks.bucketAmount();
    }

    public final class_3611 getFluid() {
        return this.isEmpty() ? class_3612.field_15906 : this.getRawFluid();
    }

    @Nullable
    public final class_3611 getRawFluid() {
        return this.fluid.get();
    }

    public final Supplier<class_3611> getRawFluidSupplier() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.getRawFluid() == class_3612.field_15906 || this.amount <= 0L;
    }

    public long getAmount() {
        return this.isEmpty() ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Nullable
    public class_2487 getTag() {
        return this.tag;
    }

    public void setTag(@Nullable class_2487 tag) {
        this.tag = tag;
    }

    public class_2487 getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new class_2487());
        }
        return this.tag;
    }

    @Nullable
    public class_2487 getChildTag(String childName) {
        if (this.tag == null) {
            return null;
        }
        return this.tag.method_10562(childName);
    }

    public class_2487 getOrCreateChildTag(String childName) {
        this.getOrCreateTag();
        class_2487 child = this.tag.method_10562(childName);
        if (!this.tag.method_10573(childName, 10)) {
            this.tag.method_10566(childName, (class_2520)child);
        }
        return child;
    }

    public void removeChildTag(String childName) {
        if (this.tag != null) {
            this.tag.method_10551(childName);
        }
    }

    public class_2561 getName() {
        return FluidStackHooks.getName(this);
    }

    public String getTranslationKey() {
        return FluidStackHooks.getTranslationKey(this);
    }

    public FluidStack copy() {
        return new FluidStack(this.fluid, this.amount, this.tag);
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.getFluid().hashCode();
        code = 31 * code + Long.hashCode(this.amount);
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidStackEqual((FluidStack)o);
    }

    public boolean isFluidStackEqual(FluidStack other) {
        return this.getFluid() == other.getFluid() && this.getAmount() == other.getAmount() && this.isTagEqual(other);
    }

    private boolean isTagEqual(FluidStack other) {
        return this.tag == null ? other.tag == null : other.tag != null && this.tag.equals((Object)other.tag);
    }

    public static FluidStack read(class_2540 buf) {
        return FluidStackHooks.read(buf);
    }

    public static FluidStack read(class_2487 tag) {
        return FluidStackHooks.read(tag);
    }

    public void write(class_2540 buf) {
        FluidStackHooks.write(this, buf);
    }

    public class_2487 write(class_2487 tag) {
        return FluidStackHooks.write(this, tag);
    }
}

