/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guicompass.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ConfigHandler {
    public static PropertyMirror<String> guiCompassFormat = PropertyMirror.create((ConfigType)ConfigTypes.STRING);
    public static PropertyMirror<Boolean> mustHaveCompassInInventory = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> compassPositionIsLeft = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> compassPositionIsCenter = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> compassPositionIsRight = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Integer> compassHeightOffset = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> RGB_R = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> RGB_G = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> RGB_B = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private static final ConfigTree CONFIG = ConfigTree.builder().beginValue("guiCompassFormat", (ConfigType)ConfigTypes.STRING, (Object)"FXYZ").withComment("What of the GUI compass should be displayed. Default: [FXYZ]. F: facing (direction), X: x coord, Y: y coord (depth), Z: z coord.").finishValue(arg_0 -> guiCompassFormat.mirror(arg_0)).beginValue("mustHaveCompassInInventory", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("When enabled, will only show the GUI compass when a compass is present in the inventory.").finishValue(arg_0 -> mustHaveCompassInInventory.mirror(arg_0)).beginValue("compassPositionIsLeft", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Places the GUI compass on the left.").finishValue(arg_0 -> compassPositionIsLeft.mirror(arg_0)).beginValue("compassPositionIsCenter", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Places the GUI compass in the middle.").finishValue(arg_0 -> compassPositionIsCenter.mirror(arg_0)).beginValue("compassPositionIsRight", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Places the GUI compass on the right.").finishValue(arg_0 -> compassPositionIsRight.mirror(arg_0)).beginValue("compassHeightOffset", (ConfigType)ConfigTypes.INTEGER, (Object)5).withComment("The vertical offset (y coord) for the Compass. This determines how far down the time should be on the screen. Can be changed to prevent GUIs from overlapping.").finishValue(arg_0 -> compassHeightOffset.mirror(arg_0)).beginValue("RGB_R", (ConfigType)ConfigTypes.INTEGER, (Object)255).withComment("The red RGB value for the compass text.").finishValue(arg_0 -> RGB_R.mirror(arg_0)).beginValue("RGB_G", (ConfigType)ConfigTypes.INTEGER, (Object)255).withComment("The green RGB value for the compass text.").finishValue(arg_0 -> RGB_G.mirror(arg_0)).beginValue("RGB_B", (ConfigType)ConfigTypes.INTEGER, (Object)255).withComment("The blue RGB value for the compass text.").finishValue(arg_0 -> RGB_B.mirror(arg_0)).build();

    private static void writeDefaultConfig(Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setup() {
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path p = Paths.get("config", "guicompass-fabric.json");
        ConfigHandler.writeDefaultConfig(p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            System.out.println("Error loading config");
        }
    }
}

