/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.config.ClientConfig;
import de.maxhenkel.voicechat.config.PlayerVolumeConfig;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.macos.PermissionCheck;
import de.maxhenkel.voicechat.macos.jna.avfoundation.AVAuthorizationStatus;
import de.maxhenkel.voicechat.profile.UsernameCache;
import de.maxhenkel.voicechat.resourcepacks.VoiceChatResourcePack;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.MacOSUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

public abstract class VoicechatClient {
    public static ClientConfig CLIENT_CONFIG;
    public static PlayerVolumeConfig VOLUME_CONFIG;
    public static UsernameCache USERNAME_CACHE;
    public static VoiceChatResourcePack CLASSIC_ICONS;
    public static VoiceChatResourcePack WHITE_ICONS;
    public static VoiceChatResourcePack BLACK_ICONS;

    public void initializeClient() {
        ClientCompatibilityManager.INSTANCE = this.createCompatibilityManager();
        this.fixVolumeConfig();
        VOLUME_CONFIG = new PlayerVolumeConfig(class_310.method_1551().field_1697.toPath().resolve("config").resolve("voicechat").resolve("voicechat-volumes.properties"));
        USERNAME_CACHE = new UsernameCache(class_310.method_1551().field_1697.toPath().resolve("config").resolve("voicechat").resolve("username-cache.json").toFile());
        ClientManager.instance();
        CLASSIC_ICONS = new VoiceChatResourcePack("Classic Icons", "classic_icons");
        WHITE_ICONS = new VoiceChatResourcePack("White Icons", "white_icons");
        BLACK_ICONS = new VoiceChatResourcePack("Black Icons", "black_icons");
        ClientCompatibilityManager.INSTANCE.addResourcePackSource(class_310.method_1551().method_1520(), (consumer, packConstructor) -> {
            consumer.accept(class_3288.method_14456((String)CLASSIC_ICONS.method_14409(), (boolean)false, () -> CLASSIC_ICONS, (class_3288.class_5351)packConstructor, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)class_5352.field_25348));
            consumer.accept(class_3288.method_14456((String)WHITE_ICONS.method_14409(), (boolean)false, () -> WHITE_ICONS, (class_3288.class_5351)packConstructor, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)class_5352.field_25348));
            consumer.accept(class_3288.method_14456((String)BLACK_ICONS.method_14409(), (boolean)false, () -> BLACK_ICONS, (class_3288.class_5351)packConstructor, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)class_5352.field_25348));
        });
        if (Platform.isMac() && VoicechatClient.CLIENT_CONFIG.macosMicrophoneWorkaround.get().booleanValue()) {
            Voicechat.LOGGER.info("Running MacOS microphone permission check");
            AVAuthorizationStatus status = PermissionCheck.getMicrophonePermissions();
            Voicechat.LOGGER.info("MacOS microphone permission: {}", (Object)status.name());
            if (!status.equals((Object)AVAuthorizationStatus.AUTHORIZED)) {
                MacOSUtils.checkPermissionInSeparateProcess();
            }
        }
    }

    private void fixVolumeConfig() {
        Path oldLocation = class_310.method_1551().field_1697.toPath().resolve("config").resolve("voicechat-volumes.properties");
        Path newLocation = class_310.method_1551().field_1697.toPath().resolve("config").resolve("voicechat").resolve("voicechat-volumes.properties");
        if (!newLocation.toFile().exists() && oldLocation.toFile().exists()) {
            try {
                Files.move(oldLocation, newLocation, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                Voicechat.LOGGER.error("Failed to move volumes config: {}", (Object)e.getMessage());
            }
        }
    }

    protected abstract ClientCompatibilityManager createCompatibilityManager();
}

