/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.plugins.PluginManager;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class SecretPacket
implements Packet<SecretPacket> {
    public static final class_2960 SECRET = new class_2960("voicechat", "secret");
    private UUID secret;
    private int serverPort;
    private UUID playerUUID;
    private ServerConfig.Codec codec;
    private int mtuSize;
    private double voiceChatDistance;
    private double voiceChatFadeDistance;
    private double crouchDistanceMultiplier;
    private double whisperDistanceMultiplier;
    private int keepAlive;
    private boolean groupsEnabled;
    private String voiceHost;
    private boolean allowRecording;

    public SecretPacket() {
    }

    public SecretPacket(class_3222 player, UUID secret, int port, ServerConfig serverConfig) {
        this.secret = secret;
        this.serverPort = port;
        this.playerUUID = player.method_5667();
        this.codec = serverConfig.voiceChatCodec.get();
        this.mtuSize = serverConfig.voiceChatMtuSize.get();
        this.voiceChatDistance = serverConfig.voiceChatDistance.get();
        this.voiceChatFadeDistance = serverConfig.voiceChatFadeDistance.get();
        this.crouchDistanceMultiplier = serverConfig.crouchDistanceMultiplier.get();
        this.whisperDistanceMultiplier = serverConfig.whisperDistanceMultiplier.get();
        this.keepAlive = serverConfig.keepAlive.get();
        this.groupsEnabled = serverConfig.groupsEnabled.get();
        this.voiceHost = PluginManager.instance().getVoiceHost(player, serverConfig.voiceHost.get());
        this.allowRecording = serverConfig.allowRecording.get();
    }

    public UUID getSecret() {
        return this.secret;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public ServerConfig.Codec getCodec() {
        return this.codec;
    }

    public int getMtuSize() {
        return this.mtuSize;
    }

    public double getVoiceChatDistance() {
        return this.voiceChatDistance;
    }

    public double getVoiceChatFadeDistance() {
        return this.voiceChatFadeDistance;
    }

    public double getCrouchDistanceMultiplier() {
        return this.crouchDistanceMultiplier;
    }

    public double getWhisperDistanceMultiplier() {
        return this.whisperDistanceMultiplier;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public boolean groupsEnabled() {
        return this.groupsEnabled;
    }

    public String getVoiceHost() {
        return this.voiceHost;
    }

    @Override
    public class_2960 getIdentifier() {
        return SECRET;
    }

    public boolean allowRecording() {
        return this.allowRecording;
    }

    @Override
    public SecretPacket fromBytes(class_2540 buf) {
        this.secret = buf.method_10790();
        this.serverPort = buf.readInt();
        this.playerUUID = buf.method_10790();
        this.codec = ServerConfig.Codec.values()[buf.readByte()];
        this.mtuSize = buf.readInt();
        this.voiceChatDistance = buf.readDouble();
        this.voiceChatFadeDistance = buf.readDouble();
        this.crouchDistanceMultiplier = buf.readDouble();
        this.whisperDistanceMultiplier = buf.readDouble();
        this.keepAlive = buf.readInt();
        this.groupsEnabled = buf.readBoolean();
        this.voiceHost = buf.method_10800(Short.MAX_VALUE);
        this.allowRecording = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.method_10797(this.secret);
        buf.writeInt(this.serverPort);
        buf.method_10797(this.playerUUID);
        buf.writeByte(this.codec.ordinal());
        buf.writeInt(this.mtuSize);
        buf.writeDouble(this.voiceChatDistance);
        buf.writeDouble(this.voiceChatFadeDistance);
        buf.writeDouble(this.crouchDistanceMultiplier);
        buf.writeDouble(this.whisperDistanceMultiplier);
        buf.writeInt(this.keepAlive);
        buf.writeBoolean(this.groupsEnabled);
        buf.method_10814(this.voiceHost);
        buf.writeBoolean(this.allowRecording);
    }
}

