/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.audiochannel;

import de.maxhenkel.voicechat.api.Entity;
import de.maxhenkel.voicechat.api.audiochannel.EntityAudioChannel;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import de.maxhenkel.voicechat.plugins.impl.ServerPlayerImpl;
import de.maxhenkel.voicechat.plugins.impl.audiochannel.AudioChannelImpl;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.server.Server;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class EntityAudioChannelImpl
extends AudioChannelImpl
implements EntityAudioChannel {
    protected Entity entity;
    protected boolean whispering;

    public EntityAudioChannelImpl(UUID channelId, Server server, Entity entity) {
        super(channelId, server);
        this.entity = entity;
        this.whispering = false;
    }

    @Override
    public void setWhispering(boolean whispering) {
        this.whispering = whispering;
    }

    @Override
    public boolean isWhispering() {
        return this.whispering;
    }

    @Override
    public void updateEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public void send(byte[] opusData) {
        this.broadcast(new PlayerSoundPacket(this.channelId, opusData, this.sequenceNumber.getAndIncrement(), this.whispering));
    }

    @Override
    public void send(MicrophonePacket microphonePacket) {
        this.broadcast(new PlayerSoundPacket(this.channelId, microphonePacket.getOpusEncodedData(), this.sequenceNumber.getAndIncrement(), this.whispering));
    }

    @Override
    public void flush() {
        this.broadcast(new PlayerSoundPacket(this.channelId, new byte[0], this.sequenceNumber.getAndIncrement(), this.whispering));
    }

    private void broadcast(PlayerSoundPacket packet) {
        Object object = this.entity.getEntity();
        if (object instanceof class_1297) {
            class_1297 entity = (class_1297)object;
            this.server.broadcast(ServerWorldUtils.getPlayersInRange((class_3218)entity.field_6002, entity.method_33571(), this.server.getBroadcastRange(), this.filter == null ? player -> true : player -> this.filter.test(new ServerPlayerImpl((class_3222)player))), packet, null, null, null, "plugin");
        }
    }
}

