/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.init;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.init.BMStructureFeatures;
import com.yungnickyoung.minecraft.bettermineshafts.mixin.BiomeSelectionContextImplAccessor;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftFeatureConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructureFeature;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.impl.biome.modification.BiomeSelectionContextImpl;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_5284;
import net.minecraft.class_5311;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5458;

public class BMConfiguredStructureFeatures {
    public static class_5312<?, ?> NORMAL_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.NORMAL));
    public static class_5312<?, ?> MESA_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.MESA));
    public static class_5312<?, ?> JUNGLE_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.JUNGLE));
    public static class_5312<?, ?> SNOW_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.SNOW));
    public static class_5312<?, ?> MUSHROOM_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.MUSHROOM));
    public static class_5312<?, ?> SAVANNA_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.SAVANNA));
    public static class_5312<?, ?> DESERT_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.DESERT));
    public static class_5312<?, ?> REDDESERT_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.RED_DESERT));
    public static class_5312<?, ?> ICE_MINESHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.ICE));
    public static class_5312<?, ?> LUSH_MINSHAFT = BMStructureFeatures.MINESHAFT_STRUCTURE.method_28659((class_3037)new BetterMineshaftFeatureConfig(BetterMineshafts.CONFIG.mineshaftSpawnRate, BetterMineshaftStructureFeature.Type.LUSH));
    public static Map<String, class_5312<?, ?>> exceptionMap;
    public static Map<class_1959.class_1961, class_5312<?, ?>> normalMap;

    public static void init() {
        BMConfiguredStructureFeatures.registerConfiguredStructures();
        BMConfiguredStructureFeatures.addConfiguredStructuresToBiomes();
    }

    private static void registerConfiguredStructures() {
        class_2378 registry = class_5458.field_25930;
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_normal"), NORMAL_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_mesa"), MESA_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_jungle"), JUNGLE_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_mushroom"), MUSHROOM_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_savanna"), SAVANNA_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_desert"), DESERT_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_reddesert"), REDDESERT_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_ice"), ICE_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_snow"), SNOW_MINESHAFT);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("bettermineshafts", "mineshaft_lush"), LUSH_MINSHAFT);
    }

    private static void addConfiguredStructuresToBiomes() {
        exceptionMap = new HashMap();
        normalMap = new HashMap();
        exceptionMap.put("ice", ICE_MINESHAFT);
        exceptionMap.put("icy", ICE_MINESHAFT);
        exceptionMap.put("lush_caves", LUSH_MINSHAFT);
        normalMap.put(class_1959.class_1961.field_9354, MESA_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9358, JUNGLE_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9362, SNOW_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9361, SNOW_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9368, DESERT_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9365, MUSHROOM_MINESHAFT);
        normalMap.put(class_1959.class_1961.field_9356, SAVANNA_MINESHAFT);
        BMConfiguredStructureFeatures.replaceMineshaftsInBiomes();
    }

    private static void replaceMineshaftsInBiomes() {
        BiomeModifications.create((class_2960)new class_2960("bettermineshafts", "mineshaft_replacement")).add(ModificationPhase.ADDITIONS, BMConfiguredStructureFeatures::biomeHasVanillaMineshaft, (selectionContext, modificationContext) -> {
            modificationContext.getGenerationSettings().removeStructure(class_3195.field_24844);
            class_2960 biomeName = selectionContext.getBiomeKey().method_29177();
            class_1959.class_1961 biomeCategory = selectionContext.getBiome().method_8688();
            if (biomeCategory == class_1959.class_1961.field_9367 || biomeCategory == class_1959.class_1961.field_9363) {
                return;
            }
            if (biomeName.toString().equals("minecraft:badlands")) {
                modificationContext.getGenerationSettings().addBuiltInStructure(REDDESERT_MINESHAFT);
                return;
            }
            class_5312<?, ?> mineshaft = null;
            for (String biomePhrase : exceptionMap.keySet()) {
                if (!biomeName.toString().contains(biomePhrase)) continue;
                mineshaft = exceptionMap.get(biomePhrase);
                break;
            }
            if (mineshaft != null) {
                modificationContext.getGenerationSettings().addBuiltInStructure(mineshaft);
            } else {
                mineshaft = normalMap.getOrDefault(biomeCategory, NORMAL_MINESHAFT);
                modificationContext.getGenerationSettings().addBuiltInStructure(mineshaft);
            }
        });
    }

    private static boolean biomeHasVanillaMineshaft(BiomeSelectionContext context) {
        if (context instanceof BiomeSelectionContextImpl) {
            class_5321 biomeKey = context.getBiomeKey();
            class_5455 registryAccess = ((BiomeSelectionContextImplAccessor)context).getDynamicRegistries();
            class_2378 chunkGeneratorSettings = registryAccess.method_30530(class_2378.field_26374);
            for (Map.Entry entry : chunkGeneratorSettings.method_29722()) {
                class_5311 structuresConfig = ((class_5284)entry.getValue()).method_28007();
                ImmutableMultimap configuredStructureToBiomeMap = structuresConfig.method_38424(class_3195.field_24844);
                for (class_5312 configuredStructureFeature : configuredStructureToBiomeMap.keySet()) {
                    ImmutableCollection biomes;
                    boolean anyMatch;
                    if (configuredStructureFeature.field_24835 != class_3195.field_24844 || !(anyMatch = (biomes = configuredStructureToBiomeMap.get((Object)configuredStructureFeature)).stream().map(class_5321::method_29177).anyMatch(keyString -> keyString.equals((Object)biomeKey.method_29177())))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

