/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructureFeature;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BigTunnel;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.LayeredIntersection4;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.LayeredIntersection5;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.OreDeposit;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SideRoom;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SideRoomDungeon;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnel;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnelStairs;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnelTurn;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.ZombieVillagerRoom;
import java.util.Random;
import net.minecraft.class_2350;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_6130;

public class BetterMineshaftGenerator {
    public static void generateAndAddBigTunnelPiece(class_3443 structurePiece, class_6130 structurePieceAccessor, Random random, int x, int y, int z, class_2350 direction, int chainLength) {
        if (chainLength > 3) {
            return;
        }
        int rand = random.nextInt(100);
        BetterMineshaftStructureFeature.Type type = ((MineshaftPiece)structurePiece).mineshaftType;
        if (rand >= 10 || chainLength < 1) {
            class_3341 boundingBox = BigTunnel.determineBoxPosition(x, y, z, direction);
            BigTunnel newPiece = new BigTunnel(chainLength + 1, random, boundingBox, direction, type);
            structurePieceAccessor.method_35462((class_3443)newPiece);
            ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
        }
    }

    public static MineshaftPiece generateAndAddSmallTunnelPiece(class_3443 structurePiece, class_6130 structurePieceAccessor, Random random, int x, int y, int z, class_2350 direction, int chainLength) {
        int rand = random.nextInt(100);
        BetterMineshaftStructureFeature.Type type = ((MineshaftPiece)structurePiece).mineshaftType;
        if (chainLength > BetterMineshafts.CONFIG.spawnRates.smallShaftPieceChainLength - 2) {
            if (rand < BetterMineshafts.CONFIG.spawnRates.zombieVillagerRoomSpawnChance) {
                if (direction == class_2350.field_11043) {
                    --x;
                } else if (direction == class_2350.field_11034) {
                    --z;
                } else if (direction == class_2350.field_11035) {
                    ++x;
                } else if (direction == class_2350.field_11039) {
                    ++z;
                }
                class_3341 boundingBox = ZombieVillagerRoom.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
                if (boundingBox != null) {
                    ZombieVillagerRoom newPiece = new ZombieVillagerRoom(chainLength + 1, random, boundingBox, direction, type);
                    structurePieceAccessor.method_35462((class_3443)newPiece);
                    ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
                    return newPiece;
                }
            } else {
                if (!BetterMineshafts.CONFIG.ores.enabled) {
                    return null;
                }
                class_3341 boundingBox = OreDeposit.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
                if (boundingBox != null) {
                    OreDeposit newPiece = new OreDeposit(chainLength + 1, random, boundingBox, direction, type);
                    structurePieceAccessor.method_35462((class_3443)newPiece);
                    ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
                    return newPiece;
                }
            }
            return null;
        }
        if (rand >= 90 && chainLength > 2 && chainLength < BetterMineshafts.CONFIG.spawnRates.smallShaftPieceChainLength - 2) {
            class_3341 boundingBox = LayeredIntersection4.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
            if (boundingBox != null) {
                LayeredIntersection4 newPiece = new LayeredIntersection4(chainLength + 1, random, boundingBox, direction, type);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
                return newPiece;
            }
        } else if (rand >= 80 && chainLength < BetterMineshafts.CONFIG.spawnRates.smallShaftPieceChainLength - 2) {
            class_3341 boundingBox = SmallTunnelStairs.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
            if (boundingBox != null) {
                SmallTunnelStairs newPiece = new SmallTunnelStairs(chainLength + 1, random, boundingBox, direction, type);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
                return newPiece;
            }
        } else if (rand >= 70 && chainLength > 2) {
            class_3341 boundingBox = SmallTunnelTurn.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
            if (boundingBox != null) {
                SmallTunnelTurn newPiece = new SmallTunnelTurn(chainLength + 1, random, boundingBox, direction, type);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
                return newPiece;
            }
        } else if (rand >= 60 && chainLength > 2 && chainLength < BetterMineshafts.CONFIG.spawnRates.smallShaftPieceChainLength - 2) {
            class_3341 boundingBox = LayeredIntersection5.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
            if (boundingBox != null) {
                LayeredIntersection5 newPiece = new LayeredIntersection5(chainLength + 1, random, boundingBox, direction, type);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
                return newPiece;
            }
        } else {
            class_3341 boundingBox = SmallTunnel.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
            if (boundingBox != null) {
                SmallTunnel newPiece = new SmallTunnel(chainLength + 1, random, boundingBox, direction, type);
                structurePieceAccessor.method_35462((class_3443)newPiece);
                ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
                return newPiece;
            }
        }
        return null;
    }

    public static MineshaftPiece generateAndAddSideRoomPiece(class_3443 structurePiece, class_6130 structurePieceAccessor, Random random, int x, int y, int z, class_2350 direction, int chainLength) {
        BetterMineshaftStructureFeature.Type type = ((MineshaftPiece)structurePiece).mineshaftType;
        class_3341 boundingBox = SideRoom.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
        if (boundingBox != null) {
            SideRoom newPiece = new SideRoom(chainLength + 1, random, boundingBox, direction, type);
            structurePieceAccessor.method_35462((class_3443)newPiece);
            ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
            return newPiece;
        }
        return null;
    }

    public static MineshaftPiece generateAndAddSideRoomDungeonPiece(class_3443 structurePiece, class_6130 structurePieceAccessor, Random random, int x, int y, int z, class_2350 direction, int chainLength) {
        BetterMineshaftStructureFeature.Type type = ((MineshaftPiece)structurePiece).mineshaftType;
        class_3341 boundingBox = SideRoomDungeon.determineBoxPosition(structurePieceAccessor, random, x, y, z, direction);
        if (boundingBox != null) {
            SideRoomDungeon newPiece = new SideRoomDungeon(chainLength + 1, random, boundingBox, direction, type);
            structurePieceAccessor.method_35462((class_3443)newPiece);
            ((MineshaftPiece)newPiece).method_14918(structurePiece, structurePieceAccessor, random);
            return newPiece;
        }
        return null;
    }
}

