/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructureFeature;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BlockSetSelectors;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2541;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3614;
import net.minecraft.class_3719;
import net.minecraft.class_3773;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6801;

public abstract class MineshaftPiece
extends class_3443 {
    public BetterMineshaftStructureFeature.Type mineshaftType;
    protected static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final Set<class_3614> NON_SOLID_MATERIALS = Set.of(class_3614.field_15959, class_3614.field_15920, class_3614.field_15922, class_3614.field_15947);

    public MineshaftPiece(class_3773 structurePieceType, int chainLength, BetterMineshaftStructureFeature.Type type, class_3341 boundingBox) {
        super(structurePieceType, chainLength, boundingBox);
        this.mineshaftType = type;
    }

    public MineshaftPiece(class_3773 structurePieceType, class_2487 compoundTag) {
        super(structurePieceType, compoundTag);
        this.mineshaftType = BetterMineshaftStructureFeature.Type.byId(compoundTag.method_10550("MST"));
    }

    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        compoundTag.method_10569("MST", this.mineshaftType.ordinal());
    }

    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, Random random) {
    }

    protected BlockSetSelector getMainSelector() {
        return BlockSetSelectors.MAIN_SELECTOR.get((Object)this.mineshaftType);
    }

    protected BlockSetSelector getFloorSelector() {
        return BlockSetSelectors.FLOOR_SELECTOR.get((Object)this.mineshaftType);
    }

    protected BlockSetSelector getBrickSelector() {
        return BlockSetSelectors.BRICK_SELECTOR.get((Object)this.mineshaftType);
    }

    protected BlockSetSelector getLegSelector() {
        return BlockSetSelectors.LEG_SELECTOR.get((Object)this.mineshaftType);
    }

    protected class_2680 getMainBlock() {
        return BlockSetSelectors.MAIN_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getSupportBlock() {
        return BlockSetSelectors.SUPPORT_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getMainSlab() {
        return BlockSetSelectors.SLAB_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getGravel() {
        return BlockSetSelectors.GRAVEL_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getMainDoorwayWall() {
        return BlockSetSelectors.STONE_WALL_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getMainDoorwaySlab() {
        return BlockSetSelectors.STONE_SLAB_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getSmallLegBlock() {
        return BlockSetSelectors.SMALL_LEG_BLOCK.get((Object)this.mineshaftType);
    }

    protected class_2680 getTrapdoor() {
        return switch (this.mineshaftType) {
            case BetterMineshaftStructureFeature.Type.MESA, BetterMineshaftStructureFeature.Type.RED_DESERT -> class_2246.field_10246.method_9564();
            case BetterMineshaftStructureFeature.Type.JUNGLE -> class_2246.field_10017.method_9564();
            case BetterMineshaftStructureFeature.Type.SNOW, BetterMineshaftStructureFeature.Type.ICE -> class_2246.field_10323.method_9564();
            case BetterMineshaftStructureFeature.Type.SAVANNA -> class_2246.field_10608.method_9564();
            default -> class_2246.field_10137.method_9564();
        };
    }

    protected float getVineChance() {
        return switch (this.mineshaftType) {
            case BetterMineshaftStructureFeature.Type.JUNGLE -> 0.5f;
            case BetterMineshaftStructureFeature.Type.SNOW -> 0.05f;
            case BetterMineshaftStructureFeature.Type.RED_DESERT, BetterMineshaftStructureFeature.Type.ICE, BetterMineshaftStructureFeature.Type.DESERT, BetterMineshaftStructureFeature.Type.LUSH -> 0.0f;
            default -> 0.1f;
        };
    }

    protected float getReplacementRate() {
        return this.mineshaftType == BetterMineshaftStructureFeature.Type.SNOW || this.mineshaftType == BetterMineshaftStructureFeature.Type.ICE || this.mineshaftType == BetterMineshaftStructureFeature.Type.MUSHROOM || this.mineshaftType == BetterMineshaftStructureFeature.Type.LUSH ? 0.95f : 0.6f;
    }

    protected boolean addBarrel(class_5281 world, class_3341 boundingBox, Random random, class_2338 pos, class_2960 lootTableId) {
        if (boundingBox.method_14662((class_2382)pos) && world.method_8320(pos).method_26204() != class_2246.field_16328) {
            world.method_8652(pos, (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036), 2);
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_3719) {
                ((class_3719)blockEntity).method_11285(lootTableId, random.nextLong());
            }
            return true;
        }
        return false;
    }

    protected boolean addBarrel(class_5281 world, class_3341 boundingBox, Random random, int x, int y, int z, class_2960 lootTableId) {
        return this.addBarrel(world, boundingBox, random, (class_2338)this.method_33781(x, y, z), lootTableId);
    }

    protected void addVines(class_5281 world, class_3341 boundingBox, class_2350 facing, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutable.method_10103(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z)).method_10098(facing);
                    class_2680 nextBlock = this.method_14929((class_1922)world, x + facing.method_10148(), y + facing.method_10164(), z + facing.method_10165(), boundingBox);
                    if (!this.method_14929((class_1922)world, x, y, z, boundingBox).method_26215() || !class_2248.method_9501((class_265)nextBlock.method_26220((class_1922)world, (class_2338)mutable), (class_2350)facing.method_10153()) || nextBlock.method_26204().method_9564() == class_2246.field_9983.method_9564() || !(random.nextFloat() < chance)) continue;
                    this.method_14917(world, (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)class_2541.method_10828((class_2350)(facing.method_10166() == class_2350.class_2351.field_11048 ? facing : facing.method_10153())), (Comparable)Boolean.valueOf(true)), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void addVines(class_5281 world, class_3341 boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        float chance = this.getVineChance();
        this.addVines(world, boundingBox, class_2350.field_11034, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11039, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11043, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11035, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void addBiomeDecorations(class_5281 world, class_3341 box, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338.class_2339 blockPos = this.method_33781(x, y, z);
                    class_2680 state = this.method_14929((class_1922)world, x, y, z, box);
                    class_2680 stateBelow = this.method_14929((class_1922)world, x, y - 1, z, box);
                    if (this.mineshaftType == BetterMineshaftStructureFeature.Type.SNOW && state.method_26215() && class_2246.field_10477.method_9558(AIR, (class_4538)world, (class_2338)blockPos)) {
                        this.method_14917(world, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2741.field_12536, (Comparable)Integer.valueOf(random.nextInt(2) + 1)), x, y, z, box);
                    }
                    if (this.mineshaftType == BetterMineshaftStructureFeature.Type.LUSH) {
                        if (box.method_14662((class_2382)blockPos) && random.nextFloat() < 0.005f) {
                            class_6801.field_35782.method_12862(world, world.method_8410().method_14178().method_12129(), random, (class_2338)blockPos);
                        }
                        if (box.method_14662((class_2382)blockPos) && random.nextFloat() < 0.005f) {
                            class_6801.field_35787.method_12862(world, world.method_8410().method_14178().method_12129(), random, (class_2338)blockPos);
                        }
                        if (box.method_14662((class_2382)blockPos) && random.nextFloat() < 0.005f) {
                            class_6801.field_35788.method_12862(world, world.method_8410().method_14178().method_12129(), random, (class_2338)blockPos);
                        }
                        if (stateBelow.method_27852(this.getMainBlock().method_26204()) && state.method_26215() && stateBelow.method_26206((class_1922)world, blockPos.method_10074(), class_2350.field_11036)) {
                            this.method_14917(world, class_2246.field_28680.method_9564(), x, y, z, box);
                        }
                    }
                    if ((this.mineshaftType == BetterMineshaftStructureFeature.Type.DESERT || this.mineshaftType == BetterMineshaftStructureFeature.Type.RED_DESERT) && random.nextFloat() < 0.1f && state.method_26215() && class_2246.field_10029.method_9558(AIR, (class_4538)world, (class_2338)blockPos)) {
                        this.method_14917(world, (class_2680)class_2246.field_10029.method_9564().method_11657((class_2769)class_2741.field_12498, (Comparable)Integer.valueOf(0)), x, y, z, box);
                        if (random.nextFloat() < 0.5f && this.method_14929((class_1922)world, x, y + 1, z, box).method_27852(class_2246.field_10124)) {
                            this.method_14917(world, (class_2680)class_2246.field_10029.method_9564().method_11657((class_2769)class_2741.field_12498, (Comparable)Integer.valueOf(0)), x, y + 1, z, box);
                        }
                    }
                    if ((this.mineshaftType == BetterMineshaftStructureFeature.Type.MESA || this.mineshaftType == BetterMineshaftStructureFeature.Type.DESERT || this.mineshaftType == BetterMineshaftStructureFeature.Type.RED_DESERT) && random.nextFloat() < 0.1f && state.method_26215() && (stateBelow.method_27852(class_2246.field_10102) || stateBelow.method_27852(class_2246.field_10534) || stateBelow.method_27852(class_2246.field_10415) || stateBelow.method_27852(class_2246.field_10611) || stateBelow.method_27852(class_2246.field_10184) || stateBelow.method_27852(class_2246.field_10143) || stateBelow.method_27852(class_2246.field_10123) || stateBelow.method_27852(class_2246.field_10566))) {
                        this.method_14917(world, class_2246.field_10428.method_9564(), x, y, z, box);
                    }
                    if (this.mineshaftType != BetterMineshaftStructureFeature.Type.MUSHROOM || !state.method_26215() || !class_2246.field_10559.method_9558(AIR, (class_4538)world, (class_2338)blockPos)) continue;
                    float r = random.nextFloat();
                    if (r < 0.2f) {
                        this.method_14917(world, class_2246.field_10559.method_9564(), x, y, z, box);
                        continue;
                    }
                    if (!(r < 0.4f)) continue;
                    this.method_14917(world, class_2246.field_10251.method_9564(), x, y, z, box);
                }
            }
        }
    }

    protected void generateLeg(class_5281 world, Random random, class_3341 box, int x, int z, BlockSetSelector selector) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, -1, z);
        class_2680 state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        while (this.method_14924(mutable.method_10264()) > world.method_31607() + 1 && this.method_33881(state)) {
            this.method_14917(world, selector.get(random), x, mutable.method_10264(), z, box);
            mutable.method_10098(class_2350.field_11033);
            state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        }
    }

    protected boolean generateLegOrChain(class_5281 world, Random random, class_3341 box, int x, int z, BlockSetSelector selector) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, -1, z);
        class_2680 state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        boolean lavaBelow = false;
        while (this.method_14924(mutable.method_10264()) > world.method_31607() + 1 && this.method_33881(state)) {
            if (state.method_27852(class_2246.field_10164)) {
                lavaBelow = true;
                break;
            }
            mutable.method_10098(class_2350.field_11033);
            state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        }
        if (lavaBelow) {
            mutable = this.method_33781(x, 0, z);
            if (!this.field_15315.method_14662((class_2382)mutable)) {
                return false;
            }
            int realChainY = this.method_14924(0);
            int length = 1;
            boolean canGenerateChain = true;
            while (canGenerateChain) {
                if (canGenerateChain) {
                    mutable.method_33098(realChainY + length);
                    class_2680 currBlock = world.method_8320((class_2338)mutable);
                    boolean currBlockCanBeReplaced = this.method_33881(currBlock);
                    if (!currBlockCanBeReplaced && this.canHangChainBelow((class_4538)world, (class_2338)mutable, currBlock)) {
                        world.method_8652((class_2338)mutable.method_33098(realChainY + 1), this.getSupportBlock(), 2);
                        MineshaftPiece.fillColumnBetween(world, class_2246.field_23985.method_9564(), mutable, realChainY + 2, realChainY + length);
                        return false;
                    }
                    canGenerateChain = length <= 50 && currBlockCanBeReplaced && mutable.method_10264() < world.method_31600() - 1;
                }
                ++length;
            }
        } else {
            this.generateLeg(world, random, box, x, z, selector);
            return true;
        }
        return false;
    }

    protected void generatePillarDownOrChainUp(class_5281 world, Random random, class_3341 boundingBox, int x, int z, int pillarStartY, int chainStartY, class_2680 chainBlock) {
        class_2338.class_2339 mutable = this.method_33781(x, pillarStartY, z);
        if (!boundingBox.method_14662((class_2382)mutable)) {
            return;
        }
        int realPillarY = this.method_14924(pillarStartY);
        int realChainY = this.method_14924(chainStartY);
        int length = 1;
        boolean canGenerateLeg = true;
        boolean canGenerateChain = true;
        while (canGenerateLeg || canGenerateChain) {
            boolean currBlockCanBeReplaced;
            class_2680 currBlock;
            if (canGenerateLeg) {
                mutable.method_33098(realPillarY - length);
                currBlock = world.method_8320((class_2338)mutable);
                boolean bl = currBlockCanBeReplaced = this.method_33881(currBlock) && !currBlock.method_27852(class_2246.field_10164);
                if (!currBlockCanBeReplaced && this.canPlaceColumnOnTopOf(currBlock)) {
                    MineshaftPiece.fillColumnBetween(world, this.getSmallLegBlock(), mutable, realPillarY - length + 1, realPillarY);
                    return;
                }
                boolean bl2 = canGenerateLeg = length <= 20 && currBlockCanBeReplaced && mutable.method_10264() > world.method_31607() + 1;
            }
            if (canGenerateChain) {
                mutable.method_33098(realChainY + length);
                currBlock = world.method_8320((class_2338)mutable);
                currBlockCanBeReplaced = this.method_33881(currBlock);
                if (!currBlockCanBeReplaced && this.canHangChainBelow((class_4538)world, (class_2338)mutable, currBlock)) {
                    world.method_8652((class_2338)mutable.method_33098(realChainY + 1), chainBlock, 2);
                    MineshaftPiece.fillColumnBetween(world, class_2246.field_23985.method_9564(), mutable, realChainY + 2, realChainY + length);
                    return;
                }
                canGenerateChain = length <= 50 && currBlockCanBeReplaced && mutable.method_10264() < world.method_31600() - 1;
            }
            ++length;
        }
    }

    protected void generatePillarDownOrChainUp(class_5281 world, Random random, class_3341 boundingBox, int x, int y, int z) {
        this.generatePillarDownOrChainUp(world, random, boundingBox, x, z, y, y, this.getSupportBlock());
    }

    private boolean canPlaceColumnOnTopOf(class_2680 blockState) {
        return !blockState.method_27852(class_2246.field_10167) && !blockState.method_27852(class_2246.field_10164);
    }

    private boolean canHangChainBelow(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        return class_2248.method_20044((class_4538)levelReader, (class_2338)blockPos, (class_2350)class_2350.field_11033) && !(blockState.method_26204() instanceof class_2346);
    }

    protected boolean method_33881(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_26207().method_15797() || blockState.method_27852(class_2246.field_28411) || blockState.method_27852(class_2246.field_10376) || blockState.method_27852(class_2246.field_10238) || blockState.method_27852(class_2246.field_28048) || blockState.method_27852(class_2246.field_28675) || blockState.method_27852(class_2246.field_28676) || blockState.method_27852(class_2246.field_28680) || blockState.method_27852(class_2246.field_10477);
    }

    protected void fill(class_5281 world, class_3341 boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.method_14929((class_1922)world, x, y, z, boundingBox) == class_2246.field_23985.method_9564()) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void fill(class_5281 world, class_3341 boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.method_14929((class_1922)world, x, y, z, boundingBox) == class_2246.field_23985.method_9564()) continue;
                    this.method_14917(world, selector.get(random), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void replaceAirOrChains(class_5281 world, class_3341 boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox);
                    if (currState == null || !currState.method_26215() && currState != class_2246.field_23985.method_9564()) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void replaceAirOrChains(class_5281 world, class_3341 boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox);
                    if (currState == null || !currState.method_26215() && currState != class_2246.field_23985.method_9564()) continue;
                    this.method_14917(world, selector.get(random), x, y, z, boundingBox);
                }
            }
        }
    }

    protected static void fillColumnBetween(class_5281 worldGenLevel, class_2680 blockState, class_2338.class_2339 mutableBlockPos, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            worldGenLevel.method_8652((class_2338)mutableBlockPos.method_33098(y), blockState, 2);
        }
    }

    protected static void fillColumnBetween(class_5281 worldGenLevel, Random random, BlockSetSelector selector, class_2338.class_2339 mutableBlockPos, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            worldGenLevel.method_8652((class_2338)mutableBlockPos.method_33098(y), selector.get(random), 2);
        }
    }

    protected void chanceFill(class_5281 world, class_3341 boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceFill(class_5281 world, class_3341 boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.method_14917(world, selector.get(random), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(class_5281 world, class_3341 boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox)) == null || !currState.method_26215()) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(class_5281 world, class_3341 boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox);
                    if (currState == null || currState == class_2246.field_23985.method_9564() || currState.method_26207() != class_3614.field_15920 && currState.method_26207() != class_3614.field_15922 && (!(random.nextFloat() < chance) || currState.method_26215())) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(class_5281 world, class_3341 boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox);
                    if (currState == null || currState == class_2246.field_23985.method_9564() || currState.method_26207() != class_3614.field_15920 && currState.method_26207() != class_3614.field_15922 && (!(random.nextFloat() < chance) || currState.method_26215())) continue;
                    class_2680 blockState = selector.get(random);
                    if (currState.method_26207() == class_3614.field_15920 || currState.method_26207() == class_3614.field_15922) {
                        for (int numAttempts = 0; (blockState == class_2246.field_10124.method_9564() || blockState == class_2246.field_10543.method_9564()) && numAttempts < 10; ++numAttempts) {
                            blockState = selector.get(random);
                        }
                    }
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceSolid(class_5281 world, class_3341 boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox)) == null || currState == class_2246.field_23985.method_9564() || NON_SOLID_MATERIALS.contains(currState.method_26207())) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceAddBlock(class_5281 world, Random random, float chance, class_2680 block, int x, int y, int z, class_3341 boundingBox) {
        if (random.nextFloat() < chance) {
            this.method_14917(world, block, x, y, z, boundingBox);
        }
    }

    protected class_2680 getBlockAtFixed(class_1922 blockGetter, int x, int y, int z, class_3341 boundingBox) {
        class_2338.class_2339 blockPos = this.method_33781(x, y, z);
        return !boundingBox.method_14662((class_2382)blockPos) ? null : blockGetter.method_8320((class_2338)blockPos);
    }
}

