/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructureFeature;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.SurfaceHelper;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6130;
import net.minecraft.class_6625;

public class VerticalEntrance
extends MineshaftPiece {
    private final class_2338 centerPos;
    private int yAxisLen = 0;
    private int localYEnd = 0;
    private int tunnelLength = 0;
    private int tunnelFloorAltitude = 0;
    private class_2350 tunnelDirection = class_2350.field_11043;
    private boolean hasTunnel = false;
    private static final int SHAFT_LOCAL_XZ_START = 22;
    private static final int SHAFT_LOCAL_XZ_END = 26;

    public VerticalEntrance(class_2487 compoundTag) {
        super(BetterMineshaftStructurePieceType.VERTICAL_ENTRANCE, compoundTag);
        int centerPosX = compoundTag.method_10561("centerPos")[0];
        int centerPosY = compoundTag.method_10561("centerPos")[1];
        int centerPosZ = compoundTag.method_10561("centerPos")[2];
        this.centerPos = new class_2338(centerPosX, centerPosY, centerPosZ);
        this.yAxisLen = compoundTag.method_10550("yAxisLen");
        this.localYEnd = this.yAxisLen - 1;
        this.tunnelLength = compoundTag.method_10550("tunnelLen");
        this.tunnelFloorAltitude = compoundTag.method_10550("floorAltitude");
        int tunnelDirInt = compoundTag.method_10550("tunnelDir");
        this.tunnelDirection = tunnelDirInt == -1 ? null : class_2350.method_10139((int)tunnelDirInt);
        this.hasTunnel = compoundTag.method_10577("hasTunnel");
    }

    public VerticalEntrance(int pieceChainLen, Random random, class_2338.class_2339 centerPos, class_2350 direction, BetterMineshaftStructureFeature.Type type) {
        super(BetterMineshaftStructurePieceType.VERTICAL_ENTRANCE, pieceChainLen, type, VerticalEntrance.getInitialBoundingBox((class_2338)centerPos));
        this.method_14926(direction);
        this.centerPos = centerPos;
    }

    @Override
    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        super.method_14943(structurePieceSerializationContext, compoundTag);
        compoundTag.method_10539("centerPos", new int[]{this.centerPos.method_10263(), this.centerPos.method_10264(), this.centerPos.method_10260()});
        compoundTag.method_10569("yAxisLen", this.yAxisLen);
        compoundTag.method_10569("tunnelLen", this.tunnelLength);
        compoundTag.method_10569("floorAltitude", this.tunnelFloorAltitude);
        compoundTag.method_10569("tunnelDir", this.tunnelDirection.method_10161());
        compoundTag.method_10556("hasTunnel", this.hasTunnel);
    }

    private static class_3341 getInitialBoundingBox(class_2338 centerPos) {
        return new class_3341(centerPos.method_10263() - 24, centerPos.method_10264(), centerPos.method_10260() - 24, centerPos.method_10263() + 24, 256, centerPos.method_10260() + 24);
    }

    @Override
    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, Random random) {
        class_2350 direction = this.method_14934();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, random, this.centerPos.method_10263() - 4, this.centerPos.method_10264(), this.centerPos.method_10260() - 3, direction, this.field_15316);
                break;
            }
            case field_11035: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, random, this.centerPos.method_10263() + 4, this.centerPos.method_10264(), this.centerPos.method_10260() + 3, direction, this.field_15316);
                break;
            }
            case field_11039: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, random, this.centerPos.method_10263() - 3, this.centerPos.method_10264(), this.centerPos.method_10260() + 4, direction, this.field_15316);
                break;
            }
            case field_11034: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, random, this.centerPos.method_10263() + 3, this.centerPos.method_10264(), this.centerPos.method_10260() - 4, direction, this.field_15316);
            }
        }
    }

    public void method_14931(class_5281 world, class_5138 structureFeatureManager, class_2794 chunkGenerator, Random random, class_3341 boundingBox, class_1923 chunkPos, class_2338 blockPos) {
        if (!this.hasTunnel) {
            this.determineDirection(world);
        }
        if (this.hasTunnel) {
            this.generateVerticalShaft(world, random, boundingBox);
            this.generateSurfaceTunnel(world, random, boundingBox);
        }
    }

    private void generateVerticalShaft(class_5281 world, Random random, class_3341 box) {
        this.chanceReplaceNonAir(world, box, random, this.getReplacementRate(), 22, 0, 22, 26, this.localYEnd, 26, this.getMainSelector());
        this.replaceAirOrChains(world, box, 22, 0, 22, 26, this.localYEnd, 26, this.getMainBlock());
        this.fill(world, box, 23, 1, 23, 25, this.localYEnd - 1, 25, AIR);
        this.replaceAirOrChains(world, box, 23, 0, 23, 25, 0, 25, this.getMainBlock());
        if (this.mineshaftType == BetterMineshaftStructureFeature.Type.MUSHROOM) {
            this.chanceReplaceNonAir(world, box, random, 0.8f, 23, 0, 23, 25, 0, 25, class_2246.field_10402.method_9564());
        }
        this.replaceAirOrChains(world, box, 24, 1, 22, 24, this.localYEnd - 4, 22, this.getMainBlock());
        this.fill(world, box, 24, 1, 23, 24, this.localYEnd - 4, 23, class_2246.field_9983.method_9564());
        this.fill(world, box, 23, 1, 26, 25, 2, 26, this.getMainDoorwayWall());
        this.fill(world, box, 24, 3, 26, 24, 3, 26, this.getMainDoorwaySlab());
        this.fill(world, box, 24, 1, 26, 24, 2, 26, AIR);
        this.addBiomeDecorations(world, box, random, 23, 0, 23, 25, 1, 25);
        this.addVines(world, box, random, 23, 0, 23, 25, this.localYEnd - 4, 25);
        this.generateLeg(world, random, box, 22, 22, this.getLegSelector());
        this.generateLeg(world, random, box, 22, 26, this.getLegSelector());
        this.generateLeg(world, random, box, 26, 22, this.getLegSelector());
        this.generateLeg(world, random, box, 26, 26, this.getLegSelector());
    }

    private void generateSurfaceTunnel(class_5281 world, Random random, class_3341 box) {
        int x;
        int z;
        boolean[] validPositions;
        int tunnelStartX = 0;
        int tunnelStartZ = 0;
        int tunnelEndX = 0;
        int tunnelEndZ = 0;
        class_2350 facing = this.method_14934();
        float rotationDifference = facing.method_10144() - this.tunnelDirection.method_10144();
        class_2350 relativeTunnelDir = class_2350.method_10150((double)(class_2350.field_11043.method_10144() - rotationDifference));
        if (relativeTunnelDir == class_2350.field_11043) {
            tunnelStartX = 22;
            tunnelStartZ = 26;
            tunnelEndX = 26;
            tunnelEndZ = 26 + this.tunnelLength;
        } else if (relativeTunnelDir == class_2350.field_11039 && facing != class_2350.field_11035 && facing != class_2350.field_11039 || relativeTunnelDir == class_2350.field_11034 && (facing == class_2350.field_11035 || facing == class_2350.field_11039)) {
            tunnelStartX = 22 - this.tunnelLength;
            tunnelStartZ = 22;
            tunnelEndX = 22;
            tunnelEndZ = 26;
        } else if (relativeTunnelDir == class_2350.field_11035) {
            tunnelStartX = 22;
            tunnelStartZ = 22 - this.tunnelLength;
            tunnelEndX = 26;
            tunnelEndZ = 22;
        } else if (relativeTunnelDir == class_2350.field_11034 || relativeTunnelDir == class_2350.field_11039) {
            tunnelStartX = 26;
            tunnelStartZ = 22;
            tunnelEndX = 26 + this.tunnelLength;
            tunnelEndZ = 26;
        }
        this.chanceReplaceNonAir(world, box, random, 0.6f, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX, this.tunnelFloorAltitude + 4, tunnelEndZ, this.getMainSelector());
        if (facing.method_10166() == this.tunnelDirection.method_10166()) {
            this.replaceAirOrChains(world, box, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude, tunnelEndZ, this.getMainBlock());
            if (this.mineshaftType == BetterMineshaftStructureFeature.Type.MUSHROOM) {
                this.chanceReplaceNonAir(world, box, random, 0.8f, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude, tunnelEndZ, class_2246.field_10402.method_9564());
            }
            this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 1, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude + 3, tunnelEndZ, AIR);
        } else {
            this.replaceAirOrChains(world, box, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude, tunnelEndZ - 1, this.getMainBlock());
            if (this.mineshaftType == BetterMineshaftStructureFeature.Type.MUSHROOM) {
                this.chanceReplaceNonAir(world, box, random, 0.8f, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude, tunnelEndZ - 1, class_2246.field_10402.method_9564());
            }
            this.fill(world, box, tunnelStartX, this.tunnelFloorAltitude + 1, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude + 3, tunnelEndZ - 1, AIR);
        }
        this.addVines(world, box, random, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX - 1, this.tunnelFloorAltitude + 4, tunnelEndZ - 1);
        if (facing.method_10166() == this.tunnelDirection.method_10166()) {
            validPositions = new boolean[tunnelEndZ - tunnelStartZ + 1];
            for (z = 0; z < validPositions.length; ++z) {
                floorBlock = this.method_14929((class_1922)world, tunnelStartX + 2, this.tunnelFloorAltitude, tunnelStartZ + z, box);
                if (!floorBlock.method_26207().method_15799()) continue;
                validPositions[z] = true;
            }
        } else {
            validPositions = new boolean[tunnelEndX - tunnelStartX + 1];
            for (x = 0; x < validPositions.length; ++x) {
                floorBlock = this.method_14929((class_1922)world, tunnelStartX + x, this.tunnelFloorAltitude, tunnelStartZ + 2, box);
                if (!floorBlock.method_26207().method_15799()) continue;
                validPositions[x] = true;
            }
        }
        if (facing.method_10166() == this.tunnelDirection.method_10166()) {
            for (z = tunnelStartZ; z <= tunnelEndZ; ++z) {
                int r = random.nextInt(4);
                if (r != 0 || !validPositions[z - tunnelStartZ]) continue;
                this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 1, z, tunnelStartX + 1, this.tunnelFloorAltitude + 2, z, this.getSupportBlock());
                this.fill(world, box, tunnelStartX + 3, this.tunnelFloorAltitude + 1, z, tunnelStartX + 3, this.tunnelFloorAltitude + 2, z, this.getSupportBlock());
                this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z, this.getMainBlock());
                this.chanceReplaceNonAir(world, box, random, 0.25f, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z, this.getSupportBlock());
                this.chanceReplaceAir(world, box, random, 0.15f, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z - 1, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z + 1, class_2246.field_10343.method_9564());
                this.chanceReplaceAir(world, box, random, 0.15f, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z - 1, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z + 1, class_2246.field_10343.method_9564());
                z += 3;
            }
        } else {
            for (x = tunnelStartX; x <= tunnelEndX; ++x) {
                int r = random.nextInt(4);
                if (r != 0 || !validPositions[x - tunnelStartX]) continue;
                this.fill(world, box, x, this.tunnelFloorAltitude + 1, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 2, tunnelStartZ + 1, this.getSupportBlock());
                this.fill(world, box, x, this.tunnelFloorAltitude + 1, tunnelStartZ + 3, x, this.tunnelFloorAltitude + 2, tunnelStartZ + 3, this.getSupportBlock());
                this.fill(world, box, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, this.getMainBlock());
                this.chanceReplaceNonAir(world, box, random, 0.25f, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, this.getSupportBlock());
                this.chanceReplaceAir(world, box, random, 0.15f, x - 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x + 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, class_2246.field_10343.method_9564());
                this.chanceReplaceAir(world, box, random, 0.15f, x - 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, x + 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, class_2246.field_10343.method_9564());
                x += 3;
            }
        }
    }

    private void determineDirection(class_5281 world) {
        int minSurfaceHeight = 255;
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                try {
                    int realX = this.centerPos.method_10263() + xOffset;
                    int realZ = this.centerPos.method_10260() + zOffset;
                    int chunkX = realX >> 4;
                    int chunkZ = realZ >> 4;
                    int surfaceHeight = SurfaceHelper.getSurfaceHeight((class_2791)world.method_8392(chunkX, chunkZ), (class_2265)new class_2265(realX, realZ));
                    if (surfaceHeight <= 1) continue;
                    minSurfaceHeight = Math.min(minSurfaceHeight, surfaceHeight);
                    continue;
                }
                catch (NullPointerException e) {
                    BetterMineshafts.LOGGER.error("Unexpected YUNG's Better Mineshafts error. Please report this!");
                    BetterMineshafts.LOGGER.error(e.toString());
                    BetterMineshafts.LOGGER.error(e.getMessage());
                }
            }
        }
        if (minSurfaceHeight < 60 || minSurfaceHeight == 255) {
            return;
        }
        int ceilingHeight = minSurfaceHeight - 2;
        int floorHeight = ceilingHeight - 4;
        this.yAxisLen = ceilingHeight - this.centerPos.method_10264() + 1;
        this.localYEnd = this.yAxisLen - 1;
        class_2338.class_2339 mutable = this.centerPos.method_25503();
        int radius = 8;
        int maxRadialDist = 3;
        for (int radialDist = 0; radialDist < maxRadialDist; ++radialDist) {
            for (class_2350 direction : class_2350.values()) {
                if (direction == class_2350.field_11036 || direction == class_2350.field_11033) continue;
                mutable.method_10101((class_2382)this.centerPos.method_10079(direction, radius * radialDist + 2));
                for (int i = radialDist * radius; i < radialDist * radius + radius; ++i) {
                    int surfaceHeight = SurfaceHelper.getSurfaceHeight((class_2791)world.method_22350((class_2338)mutable), (class_2265)new class_2265(mutable.method_10263(), mutable.method_10260()));
                    if (surfaceHeight <= floorHeight && surfaceHeight > 1) {
                        this.hasTunnel = true;
                        this.tunnelDirection = direction;
                        this.tunnelFloorAltitude = ceilingHeight - 4 - this.field_15315.method_35416();
                        this.tunnelLength = i;
                        return;
                    }
                    mutable.method_10098(direction);
                }
            }
        }
    }
}

