/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.render.CustomizableCube;
import dev.tr7zw.skinlayers.render.CustomizableCubeListBuilder;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.class_1011;
import net.minecraft.class_2350;
import net.minecraft.class_630;

public class SolidPixelWrapper {
    private static final float pixelSize = 1.0f;

    public static CustomizableModelPart wrapBox(class_1011 natImage, int width, int height, int depth, int textureU, int textureV, boolean topPivot, float rotationOffset) {
        CustomizableCubeListBuilder cubes = CustomizableCubeListBuilder.create();
        float staticXOffset = (float)(-width) / 2.0f;
        float staticYOffset = topPivot ? rotationOffset : (float)(-height) + rotationOffset;
        float staticZOffset = (float)(-depth) / 2.0f;
        Position staticOffset = new Position(staticXOffset, staticYOffset, staticZOffset);
        Dimensions dimensions = new Dimensions(width, height, depth);
        UV textureUV = new UV(textureU, textureV);
        try {
            for (class_2350 face : class_2350.values()) {
                UV sizeUV = SolidPixelWrapper.getSizeUV(dimensions, face);
                for (int u = 0; u < sizeUV.u; ++u) {
                    for (int v = 0; v < sizeUV.v; ++v) {
                        SolidPixelWrapper.addPixel(natImage, cubes, staticOffset, face, dimensions, new UV(u, v), textureUV, sizeUV);
                    }
                }
            }
        }
        catch (Exception ex) {
            SkinLayersModBase.LOGGER.error("Error while creating 3d skin model. Please report on the Github/Discord.", (Throwable)ex);
            return new CustomizableModelPart(new ArrayList<class_630.class_628>(), new ArrayList<CustomizableCube>(), new HashMap<String, class_630>());
        }
        if (SkinLayersModBase.config.fastRender && !cubes.getCubes().isEmpty()) {
            cubes.uv(textureU, textureV).addVanillaBox(staticXOffset, staticYOffset, staticZOffset, width, height, depth, 1.0f);
        }
        return new CustomizableModelPart(cubes.getVanillaCubes(), cubes.getCubes(), new HashMap<String, class_630>());
    }

    private static UV getSizeUV(Dimensions dimensions, class_2350 face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> new UV(dimensions.width, dimensions.depth);
            case class_2350.field_11043, class_2350.field_11035 -> new UV(dimensions.width, dimensions.height);
            case class_2350.field_11039, class_2350.field_11034 -> new UV(dimensions.depth, dimensions.height);
        };
    }

    private static UV getOnTextureUV(UV textureUV, UV onFaceUV, Dimensions dimensions, class_2350 face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> new UV(textureUV.u + dimensions.depth + onFaceUV.u, textureUV.v + onFaceUV.v);
            case class_2350.field_11036 -> new UV(textureUV.u + dimensions.width + dimensions.depth + onFaceUV.u, textureUV.v + onFaceUV.v);
            case class_2350.field_11043 -> new UV(textureUV.u + dimensions.depth + onFaceUV.u, textureUV.v + dimensions.depth + onFaceUV.v);
            case class_2350.field_11035 -> new UV(textureUV.u + dimensions.depth + dimensions.width + dimensions.depth + onFaceUV.u, textureUV.v + dimensions.depth + onFaceUV.v);
            case class_2350.field_11039 -> new UV(textureUV.u + onFaceUV.u, textureUV.v + dimensions.depth + onFaceUV.v);
            case class_2350.field_11034 -> new UV(textureUV.u + dimensions.depth + dimensions.width + onFaceUV.u, textureUV.v + dimensions.depth + onFaceUV.v);
        };
    }

    private static VoxelPosition UVtoXYZ(UV onFaceUV, Dimensions dimensions, class_2350 face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> new VoxelPosition(onFaceUV.u, 0, dimensions.depth - 1 - onFaceUV.v);
            case class_2350.field_11036 -> new VoxelPosition(onFaceUV.u, dimensions.height - 1, dimensions.depth - 1 - onFaceUV.v);
            case class_2350.field_11043 -> new VoxelPosition(onFaceUV.u + 0, onFaceUV.v, 0);
            case class_2350.field_11035 -> new VoxelPosition(dimensions.width - 1 - onFaceUV.u, onFaceUV.v, dimensions.depth - 1);
            case class_2350.field_11039 -> new VoxelPosition(0, onFaceUV.v, dimensions.depth - 1 - onFaceUV.u);
            case class_2350.field_11034 -> new VoxelPosition(dimensions.width - 1, onFaceUV.v, onFaceUV.u + 0);
        };
    }

    private static UV XYZtoUV(VoxelPosition voxelPosition, Dimensions dimensions, class_2350 face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> new UV(voxelPosition.x, dimensions.depth - 1 - voxelPosition.z);
            case class_2350.field_11043 -> new UV(voxelPosition.x + 0, voxelPosition.y);
            case class_2350.field_11035 -> new UV(dimensions.width - 1 - voxelPosition.x, voxelPosition.y);
            case class_2350.field_11039 -> new UV(dimensions.depth - 1 - voxelPosition.z, voxelPosition.y);
            case class_2350.field_11034 -> new UV(voxelPosition.z + 0, voxelPosition.y);
        };
    }

    private static void addPixel(class_1011 natImage, CustomizableCubeListBuilder cubes, Position staticOffset, class_2350 face, Dimensions dimensions, UV onFaceUV, UV textureUV, UV sizeUV) {
        UV onTextureUV = SolidPixelWrapper.getOnTextureUV(textureUV, onFaceUV, dimensions, face);
        if (!SolidPixelWrapper.isPresent(natImage, onTextureUV)) {
            return;
        }
        VoxelPosition voxelPosition = SolidPixelWrapper.UVtoXYZ(onFaceUV, dimensions, face);
        Position position = new Position(staticOffset.x + (float)voxelPosition.x, staticOffset.y + (float)voxelPosition.y, staticOffset.z + (float)voxelPosition.z);
        boolean solidPixel = SolidPixelWrapper.isSolid(natImage, onTextureUV);
        HashSet<class_2350> hide = new HashSet<class_2350>();
        HashSet<class_2350[]> corners = new HashSet<class_2350[]>();
        boolean isOnBorder = false;
        boolean backsideOverlaps = false;
        for (class_2350 neighbourFace : class_2350.values()) {
            if (neighbourFace.method_10166() == face.method_10166()) continue;
            VoxelPosition neighbourVoxelPosition = new VoxelPosition(voxelPosition.x + neighbourFace.method_10148(), voxelPosition.y + neighbourFace.method_10164(), voxelPosition.z + neighbourFace.method_10165());
            UV neighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(neighbourVoxelPosition, dimensions, face);
            if (SolidPixelWrapper.isOnFace(neighbourOnFaceUV, sizeUV)) {
                if (SolidPixelWrapper.isPresent(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, neighbourOnFaceUV, dimensions, face))) {
                    if (solidPixel && !SolidPixelWrapper.isSolid(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, neighbourOnFaceUV, dimensions, face))) continue;
                    hide.add(neighbourFace);
                    continue;
                }
                VoxelPosition farNeighbourVoxelPosition = new VoxelPosition(neighbourVoxelPosition.x + neighbourFace.method_10148(), neighbourVoxelPosition.y + neighbourFace.method_10164(), neighbourVoxelPosition.z + neighbourFace.method_10165());
                UV farNeighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(farNeighbourVoxelPosition, dimensions, face);
                if (SolidPixelWrapper.isOnFace(farNeighbourOnFaceUV, sizeUV) || !SolidPixelWrapper.isPresent(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, farNeighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(farNeighbourVoxelPosition, dimensions, neighbourFace), dimensions, neighbourFace)) || solidPixel && !SolidPixelWrapper.isSolid(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, farNeighbourOnFaceUV, dimensions, neighbourFace))) continue;
                hide.add(neighbourFace);
                continue;
            }
            isOnBorder = true;
            neighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(voxelPosition, dimensions, neighbourFace);
            if (SolidPixelWrapper.isPresent(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, neighbourOnFaceUV, dimensions, neighbourFace))) {
                backsideOverlaps = true;
                hide.add(neighbourFace);
                corners.add(new class_2350[]{face.method_10153(), neighbourFace});
                continue;
            }
            UV downNeighbourOnFaceUV = SolidPixelWrapper.XYZtoUV(new VoxelPosition(voxelPosition.x - face.method_10148(), voxelPosition.y - face.method_10164(), voxelPosition.z - face.method_10165()), dimensions, neighbourFace);
            if (!SolidPixelWrapper.isPresent(natImage, SolidPixelWrapper.getOnTextureUV(textureUV, downNeighbourOnFaceUV, dimensions, neighbourFace))) continue;
            backsideOverlaps = true;
        }
        if (!isOnBorder || backsideOverlaps) {
            hide.add(face.method_10153());
        }
        if (SkinLayersModBase.config.fastRender) {
            hide.add(face);
        }
        cubes.uv(onTextureUV.u, onTextureUV.v).addBox(position.x, position.y, position.z, 1.0f, (class_2350[])hide.toArray(class_2350[]::new), (class_2350[][])corners.toArray(x$0 -> new class_2350[x$0][]));
    }

    private static boolean isPresent(class_1011 natImage, UV onTextureUV) {
        return natImage.method_4311(onTextureUV.u, onTextureUV.v) != 0;
    }

    private static boolean isSolid(class_1011 natImage, UV onTextureUV) {
        return natImage.method_4311(onTextureUV.u, onTextureUV.v) == -1;
    }

    private static boolean isOnFace(UV onFaceUV, UV sizeUV) {
        return onFaceUV.u >= 0 && onFaceUV.u < sizeUV.u && onFaceUV.v >= 0 && onFaceUV.v < sizeUV.v;
    }

    public record Position(float x, float y, float z) {
    }

    public record Dimensions(int width, int height, int depth) {
    }

    public record UV(int u, int v) {
    }

    public record VoxelPosition(int x, int y, int z) {
    }
}

