/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResultImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
@ApiStatus.Experimental
public interface FilteringResult {
    public static FilteringResult create() {
        return FilteringResult.create(Lists.newArrayList(), Lists.newArrayList());
    }

    public static FilteringResult create(List<? extends EntryStack<?>> hiddenStacks, List<? extends EntryStack<?>> shownStacks) {
        return new FilteringResultImpl(hiddenStacks, shownStacks);
    }

    public Set<HashedEntryStackWrapper> getHiddenStacks();

    public Set<HashedEntryStackWrapper> getShownStacks();

    default public FilteringResult hide(EntryStack<?> stack) {
        this.getHiddenStacks().add(new HashedEntryStackWrapper(stack));
        return this;
    }

    default public FilteringResult hide(Collection<? extends EntryStack<?>> stacks) {
        this.getHiddenStacks().addAll(CollectionUtils.map(stacks, HashedEntryStackWrapper::new));
        return this;
    }

    default public FilteringResult show(EntryStack<?> stack) {
        this.getShownStacks().add(new HashedEntryStackWrapper(stack));
        return this;
    }

    default public FilteringResult show(Collection<? extends EntryStack<?>> stacks) {
        this.getShownStacks().addAll(CollectionUtils.map(stacks, HashedEntryStackWrapper::new));
        return this;
    }

    default public FilteringResult hideW(HashedEntryStackWrapper stack) {
        this.getHiddenStacks().add(stack);
        return this;
    }

    default public FilteringResult hideW(Collection<HashedEntryStackWrapper> stacks) {
        this.getHiddenStacks().addAll(stacks);
        return this;
    }

    default public FilteringResult showW(HashedEntryStackWrapper stack) {
        this.getShownStacks().add(stack);
        return this;
    }

    default public FilteringResult showW(Collection<HashedEntryStackWrapper> stacks) {
        this.getShownStacks().addAll(stacks);
        return this;
    }
}

