/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.FilteringRuleOptionsScreen;
import me.shedaniel.rei.impl.client.entry.filtering.AbstractFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringCache;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_6379;

@Environment(value=EnvType.CLIENT)
public class SearchFilteringRule
extends AbstractFilteringRule<SearchFilteringRule> {
    private String filterStr;
    private Supplier<SearchFilter> filter;
    private boolean show;

    public SearchFilteringRule() {
    }

    public SearchFilteringRule(String filter, boolean show) {
        this.setFilter(filter);
        this.show = show;
    }

    public void setFilter(String filter) {
        this.filterStr = filter;
        this.filter = Suppliers.memoize(() -> class_3544.method_15438((String)filter) ? SearchFilter.matchAll() : SearchProvider.getInstance().createFilter(filter));
    }

    @Override
    public class_2487 save(class_2487 tag) {
        tag.method_10582("filter", this.filterStr);
        tag.method_10556("show", this.show);
        return tag;
    }

    @Override
    public SearchFilteringRule createFromTag(class_2487 tag) {
        String filter = tag.method_10558("filter");
        boolean show = tag.method_10577("show");
        return new SearchFilteringRule(filter, show);
    }

    @Override
    public FilteringResult processFilteredStacks(FilteringContext context, FilteringCache cache, boolean async) {
        ArrayList completableFutures = Lists.newArrayList();
        this.processList(context.getUnsetStacks(), completableFutures);
        if (this.show) {
            this.processList(context.getHiddenStacks(), completableFutures);
        } else {
            this.processList(context.getShownStacks(), completableFutures);
        }
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        FilteringResult result = FilteringResult.create();
        for (CompletableFuture future : completableFutures) {
            List now = future.getNow(null);
            if (now == null) continue;
            if (this.show) {
                result.show(now);
                continue;
            }
            result.hide(now);
        }
        return result;
    }

    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule("", false);
    }

    private void processList(Collection<EntryStack<?>> stacks, List<CompletableFuture<List<EntryStack<?>>>> completableFutures) {
        for (Iterable iterable : CollectionUtils.partition((List)stacks, 100)) {
            completableFutures.add(CompletableFuture.supplyAsync(() -> {
                ArrayList output = Lists.newArrayList();
                for (EntryStack stack : partitionStacks) {
                    if (stack == null || !this.filter.get().test(stack)) continue;
                    output.add(stack);
                }
                return output;
            }));
        }
    }

    @Override
    public class_2561 getTitle() {
        return new class_2588("rule.roughlyenoughitems.filtering.search");
    }

    @Override
    public class_2561 getSubtitle() {
        return new class_2588("rule.roughlyenoughitems.filtering.search.subtitle");
    }

    @Override
    public Optional<BiFunction<FilteringEntry, class_437, class_437>> createEntryScreen() {
        return Optional.of((entry, screen) -> new FilteringRuleOptionsScreen<SearchFilteringRule>(entry, this, screen){
            FilteringRuleOptionsScreen.TextFieldRuleEntry entry;
            FilteringRuleOptionsScreen.BooleanRuleEntry show;
            List<EntryWidget> entryStacks;
            {
                this.entry = null;
                this.show = null;
                this.entryStacks = new ArrayList<EntryWidget>();
            }

            @Override
            public void addEntries(Consumer<FilteringRuleOptionsScreen.RuleEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)new class_2588("rule.roughlyenoughitems.filtering.search.filter").method_27692(class_124.field_1080));
                this.entry = new FilteringRuleOptionsScreen.TextFieldRuleEntry(this.field_22789 - 36, this.rule, widget -> {
                    widget.method_1880(9999);
                    widget.method_1863(searchTerm -> {
                        SearchFilter filter = SearchProvider.getInstance().createFilter((String)searchTerm);
                        this.entryStacks = ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(filter).map(EntryStack::normalize).map(stack -> new EntryWidget(new Rectangle(0, 0, 18, 18)).noBackground().entry((EntryStack)stack)).collect(Collectors.toList());
                    });
                    if (this.entry != null) {
                        widget.method_1852(this.entry.getWidget().method_1882());
                    } else {
                        widget.method_1852(((SearchFilteringRule)this.rule).filterStr);
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)new class_2588("rule.roughlyenoughitems.filtering.search.show").method_27692(class_124.field_1080));
                Function<Boolean, class_2561> function = bool -> new class_2588("rule.roughlyenoughitems.filtering.search.show." + bool);
                this.show = new FilteringRuleOptionsScreen.BooleanRuleEntry(this.field_22789 - 36, this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean(), this.rule, function);
                entryConsumer.accept(this.show);
                this.addEmpty(entryConsumer, 10);
                entryConsumer.accept(new FilteringRuleOptionsScreen.SubRulesEntry(this.rule, () -> (class_2561)function.apply(this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean()), Collections.singletonList(new EntryStacksRuleEntry((SearchFilteringRule)this.rule, () -> this.entryStacks, this.entry, this.show))));
            }

            @Override
            public void save() {
                ((SearchFilteringRule)this.rule).setFilter(this.entry.getWidget().method_1882());
                ((SearchFilteringRule)this.rule).show = this.show.getBoolean();
            }
        });
    }

    public static class EntryStacksRuleEntry
    extends FilteringRuleOptionsScreen.RuleEntry {
        private final Supplier<List<EntryWidget>> entryStacks;
        private int totalHeight;

        public EntryStacksRuleEntry(SearchFilteringRule rule, Supplier<List<EntryWidget>> entryStacks, FilteringRuleOptionsScreen.TextFieldRuleEntry entry, FilteringRuleOptionsScreen.BooleanRuleEntry show) {
            super(rule);
            this.entryStacks = entryStacks;
        }

        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            BatchedEntryRendererManager manager = new BatchedEntryRendererManager();
            int entrySize = EntryListWidget.entrySize();
            int width = entryWidth / entrySize;
            int i = 0;
            for (EntryWidget stack : this.entryStacks.get()) {
                stack.getBounds().setLocation(x + i % width * entrySize, y + i / width * entrySize);
                if (stack.getBounds().getMaxY() >= 0 && stack.getBounds().getY() <= class_310.method_1551().method_22683().method_4502()) {
                    manager.add(stack);
                }
                ++i;
            }
            manager.render(matrices, mouseX, mouseY, delta);
            this.totalHeight = (i / width + 1) * entrySize;
        }

        public int getItemHeight() {
            return this.totalHeight;
        }

        public List<? extends class_6379> narratables() {
            return Lists.newArrayList();
        }

        public List<? extends class_364> method_25396() {
            return Lists.newArrayList();
        }
    }
}

