/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3494;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5414;
import net.minecraft.class_5415;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDisplayViewingScreen
extends class_437
implements DisplayScreen {
    protected final Map<DisplayCategory<?>, List<DisplaySpec>> categoryMap;
    protected final List<DisplayCategory<?>> categories;
    protected List<EntryStack<?>> ingredientStackToNotice = new ArrayList();
    protected List<EntryStack<?>> resultStackToNotice = new ArrayList();
    protected int selectedCategoryIndex = 0;
    protected int tabsPerPage;
    protected Rectangle bounds;

    protected AbstractDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> categoryMap, @Nullable CategoryIdentifier<?> category, int tabsPerPage) {
        super(class_333.field_18967);
        this.categoryMap = categoryMap;
        this.categories = Lists.newArrayList(categoryMap.keySet());
        this.tabsPerPage = tabsPerPage;
        if (category != null) {
            for (int i = 0; i < this.categories.size(); ++i) {
                if (!this.categories.get(i).getCategoryIdentifier().equals(category)) continue;
                this.selectedCategoryIndex = i;
                break;
            }
        }
    }

    public List<class_364> _children() {
        return this.method_25396();
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void addIngredientToNotice(EntryStack<?> stack) {
        if (stack == null) {
            return;
        }
        this.ingredientStackToNotice.add(stack);
    }

    @Override
    public void addResultToNotice(EntryStack<?> stack) {
        if (stack == null) {
            return;
        }
        this.resultStackToNotice.add(stack);
    }

    @Override
    public List<EntryStack<?>> getIngredientsToNotice() {
        return Collections.unmodifiableList(this.ingredientStackToNotice);
    }

    @Override
    public List<EntryStack<?>> getResultsToNotice() {
        return Collections.unmodifiableList(this.resultStackToNotice);
    }

    @Override
    public DisplayCategory<Display> getCurrentCategory() {
        return this.categories.get(this.selectedCategoryIndex);
    }

    protected DisplayCategoryView<Display> getCurrentCategoryView(Display display) {
        return CategoryRegistry.getInstance().get(this.categories.get(this.selectedCategoryIndex).getCategoryIdentifier().cast()).getView(display);
    }

    @Override
    public void previousCategory() {
        int currentCategoryIndex = this.selectedCategoryIndex;
        if (--currentCategoryIndex < 0) {
            currentCategoryIndex = this.categories.size() - 1;
        }
        ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, this.categories.get(currentCategoryIndex).getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
    }

    @Override
    public void nextCategory() {
        int currentCategoryIndex = this.selectedCategoryIndex;
        if (++currentCategoryIndex >= this.categories.size()) {
            currentCategoryIndex = 0;
        }
        ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, this.categories.get(currentCategoryIndex).getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
    }

    protected void transformIngredientNotice(List<Widget> setupDisplay, List<EntryStack<?>> noticeStacks) {
        AbstractDisplayViewingScreen.transformNotice(1, setupDisplay, noticeStacks);
    }

    protected void transformResultNotice(List<Widget> setupDisplay, List<EntryStack<?>> noticeStacks) {
        AbstractDisplayViewingScreen.transformNotice(2, setupDisplay, noticeStacks);
    }

    private static void transformNotice(int marker, List<? extends class_364> setupDisplay, List<EntryStack<?>> noticeStacks) {
        if (noticeStacks.isEmpty()) {
            return;
        }
        block0: for (EntryWidget widget : Widgets.walk(setupDisplay, EntryWidget.class::isInstance)) {
            if (widget.getNoticeMark() != marker || widget.getEntries().size() <= 1) continue;
            for (EntryStack<?> noticeStack : noticeStacks) {
                EntryStack<?> stack = CollectionUtils.findFirstOrNullEqualsExact(widget.getEntries(), noticeStack);
                if (stack == null) continue;
                widget.clearStacks();
                widget.entry((EntryStack)stack);
                continue block0;
            }
        }
    }

    protected void transformFiltering(List<? extends class_364> setupDisplay) {
        for (EntryWidget widget : Widgets.walk(setupDisplay, EntryWidget.class::isInstance)) {
            Collection<EntryStack<?>> refiltered;
            if (widget.getEntries().size() <= 1 || (refiltered = EntryRegistry.getInstance().refilterNew(false, widget.getEntries())).isEmpty()) continue;
            widget.clearStacks();
            widget.entries(refiltered);
        }
    }

    protected void setupTags(List<Widget> widgets) {
        class_5415 tags = class_310.method_1551().method_1562().method_2867();
        block0: for (EntryWidget widget : Widgets.walk(widgets, EntryWidget.class::isInstance)) {
            Map.Entry firstOrNull;
            List<Object> objects;
            class_5414 collection;
            widget.removeTagMatch = false;
            if (widget.getEntries().size() <= 1) continue;
            EntryType<?> type = null;
            for (EntryStack<?> entry2 : widget.getEntries()) {
                if (type == null) {
                    type = entry2.getType();
                    continue;
                }
                if (type == entry2.getType()) continue;
                continue block0;
            }
            if (type == VanillaEntryTypes.ITEM) {
                collection = tags.method_33164(class_2378.field_25108);
                objects = CollectionUtils.map(widget.getEntries(), stack -> ((class_1799)stack.castValue()).method_7909());
            } else {
                if (type != VanillaEntryTypes.FLUID) continue;
                collection = tags.method_33164(class_2378.field_25103);
                objects = CollectionUtils.map(widget.getEntries(), stack -> ((FluidStack)stack.castValue()).getFluid());
            }
            if ((firstOrNull = CollectionUtils.findFirstOrNull(collection.method_30204().entrySet(), entry -> ((class_3494)entry.getValue()).method_15138().equals(objects))) == null) continue;
            widget.tagMatch = (class_2960)firstOrNull.getKey();
        }
    }
}

