/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.gui.toast.CopyRecipeIdentifierToast;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ArrowWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.BurningFireWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.DrawableWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.FillRectangleDrawableConsumer;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.LabelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TexturedDrawableConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class InternalWidgets {
    private InternalWidgets() {
    }

    public static Widget createAutoCraftingButtonWidget(final Rectangle displayBounds, Rectangle rectangle, class_2561 text, final Supplier<Display> displaySupplier, final Supplier<Collection<class_2960>> idsSupplier, final List<Widget> setupDisplay, DisplayCategory<?> category) {
        final Button autoCraftingButton = Widgets.createButton(rectangle, text).focusable(false).onClick(button -> AutoCraftingEvaluator.evaluateAutoCrafting(true, class_437.method_25442(), (Display)displaySupplier.get(), idsSupplier));
        return new DelegateWidget(autoCraftingButton){
            boolean didJustRender;
            {
                super(widget);
                this.didJustRender = false;
            }

            @Override
            public void method_25394(class_4587 poses, int mouseX, int mouseY, float delta) {
                this.didJustRender = false;
                AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, (Display)displaySupplier.get(), idsSupplier);
                autoCraftingButton.setEnabled(result.successful);
                autoCraftingButton.setTint(result.tint);
                if (result.hasApplicable && (this.containsMouse(mouseX, mouseY) || autoCraftingButton.isFocused()) && result.renderer != null) {
                    result.renderer.render(poses, mouseX, mouseY, delta, setupDisplay, displayBounds, (Display)displaySupplier.get());
                }
                this.renderIf(result.hasApplicable, poses, mouseX, mouseY, delta);
                if (this.didJustRender) {
                    if (!autoCraftingButton.isFocused() && this.containsMouse(mouseX, mouseY)) {
                        this.tryTooltip(result, new Point(mouseX, mouseY));
                    } else if (autoCraftingButton.isFocused()) {
                        Rectangle bounds = autoCraftingButton.getBounds();
                        this.tryTooltip(result, new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2));
                    }
                }
            }

            private void tryTooltip(AutoCraftingEvaluator.AutoCraftingResult result, Point point) {
                if (result.tooltipRenderer != null) {
                    result.tooltipRenderer.accept(point, Tooltip::queue);
                }
            }

            private void renderIf(boolean should, class_4587 poseStack, int mouseX, int mouseY, float delta) {
                if (should) {
                    this.didJustRender = true;
                    this.widget.method_25394(poseStack, mouseX, mouseY, delta);
                } else if (class_310.method_1551().field_1690.field_1827) {
                    this.didJustRender = true;
                    this.widget.method_25394(poseStack, mouseX, mouseY, delta);
                }
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                if (this.didJustRender && ((Display)displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesKey(keyCode, scanCode) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_1774.method_1455(((Display)displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.method_25404(keyCode, scanCode, modifiers);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.didJustRender && ((Display)displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesMouse(button) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_1774.method_1455(((Display)displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
    }

    public static WidgetWithBounds wrapLateRenderable(Widget widget) {
        return new LateRenderableWidget(widget);
    }

    public static Widget concatWidgets(Widget widget1, Widget widget2) {
        return new MergedWidget(widget2, widget1);
    }

    public static void attach() {
        ClientInternals.attachInstance(new WidgetsProvider(), ClientInternals.WidgetsProvider.class);
    }

    private static class LateRenderableWidget
    extends DelegateWidget
    implements LateRenderable {
        private LateRenderableWidget(Widget widget) {
            super(widget);
        }
    }

    private static class MergedWidget
    extends Widget {
        private final List<Widget> widgets;

        public MergedWidget(Widget widget1, Widget widget2) {
            this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            for (Widget widget : this.widgets) {
                widget.setZ(this.getZ());
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            for (Widget widget : this.widgets) {
                if (!widget.method_25401(mouseX, mouseY, amount)) continue;
                return true;
            }
            return false;
        }
    }

    private static class WidgetsProvider
    implements ClientInternals.WidgetsProvider {
        private WidgetsProvider() {
        }

        @Override
        public boolean isRenderingPanel(Panel panel) {
            return PanelWidget.isRendering(panel);
        }

        @Override
        public Widget createDrawableWidget(DrawableConsumer drawable) {
            return new DrawableWidget(drawable);
        }

        @Override
        public Slot createSlot(Point point) {
            return new EntryWidget(point);
        }

        @Override
        public Slot createSlot(Rectangle bounds) {
            return new EntryWidget(bounds);
        }

        @Override
        public Button createButton(Rectangle bounds, class_2561 text) {
            return new ButtonWidget(bounds, text);
        }

        @Override
        public Panel createPanelWidget(Rectangle bounds) {
            return new PanelWidget(bounds);
        }

        @Override
        public Label createLabel(Point point, class_5348 text) {
            return new LabelWidget(point, text);
        }

        @Override
        public Arrow createArrow(Rectangle rectangle) {
            return new ArrowWidget(rectangle);
        }

        @Override
        public BurningFire createBurningFire(Rectangle rectangle) {
            return new BurningFireWidget(rectangle);
        }

        @Override
        public DrawableConsumer createTexturedConsumer(class_2960 texture, int x, int y, int width, int height, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
            return new TexturedDrawableConsumer(texture, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight);
        }

        @Override
        public DrawableConsumer createFillRectangleConsumer(Rectangle rectangle, int color) {
            return new FillRectangleDrawableConsumer(rectangle, color);
        }
    }
}

