/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.Collection;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_5251;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class TagArgumentType
extends ArgumentType<class_3902, String[]> {
    public static final TagArgumentType INSTANCE = new TagArgumentType();
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final class_2583 STYLE = class_2583.field_24360.method_27703(class_5251.method_27717((int)10420212));

    @Override
    public String getName() {
        return "tag";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "$";
    }

    @Override
    public class_2583 getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getTagSearchMode();
    }

    @Override
    public String[] cacheData(EntryStack<?> stack) {
        Collection<class_2960> tags = stack.getTagsFor();
        if (tags.isEmpty()) {
            return EMPTY_ARRAY;
        }
        String[] arr = new String[tags.size()];
        int i = 0;
        for (class_2960 identifier : tags) {
            arr[i] = identifier.toString();
            ++i;
        }
        return arr;
    }

    @Override
    public boolean matches(String[] data, EntryStack<?> stack, String searchText, class_3902 filterData) {
        for (String tag : data) {
            if (tag.isEmpty() || !tag.contains(searchText)) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_3902 prepareSearchFilter(String searchText) {
        return class_3902.field_17274;
    }

    private TagArgumentType() {
    }
}

