/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ConfigHandler {
    public static PropertyMirror<Boolean> enableRecursiveOpening = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Integer> recursiveOpeningMaxBlocksDistance = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Boolean> enableDoors = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> enableFenceGates = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> enableTrapdoors = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static final ConfigTree CONFIG = ConfigTree.builder().beginValue("enableRecursiveOpening", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Whether the recursive opening feature should be enabled. This allows you to for example build a giant door with trapdoors which will all open at the same time, as long as they are connected. The 'recursiveOpeningMaxBlocksDistance' config option determines how far the function should search.").finishValue(arg_0 -> enableRecursiveOpening.mirror(arg_0)).beginValue("recursiveOpeningMaxBlocksDistance", (ConfigType)ConfigTypes.INTEGER, (Object)10).withComment("How many blocks the recursive function should search when 'enableRecursiveOpening' is enabled.").finishValue(arg_0 -> recursiveOpeningMaxBlocksDistance.mirror(arg_0)).beginValue("enableDoors", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("When enables, the mod works with double doors.").finishValue(arg_0 -> enableDoors.mirror(arg_0)).beginValue("enableFenceGates", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("When enables, the mod works with double fence gates.").finishValue(arg_0 -> enableFenceGates.mirror(arg_0)).beginValue("enableTrapdoors", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("When enables, the mod works with double trapdoors.").finishValue(arg_0 -> enableTrapdoors.mirror(arg_0)).build();

    private static void writeDefaultConfig(Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setup() {
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path p = Paths.get("config", "doubledoors-fabric.json");
        ConfigHandler.writeDefaultConfig(p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            System.out.println("Error loading config");
        }
    }
}

