/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import java.util.Random;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.mixin.accessor.EntityAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4980;
import net.minecraft.class_4981;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import org.jetbrains.annotations.Nullable;

public class EnderWhaleEntity
extends class_1307
implements class_4981 {
    private static final class_2940<Boolean> ALWAYS_SADDLED = class_2945.method_12791(EnderWhaleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> BOOST_TIME = class_2945.method_12791(EnderWhaleEntity.class, (class_2941)class_2943.field_13327);
    private final class_4980 saddledComponent;

    public EnderWhaleEntity(class_1299<? extends class_1307> entityType, class_1937 world) {
        super(entityType, world);
        this.saddledComponent = new class_4980(this.field_6011, BOOST_TIME, ALWAYS_SADDLED);
        this.field_6207 = new EnderWhaleMovementControl(this);
    }

    public static class_5132.class_5133 createEnderWhaleAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23719, 0.18).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23722, 1.5).method_26868(class_5134.field_23718, 2.5);
    }

    public static boolean canSpawn(class_1299<EnderWhaleEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, Random random) {
        class_2680 blockState = world.method_8320(pos);
        return random.nextInt(6) == 0 && pos.method_10264() > 40 && pos.method_10264() - world.method_8598(class_2902.class_2903.field_13202, pos).method_10264() > 20 && blockState.method_26215() && world.method_8390(class_1510.class, new class_238(pos).method_1014(80.0), class_1301.field_6155).isEmpty() && class_1948.method_8662((class_1922)world, (class_2338)pos, (class_2680)blockState, (class_3610)blockState.method_26227(), EntityInit.ENDER_WHALE_ENTITY);
    }

    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new FlyRandomlyGoal(this));
        this.field_6201.method_6277(4, (class_1352)new TemptGoal(this, 1.2, class_1856.method_8091((class_1935[])new class_1935[]{ItemInit.CHORUS_FRUIT_ON_A_STICK})));
        this.field_6201.method_6277(7, (class_1352)new LookWhereToFlyGoal(this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ALWAYS_SADDLED, (Object)true);
        this.field_6011.method_12784(BOOST_TIME, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.saddledComponent.method_26309(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.saddledComponent.method_26312(nbt);
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_31483();
    }

    public boolean method_5956() {
        class_1297 entity = this.method_5642();
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 playerEntity = (class_1657)entity;
        return playerEntity.method_6047().method_31574(ItemInit.CHORUS_FRUIT_ON_A_STICK);
    }

    public float method_26316() {
        return (float)this.method_26825(class_5134.field_23719) * 0.225f;
    }

    protected class_3414 method_5994() {
        return SoundInit.WHALE_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.WHALE_HURT_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundInit.WHALE_DEATH_EVENT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected float method_6107() {
        return 1.1f;
    }

    public int method_5970() {
        return 500;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!player.method_21823()) {
            if (!this.method_5782()) {
                if (!this.field_6002.field_9236) {
                    player.method_5804((class_1297)this);
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (((EntityAccessor)((Object)this)).getPassengerList().size() < 2) {
                if (!this.field_6002.field_9236) {
                    player.method_5873((class_1297)this, true);
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    public class_243 method_24829(class_1309 passenger) {
        class_2350 direction = this.method_5755();
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return super.method_24829(passenger);
        }
        int[][] is = class_5275.method_27934((class_2350)direction);
        class_2338 blockPos = this.method_24515();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_4050 entityPose : passenger.method_24831()) {
            class_238 box = passenger.method_24833(entityPose);
            int[][] var9 = is;
            int var10 = is.length;
            for (int var11 = 0; var11 < var10; ++var11) {
                class_243 vec3d;
                int[] js = var9[var11];
                mutable.method_10103(blockPos.method_10263() + js[0], blockPos.method_10264(), blockPos.method_10260() + js[1]);
                double d = this.field_6002.method_30347((class_2338)mutable);
                if (!class_5275.method_27932((double)d) || !class_5275.method_27933((class_1941)this.field_6002, (class_1309)passenger, (class_238)box.method_997(vec3d = class_243.method_26410((class_2382)mutable, (double)d)))) continue;
                passenger.method_18380(entityPose);
                return vec3d;
            }
        }
        return super.method_24829(passenger);
    }

    public void method_6091(class_243 movementInput) {
        class_1297 firstPassenger = this.method_31483();
        if (this.method_5782() && this.method_5956() && firstPassenger instanceof class_1657) {
            this.method_36456(firstPassenger.method_36454());
            this.field_5982 = this.method_36454();
            this.method_36457(firstPassenger.method_36455() * 0.5f);
            this.method_5710(this.method_36454(), this.method_36455());
            this.field_6283 = this.method_36454();
            this.field_6241 = this.method_36454();
            this.field_6013 = 1.0f;
            this.field_6281 = this.method_6029() * 0.1f;
            if (this.saddledComponent.field_23215 && this.saddledComponent.field_23216++ > this.saddledComponent.field_23217) {
                this.saddledComponent.field_23215 = false;
            }
            if (this.method_5787()) {
                float f = this.method_26316();
                if (this.saddledComponent.field_23215) {
                    f += f * 1.12f * class_3532.method_15374((float)((float)this.saddledComponent.field_23216 / (float)this.saddledComponent.field_23217 * (float)Math.PI));
                }
                this.method_6125(f);
                this.method_26315(new class_243(0.0, (double)(-firstPassenger.method_36455()) * (double)0.005f, 1.0));
                this.field_6210 = 0;
            } else {
                this.method_29242((class_1309)this, false);
                this.method_18799(class_243.field_1353);
            }
            this.method_36974();
        } else {
            this.field_6013 = 0.5f;
            this.field_6281 = 0.02f;
            this.method_26315(movementInput);
        }
    }

    public void method_26315(class_243 movementInput) {
        super.method_6091(movementInput);
    }

    public boolean method_6577() {
        return this.saddledComponent.method_26308(this.method_6051());
    }

    public void method_5865(class_1297 passenger) {
        super.method_5865(passenger);
        float offSet = 12.0f;
        if (passenger.equals((Object)this.method_5642())) {
            offSet = 1.0f;
        }
        float f = class_3532.method_15374((float)(this.field_6283 * ((float)Math.PI / 180))) * offSet;
        float g = class_3532.method_15362((float)(this.field_6283 * ((float)Math.PI / 180))) * offSet;
        passenger.method_5814(this.method_23317() + (double)(0.1f * f), this.method_23323(0.83f) + passenger.method_5678() + 0.0, this.method_23321() - (double)(0.1f * g));
    }

    public boolean method_5810() {
        return false;
    }

    private static class EnderWhaleMovementControl
    extends class_1335 {
        private final EnderWhaleEntity enderWhaleEntity;
        private int collisionCheckCooldown;
        private int waitCooldown;

        public EnderWhaleMovementControl(EnderWhaleEntity enderWhaleEntity) {
            super((class_1308)enderWhaleEntity);
            this.enderWhaleEntity = enderWhaleEntity;
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378 && this.collisionCheckCooldown-- <= 0) {
                this.collisionCheckCooldown += 3;
                class_243 vec3d = new class_243(this.field_6370 - this.enderWhaleEntity.method_23317(), this.field_6369 - this.enderWhaleEntity.method_23318(), this.field_6367 - this.enderWhaleEntity.method_23321());
                double d = Math.sqrt(vec3d.field_1352 * vec3d.field_1352 + vec3d.field_1351 * vec3d.field_1351 + vec3d.field_1350 * vec3d.field_1350);
                vec3d = new class_243(vec3d.field_1352 / d, vec3d.field_1351 / d, vec3d.field_1350 / d);
                if (!this.willCollide() && d > 1.0 || this.waitCooldown++ < 0 && d > 1.0) {
                    this.enderWhaleEntity.method_18799(vec3d.method_1021(0.12));
                } else {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    if (this.waitCooldown++ >= 200) {
                        this.waitCooldown = -40;
                    }
                }
            }
        }

        private boolean willCollide() {
            class_238 box = this.enderWhaleEntity.method_5829();
            return !this.enderWhaleEntity.field_6002.method_8587((class_1297)this.enderWhaleEntity, box = box.method_1014(0.2));
        }
    }

    private static class FlyRandomlyGoal
    extends class_1352 {
        private final EnderWhaleEntity enderWhaleEntity;

        public FlyRandomlyGoal(EnderWhaleEntity enderWhaleEntity) {
            this.enderWhaleEntity = enderWhaleEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1335 moveControl = this.enderWhaleEntity.method_5962();
            return !moveControl.method_6241();
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            Random random = this.enderWhaleEntity.method_6051();
            double randomX = 48.0 + (random.nextDouble() * 2.0 - 1.0) * 128.0;
            double randomZ = 48.0 + (random.nextDouble() * 2.0 - 1.0) * 128.0;
            double d = this.enderWhaleEntity.method_23317() + randomX;
            double e = this.enderWhaleEntity.method_23318() + (random.nextDouble() * 2.0 - 1.0) * 16.0;
            double f = this.enderWhaleEntity.method_23321() + randomZ;
            if (this.enderWhaleEntity.method_23318() < 40.0) {
                e = this.enderWhaleEntity.method_23318() + 16.0 * random.nextDouble();
            } else if (this.enderWhaleEntity.method_23318() > 100.0) {
                e = this.enderWhaleEntity.method_23318() - 16.0 * random.nextDouble();
            }
            this.enderWhaleEntity.method_5962().method_6239(d, e, f, 1.0);
        }
    }

    private static class TemptGoal
    extends class_1352 {
        private static final class_4051 TEMPTING_ENTITY_PREDICATE = class_4051.method_36626().method_18418(16.0).method_36627();
        private final class_4051 predicate;
        private final EnderWhaleEntity enderWhaleEntity;
        private final double speed;
        private double lastPlayerX;
        private double lastPlayerY;
        private double lastPlayerZ;
        private double lastPlayerPitch;
        private double lastPlayerYaw;
        protected class_1657 closestPlayer;
        private int cooldown;
        private final class_1856 food;

        public TemptGoal(EnderWhaleEntity entity, double speed, class_1856 food) {
            this.enderWhaleEntity = entity;
            this.speed = speed;
            this.food = food;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.predicate = TEMPTING_ENTITY_PREDICATE.method_33335().method_18420(this::isTemptedBy);
        }

        public boolean method_6264() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.closestPlayer = this.enderWhaleEntity.field_6002.method_18462(this.predicate, (class_1309)this.enderWhaleEntity);
            return this.closestPlayer != null;
        }

        private boolean isTemptedBy(class_1309 entity) {
            return this.food.method_8093(entity.method_6047()) || this.food.method_8093(entity.method_6079());
        }

        public boolean method_6266() {
            if (this.enderWhaleEntity.method_5858((class_1297)this.closestPlayer) < 36.0) {
                if (this.closestPlayer.method_5649(this.lastPlayerX, this.lastPlayerY, this.lastPlayerZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.closestPlayer.method_36455() - this.lastPlayerPitch) > 5.0 || Math.abs((double)this.closestPlayer.method_36454() - this.lastPlayerYaw) > 5.0) {
                    return false;
                }
            } else {
                this.lastPlayerX = this.closestPlayer.method_23317();
                this.lastPlayerY = this.closestPlayer.method_23318();
                this.lastPlayerZ = this.closestPlayer.method_23321();
            }
            this.lastPlayerPitch = this.closestPlayer.method_36455();
            this.lastPlayerYaw = this.closestPlayer.method_36454();
            return this.method_6264();
        }

        public void method_6269() {
            this.lastPlayerX = this.closestPlayer.method_23317();
            this.lastPlayerY = this.closestPlayer.method_23318();
            this.lastPlayerZ = this.closestPlayer.method_23321();
        }

        public void method_6270() {
            this.closestPlayer = null;
            this.enderWhaleEntity.method_5942().method_6340();
            this.cooldown = 100;
        }

        public void method_6268() {
            this.enderWhaleEntity.method_5988().method_6226((class_1297)this.closestPlayer, (float)(this.enderWhaleEntity.method_5986() + 20), (float)this.enderWhaleEntity.method_5978());
            if (this.enderWhaleEntity.method_5858((class_1297)this.closestPlayer) < 9.25) {
                this.enderWhaleEntity.method_5942().method_6340();
            } else {
                this.enderWhaleEntity.method_5942().method_6335((class_1297)this.closestPlayer, this.speed);
            }
        }
    }

    private static class LookWhereToFlyGoal
    extends class_1352 {
        private final EnderWhaleEntity enderWhaleEntity;

        public LookWhereToFlyGoal(EnderWhaleEntity enderWhaleEntity) {
            this.enderWhaleEntity = enderWhaleEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            class_243 vec3d = this.enderWhaleEntity.method_18798();
            this.enderWhaleEntity.method_36456(-((float)class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350)) * 57.295776f);
            this.enderWhaleEntity.field_6283 = this.enderWhaleEntity.method_36454();
        }
    }
}

