/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_2096;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2960;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.util.VersionUtils;

public class CommandUtils {
    public static final Method REGISTER_ARGUMENT_TYPE;
    public static final Method TEST_FLOAT_RANGE;

    public static void registerArgumentTypes(ArgumentTypeConsumer consumer) {
        consumer.register(Pehkui.id("scale_type").toString(), ScaleTypeArgumentType.class, ScaleTypeArgumentType::scaleType);
        consumer.register(Pehkui.id("scale_modifier").toString(), ScaleModifierArgumentType.class, ScaleModifierArgumentType::scaleModifier);
        consumer.register(Pehkui.id("scale_operation").toString(), ScaleOperationArgumentType.class, ScaleOperationArgumentType::operation);
    }

    public static boolean testFloatRange(class_2096.class_2099 range, float value) {
        try {
            if (TEST_FLOAT_RANGE != null) {
                return (Boolean)TEST_FLOAT_RANGE.invoke((Object)range, Float.valueOf(value));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Pehkui.LOGGER.catching((Throwable)e);
        }
        return false;
    }

    public static <T extends ArgumentType<?>> void registerConstantArgumentType(String id, Class<? extends T> argClass, Supplier<T> supplier) {
        if (REGISTER_ARGUMENT_TYPE != null) {
            try {
                REGISTER_ARGUMENT_TYPE.invoke(null, id, argClass, class_2319.class.getConstructor(Supplier.class).newInstance(supplier));
            }
            catch (Throwable e) {
                Pehkui.LOGGER.catching(e);
            }
        }
    }

    public static CompletableFuture<Suggestions> suggestIdentifiersIgnoringNamespace(String namespace, Iterable<class_2960> candidates, SuggestionsBuilder builder) {
        CommandUtils.forEachMatchingIgnoringNamespace(namespace, candidates, builder.getRemaining().toLowerCase(Locale.ROOT), Function.identity(), id -> builder.suggest(String.valueOf(id)));
        return builder.buildFuture();
    }

    public static <T> void forEachMatchingIgnoringNamespace(String namespace, Iterable<T> candidates, String string, Function<T, class_2960> idFunc, Consumer<T> action) {
        boolean hasColon = string.indexOf(58) > -1;
        for (T object : candidates) {
            class_2960 id = idFunc.apply(object);
            if (hasColon) {
                if (!CommandUtils.wordStartsWith(string, id.toString(), '_')) continue;
                action.accept(object);
                continue;
            }
            if (!CommandUtils.wordStartsWith(string, id.method_12836(), '_') && (!id.method_12836().equals(namespace) || !CommandUtils.wordStartsWith(string, id.method_12832(), '_'))) continue;
            action.accept(object);
        }
    }

    public static boolean wordStartsWith(String string, String substring, char wordSeparator) {
        int i = 0;
        while (!substring.startsWith(string, i)) {
            if ((i = substring.indexOf(wordSeparator, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        String mapped = "unset";
        try {
            boolean is118Minus;
            boolean is116Minus = VersionUtils.MINOR <= 16;
            boolean bl = is118Minus = VersionUtils.MINOR <= 18;
            if (is118Minus) {
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2316", "method_10017", "(Ljava/lang/String;Ljava/lang/Class;Lnet/minecraft/class_2314;)V");
                h.put(0, (Object)class_2316.class.getMethod(mapped, String.class, Class.class, class_2314.class));
            }
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2096$class_2099", "method_9047", is116Minus ? "(F)Z" : "(D)Z");
            h.put(1, (Object)class_2096.class_2099.class.getMethod(mapped, is116Minus ? Float.TYPE : Double.TYPE));
        }
        catch (NoSuchMethodException | SecurityException e1) {
            Pehkui.LOGGER.error("Last method lookup: {}", (Object)mapped);
            Pehkui.LOGGER.catching((Throwable)e1);
        }
        REGISTER_ARGUMENT_TYPE = (Method)h.get(0);
        TEST_FLOAT_RANGE = (Method)h.get(1);
    }

    @FunctionalInterface
    public static interface ArgumentTypeConsumer {
        public <T extends ArgumentType<?>> void register(String var1, Class<T> var2, Supplier<T> var3);
    }
}

