/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.extraorigins.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.origins.OriginsClient;
import moriyashiine.extraorigins.common.component.entity.MagicSporesComponent;
import moriyashiine.extraorigins.common.packet.ChangeSporePacket;
import moriyashiine.extraorigins.common.power.MagicSporesPower;
import moriyashiine.extraorigins.common.registry.ModComponents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class MagicSporesHandler {
    public static boolean sporeChanged = false;
    private static MagicSporesComponent.Mode targetMode = null;
    private static boolean renderModeSwitch = false;
    private static int timer = 0;

    public static void init() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            sporeChanged = false;
            targetMode = null;
            renderModeSwitch = false;
            timer = 0;
        });
        ClientTickEvents.END_CLIENT_TICK.register((Object)new ClientTickEvents.EndTick(){

            public void onEndTick(class_310 client) {
                if (client.field_1755 != null) {
                    return;
                }
                if (OriginsClient.usePrimaryActivePowerKeybind.method_1434() && PowerHolderComponent.hasPower((class_1297)client.field_1724, MagicSporesPower.class)) {
                    client.field_1729.method_1610();
                    this.changeTargetMode(client);
                    this.handleModeChange(client);
                    renderModeSwitch = true;
                } else {
                    client.field_1729.method_1612();
                    sporeChanged = false;
                    targetMode = null;
                    renderModeSwitch = false;
                    timer = 0;
                }
            }

            private void changeTargetMode(class_310 client) {
                double x = client.field_1729.method_1603() - (double)((float)client.method_22683().method_4480() / 2.0f);
                double y = (double)((float)client.method_22683().method_4507() / 2.0f) - client.field_1729.method_1604();
                if (Math.abs(x) > 48.0 || Math.abs(y) > 48.0) {
                    MagicSporesComponent.Mode modeFromDirection;
                    switch (class_2350.method_10142((double)x, (double)y, (double)0.0)) {
                        case field_11036: {
                            MagicSporesComponent.Mode mode = MagicSporesComponent.Mode.MOBILITY;
                            break;
                        }
                        case field_11039: {
                            MagicSporesComponent.Mode mode = MagicSporesComponent.Mode.OFFENSE;
                            break;
                        }
                        case field_11034: {
                            MagicSporesComponent.Mode mode = MagicSporesComponent.Mode.DEFENSE;
                            break;
                        }
                        default: {
                            MagicSporesComponent.Mode mode = modeFromDirection = null;
                        }
                    }
                    if (targetMode != modeFromDirection) {
                        targetMode = modeFromDirection;
                        timer = 0;
                    }
                } else {
                    targetMode = null;
                    timer = 0;
                }
            }

            private void handleModeChange(class_310 client) {
                if (targetMode != null && ((MagicSporesComponent)ModComponents.MAGIC_SPORES.get((Object)client.field_1724)).getMode() != targetMode) {
                    if (!sporeChanged) {
                        ++timer;
                    }
                    if (timer == 20) {
                        sporeChanged = true;
                        ChangeSporePacket.send(targetMode);
                        timer = 0;
                    }
                }
            }
        });
        HudRenderCallback.EVENT.register((Object)new HudRenderCallback(){
            private static final class_2960 ICONS = new class_2960("extraorigins", "textures/gui/icons.png");

            public void onHudRender(class_4587 matrixStack, float tickDelta) {
                if (!renderModeSwitch) {
                    return;
                }
                RenderSystem.setShaderTexture((int)0, (class_2960)ICONS);
                class_310.method_1551().field_1705.method_25302(matrixStack, class_310.method_1551().method_22683().method_4486() / 2 - 64, class_310.method_1551().method_22683().method_4502() / 2 - 64, 0, 0, 128, 128);
                this.renderSection(MagicSporesComponent.Mode.OFFENSE, matrixStack, -67, -28, 128);
                this.renderSection(MagicSporesComponent.Mode.DEFENSE, matrixStack, 34, -32, 160);
                this.renderSection(MagicSporesComponent.Mode.MOBILITY, matrixStack, -16, -71, 192);
                if (timer > 0) {
                    class_310.method_1551().field_1705.method_25302(matrixStack, class_310.method_1551().method_22683().method_4486() / 2 - 13, class_310.method_1551().method_22683().method_4502() / 2 - 13, 48, 128, 26, 26);
                    class_310.method_1551().field_1705.method_25302(matrixStack, class_310.method_1551().method_22683().method_4486() / 2 - 12, class_310.method_1551().method_22683().method_4502() / 2 - 12, 24, 128, 24, 24);
                    class_310.method_1551().field_1705.method_25302(matrixStack, class_310.method_1551().method_22683().method_4486() / 2 - 12, class_310.method_1551().method_22683().method_4502() / 2 - 12, 0, 128, 24, (int)(24.0f - 24.0f * ((float)(timer + 1) / 20.0f)));
                }
                RenderSystem.setShaderTexture((int)0, (class_2960)class_329.field_22737);
            }

            private void renderSection(MagicSporesComponent.Mode targetMode, class_4587 matrixStack, int posXOffset, int posYOffset, int u) {
                int v = 0;
                if (((MagicSporesComponent)ModComponents.MAGIC_SPORES.get((Object)class_310.method_1551().field_1724)).getMode() == targetMode) {
                    v += 64;
                } else if (MagicSporesHandler.targetMode == targetMode) {
                    v += 32;
                }
                class_310.method_1551().field_1705.method_25302(matrixStack, class_310.method_1551().method_22683().method_4486() / 2 + posXOffset, class_310.method_1551().method_22683().method_4502() / 2 + posYOffset, u, v, 32, 32);
            }
        });
    }
}

