/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.edibles.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ConfigHandler {
    public static PropertyMirror<Integer> maxItemUsesPerDaySingleItem = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> maxItemUsesPerDayTotal = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> weaknessDurationSeconds = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> glowEntityDurationSeconds = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> glowEntitiesAroundAffectedRadiusBlocks = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> _cooldownInMsBetweenUses = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> blazePowderStrengthDurationSeconds = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> magmaCreamFireResistanceDurationSeconds = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> sugarSpeedDurationSeconds = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> ghastTearDurationSeconds = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> phantomMembraneDurationSeconds = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> rabbitsFootDurationSeconds = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private static final ConfigTree CONFIG = ConfigTree.builder().beginValue("maxItemUsesPerDaySingleItem", (ConfigType)ConfigTypes.INTEGER, (Object)16).withComment("The maximum amount of an item a player can eat before receiving the weakness effect. A value of -1 disables this feature.").finishValue(arg_0 -> maxItemUsesPerDaySingleItem.mirror(arg_0)).beginValue("maxItemUsesPerDayTotal", (ConfigType)ConfigTypes.INTEGER, (Object)-1).withComment("The maximum of the total amount of items a player can eat before receiving the weakness effect. A value of -1 disables this feature.").finishValue(arg_0 -> maxItemUsesPerDayTotal.mirror(arg_0)).beginValue("weaknessDurationSeconds", (ConfigType)ConfigTypes.INTEGER, (Object)45).withComment("The duration of the weakness effect in seconds when eating too much of an item.").finishValue(arg_0 -> weaknessDurationSeconds.mirror(arg_0)).beginValue("glowEntityDurationSeconds", (ConfigType)ConfigTypes.INTEGER, (Object)20).withComment("When eating glowstone, the duration in seconds of how long entities around should be glowing with an outline. A value of 0 disables the item use.").finishValue(arg_0 -> glowEntityDurationSeconds.mirror(arg_0)).beginValue("glowEntitiesAroundAffectedRadiusBlocks", (ConfigType)ConfigTypes.INTEGER, (Object)32).withComment("For the glow effect, the radius in blocks around the player of entities affected.").finishValue(arg_0 -> glowEntitiesAroundAffectedRadiusBlocks.mirror(arg_0)).beginValue("_cooldownInMsBetweenUses", (ConfigType)ConfigTypes.INTEGER, (Object)1000).withComment("The time in miliseconds of cooldown in between uses of eating an edible.").finishValue(arg_0 -> _cooldownInMsBetweenUses.mirror(arg_0)).beginValue("blazePowderStrengthDurationSeconds", (ConfigType)ConfigTypes.INTEGER, (Object)15).withComment("After eating blaze powder, the duration in seconds of the strength effect the player receives. A value of 0 disables the item use.").finishValue(arg_0 -> blazePowderStrengthDurationSeconds.mirror(arg_0)).beginValue("magmaCreamFireResistanceDurationSeconds", (ConfigType)ConfigTypes.INTEGER, (Object)15).withComment("After eating magma cream, the duration in seconds of the fire resistance effect the player receives. A value of 0 disables the item use.").finishValue(arg_0 -> magmaCreamFireResistanceDurationSeconds.mirror(arg_0)).beginValue("sugarSpeedDurationSeconds", (ConfigType)ConfigTypes.INTEGER, (Object)15).withComment("After eating some sugar, the duration in seconds of the speed effect the player receives. A value of 0 disables the item use.").finishValue(arg_0 -> sugarSpeedDurationSeconds.mirror(arg_0)).beginValue("ghastTearDurationSeconds", (ConfigType)ConfigTypes.INTEGER, (Object)15).withComment("After eating a ghast tear, the duration in seconds of the regeneration effect the player receives. A value of 0 disables the item use.").finishValue(arg_0 -> ghastTearDurationSeconds.mirror(arg_0)).beginValue("phantomMembraneDurationSeconds", (ConfigType)ConfigTypes.INTEGER, (Object)15).withComment("After eating some phantom membrane, the duration in seconds of the slow falling effect the player receives. A value of 0 disables the item use.").finishValue(arg_0 -> phantomMembraneDurationSeconds.mirror(arg_0)).beginValue("rabbitsFootDurationSeconds", (ConfigType)ConfigTypes.INTEGER, (Object)15).withComment("After eating a rabbit's foot, the duration in seconds of the jump boost effect the player receives. A value of 0 disables the item use.").finishValue(arg_0 -> rabbitsFootDurationSeconds.mirror(arg_0)).build();

    private static void writeDefaultConfig(Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setup() {
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path p = Paths.get("config", "edibles-fabric.json");
        ConfigHandler.writeDefaultConfig(p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            System.out.println("Error loading config");
        }
    }
}

