/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guiclock.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ConfigHandler {
    public static PropertyMirror<Boolean> mustHaveClockInInventoryForGameTime = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> mustHaveClockInInventoryForRealTime = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> lowerClockWhenPlayerHasEffects = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> _24hourformat = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> showOnlyMinecraftClockIcon = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> showBothTimes = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> showRealTime = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> showRealTimeSeconds = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> showDaysPlayedWorld = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> clockPositionIsLeft = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> clockPositionIsCenter = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> clockPositionIsRight = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Integer> clockHeightOffset = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> clockWidthOffset = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> RGB_R = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> RGB_G = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> RGB_B = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    private static final ConfigTree CONFIG = ConfigTree.builder().beginValue("mustHaveClockInInventoryForGameTime", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("When enabled, will only show the game time when a clock is present in the inventory.").finishValue(arg_0 -> mustHaveClockInInventoryForGameTime.mirror(arg_0)).beginValue("mustHaveClockInInventoryForRealTime", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("When enabled, will only show the real time when a clock is present in the inventory.").finishValue(arg_0 -> mustHaveClockInInventoryForRealTime.mirror(arg_0)).beginValue("lowerClockWhenPlayerHasEffects", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Whether the clock in the GUI should be lowered when the player has potion effects to prevent overlap.").finishValue(arg_0 -> lowerClockWhenPlayerHasEffects.mirror(arg_0)).beginValue("_24hourformat", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Sets the format of the clock to the 24-hour format.").finishValue(arg_0 -> _24hourformat.mirror(arg_0)).beginValue("showOnlyMinecraftClockIcon", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("When enabled, shows the clock item icon instead of a clock with numbers.").finishValue(arg_0 -> showOnlyMinecraftClockIcon.mirror(arg_0)).beginValue("showBothTimes", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Show both in-game time and real local time.").finishValue(arg_0 -> showBothTimes.mirror(arg_0)).beginValue("showRealTime", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Show actual local time instead of in-game time.").finishValue(arg_0 -> showRealTime.mirror(arg_0)).beginValue("showRealTimeSeconds", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Show the seconds in the clock.").finishValue(arg_0 -> showRealTimeSeconds.mirror(arg_0)).beginValue("showDaysPlayedWorld", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Show the days played in the world.").finishValue(arg_0 -> showDaysPlayedWorld.mirror(arg_0)).beginValue("clockPositionIsLeft", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Places the GUI clock on the left.").finishValue(arg_0 -> clockPositionIsLeft.mirror(arg_0)).beginValue("clockPositionIsCenter", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Places the GUI clock in the middle.").finishValue(arg_0 -> clockPositionIsCenter.mirror(arg_0)).beginValue("clockPositionIsRight", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Places the GUI clock on the right.").finishValue(arg_0 -> clockPositionIsRight.mirror(arg_0)).beginValue("clockHeightOffset", (ConfigType)ConfigTypes.INTEGER, (Object)5).withComment("The vertical offset (y coord) for the Clock. This determines how far down the time should be on the screen. Can be changed to prevent GUIs from overlapping.").finishValue(arg_0 -> clockHeightOffset.mirror(arg_0)).beginValue("clockWidthOffset", (ConfigType)ConfigTypes.INTEGER, (Object)0).withComment("The horizontal offset (x coord) for the Clock.").finishValue(arg_0 -> clockWidthOffset.mirror(arg_0)).beginValue("RGB_R", (ConfigType)ConfigTypes.INTEGER, (Object)255).withComment("The red RGB value for the clock text.").finishValue(arg_0 -> RGB_R.mirror(arg_0)).beginValue("RGB_G", (ConfigType)ConfigTypes.INTEGER, (Object)255).withComment("The green RGB value for the clock text.").finishValue(arg_0 -> RGB_G.mirror(arg_0)).beginValue("RGB_B", (ConfigType)ConfigTypes.INTEGER, (Object)255).withComment("The blue RGB value for the clock text.").finishValue(arg_0 -> RGB_B.mirror(arg_0)).build();

    private static void writeDefaultConfig(Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setup() {
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path p = Paths.get("config", "guiclock-fabric.json");
        ConfigHandler.writeDefaultConfig(p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            System.out.println("Error loading config");
        }
    }
}

