/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common;

import java.util.List;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import top.theillusivec4.comforts.common.ComfortsComponents;
import top.theillusivec4.comforts.common.block.HammockBlock;
import top.theillusivec4.comforts.common.block.SleepingBagBlock;
import top.theillusivec4.comforts.common.config.ComfortsConfig;

public class ComfortsEvents {
    public static void setup() {
        EntitySleepEvents.ALLOW_SLEEPING.register(ComfortsEvents::trySleep);
        EntitySleepEvents.ALLOW_SLEEP_TIME.register(ComfortsEvents::canSleepNow);
        EntitySleepEvents.STOP_SLEEPING.register(ComfortsEvents::wakeUp);
    }

    private static void wakeUp(class_1309 livingEntity, class_2338 blockPos) {
        class_1937 world = livingEntity.field_6002;
        if (!world.field_9236) {
            livingEntity.method_18398().ifPresent(bedPos -> ComfortsComponents.SLEEP_TRACKER.maybeGet((Object)livingEntity).ifPresent(tracker -> {
                long wakeTime = world.method_8532();
                long timeSlept = wakeTime - tracker.getSleepTime();
                class_2680 state = world.method_8320(bedPos);
                if (state.method_26204() instanceof SleepingBagBlock) {
                    boolean broke = false;
                    if (timeSlept > 500L) {
                        List<class_1293> debuffs = ComfortsConfig.sleepingBagDebuffs;
                        for (class_1293 effect : debuffs) {
                            livingEntity.method_6092(new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578()));
                        }
                        if (world.field_9229.nextDouble() < ComfortsConfig.sleepingBagBreakage) {
                            broke = true;
                            class_2338 blockpos = bedPos.method_10093(((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10153());
                            world.method_8652(blockpos, class_2246.field_10124.method_9564(), 35);
                            world.method_8652(bedPos, class_2246.field_10124.method_9564(), 35);
                            if (livingEntity instanceof class_1657) {
                                ((class_1657)livingEntity).method_7353((class_2561)new class_2588("block.comforts.sleeping_bag.broke"), true);
                            }
                            world.method_8396(null, bedPos, class_3417.field_14983, class_3419.field_15245, 1.0f, 1.0f);
                            livingEntity.method_18399();
                        }
                    }
                    if (!broke) {
                        tracker.getAutoSleepPos().ifPresent(pos -> {
                            class_2338 blockpos = bedPos.method_10093(((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10153());
                            world.method_8652(blockpos, class_2246.field_10124.method_9564(), 35);
                            world.method_8652(bedPos, class_2246.field_10124.method_9564(), 35);
                            livingEntity.method_18399();
                        });
                    }
                }
                tracker.setWakeTime(wakeTime);
                tracker.setTiredTime(wakeTime + (long)((double)timeSlept / ComfortsConfig.sleepyFactor));
                tracker.setAutoSleepPos(null);
            }));
        }
    }

    private static class_1657.class_1658 trySleep(class_1657 player, class_2338 blockPos) {
        return ComfortsComponents.SLEEP_TRACKER.maybeGet((Object)player).map(tracker -> {
            long dayTime = player.field_6002.method_8532();
            tracker.setSleepTime(dayTime);
            if (ComfortsConfig.wellRested) {
                if (tracker.getWakeTime() > dayTime) {
                    tracker.setWakeTime(0L);
                    tracker.setTiredTime(0L);
                }
                if (tracker.getTiredTime() > dayTime) {
                    player.method_7353((class_2561)new class_2588("capability.comforts.not_sleepy"), true);
                    return class_1657.class_1658.field_7531;
                }
            }
            return null;
        }).orElse(null);
    }

    private static class_1269 canSleepNow(class_1657 player, class_2338 blockPos, boolean vanillaResult) {
        class_1937 world = player.method_5770();
        long worldTime = world.method_8532() % 24000L;
        if (world.method_8320(blockPos).method_26204() instanceof HammockBlock) {
            if (worldTime > 500L && worldTime < 11500L) {
                return class_1269.field_5812;
            }
            return ComfortsConfig.nightHammocks ? class_1269.field_5811 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static void setWakeTime(class_3218 serverWorld, long curTime) {
        boolean[] activeHammock = new boolean[]{false};
        List players = serverWorld.method_18456();
        for (class_1657 player : players) {
            player.method_18398().ifPresent(bedPos -> {
                if (player.method_6113() && serverWorld.method_8320(bedPos).method_26204() instanceof HammockBlock) {
                    activeHammock[0] = true;
                }
            });
            if (!activeHammock[0]) continue;
            break;
        }
        if (activeHammock[0] && serverWorld.method_8530()) {
            long i = curTime + 24000L;
            serverWorld.method_29199(i - i % 24000L - 12001L);
        }
    }
}

